/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.grave;

import dev.quarris.enigmaticgraves.compat.CompatManager;
import dev.quarris.enigmaticgraves.compat.CurioCompat;
import dev.quarris.enigmaticgraves.config.GraveConfigs;
import dev.quarris.enigmaticgraves.content.GraveEntity;
import dev.quarris.enigmaticgraves.grave.PlayerGraveEntry;
import dev.quarris.enigmaticgraves.grave.WorldGraveData;
import dev.quarris.enigmaticgraves.grave.data.CurioGraveData;
import dev.quarris.enigmaticgraves.grave.data.ExperienceGraveData;
import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import dev.quarris.enigmaticgraves.grave.data.PlayerInventoryGraveData;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.block.pattern.BlockPatternBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class GraveManager {
    public static final HashMap<ResourceLocation, Function<CompoundNBT, IGraveData>> GRAVE_DATA_SUPPLIERS = new HashMap();
    public static final HashMap<UUID, PlayerGraveEntry> LATEST_GRAVE_ENTRY = new HashMap();
    public static final DateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private static final BlockPattern VALID_PLACE = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"A", "A", "B"}).func_177662_a('A', b -> !b.func_177509_a().func_185904_a().func_76230_c()).func_177662_a('B', b -> b.func_177509_a().func_185904_a().func_76230_c()).func_177661_b();

    public static void init() {
        GRAVE_DATA_SUPPLIERS.put(PlayerInventoryGraveData.NAME, PlayerInventoryGraveData::new);
        GRAVE_DATA_SUPPLIERS.put(ExperienceGraveData.NAME, ExperienceGraveData::new);
        if (CompatManager.isCuriosLoaded()) {
            GRAVE_DATA_SUPPLIERS.put(CurioGraveData.NAME, CurioGraveData::new);
        }
    }

    public static WorldGraveData getWorldGraveData(IWorld world) {
        if (world instanceof ServerWorld) {
            MinecraftServer server = ((ServerWorld)world).func_73046_m();
            ServerWorld overworld = server.func_71218_a(World.field_234918_g_);
            return (WorldGraveData)overworld.func_217481_x().func_215752_a(WorldGraveData::new, WorldGraveData.NAME);
        }
        return null;
    }

    public static boolean shouldSpawnGrave(PlayerEntity player) {
        return !player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) && !player.func_175149_v();
    }

    public static void prepPlayerGrave(PlayerEntity player) {
        if (!GraveManager.shouldSpawnGrave(player)) {
            return;
        }
        PlayerGraveEntry entry = new PlayerGraveEntry(player.field_71071_by);
        LATEST_GRAVE_ENTRY.put(player.func_110124_au(), entry);
    }

    public static void populatePlayerGrave(PlayerEntity player, Collection<ItemStack> drops) {
        if (!LATEST_GRAVE_ENTRY.containsKey(player.func_110124_au())) {
            return;
        }
        PlayerGraveEntry entry = LATEST_GRAVE_ENTRY.get(player.func_110124_au());
        GraveManager.generateGraveDataList(player, entry, drops);
    }

    public static void spawnPlayerGrave(PlayerEntity player) {
        if (!LATEST_GRAVE_ENTRY.containsKey(player.func_110124_au())) {
            return;
        }
        WorldGraveData worldData = GraveManager.getWorldGraveData((IWorld)player.field_70170_p);
        PlayerGraveEntry entry = LATEST_GRAVE_ENTRY.get(player.func_110124_au());
        GraveEntity grave = GraveEntity.createGrave(player, entry.dataList);
        entry.graveUUID = grave.func_110124_au();
        entry.gravePos = grave.func_233580_cy_();
        player.field_70170_p.func_217376_c((Entity)grave);
        worldData.addGraveEntry(player.func_110124_au(), entry);
        LATEST_GRAVE_ENTRY.remove(player.func_110124_au());
    }

    public static void generateGraveDataList(PlayerEntity player, PlayerGraveEntry entry, Collection<ItemStack> drops) {
        IGraveData curiosData;
        ArrayList<IGraveData> dataList = new ArrayList<IGraveData>();
        PlayerInventoryGraveData playerInvData = new PlayerInventoryGraveData(entry.inventory, drops);
        dataList.add(playerInvData);
        GraveConfigs.Common.ExperienceHandling xpHandling = (GraveConfigs.Common.ExperienceHandling)((Object)GraveConfigs.COMMON.experienceGraveHandling.get());
        if (xpHandling != GraveConfigs.Common.ExperienceHandling.DROP) {
            int xp = 0;
            if (xpHandling == GraveConfigs.Common.ExperienceHandling.KEEP_VANILLA) {
                xp = player.func_70693_a(player);
                xp = ForgeEventFactory.getExperienceDrop((LivingEntity)player, (PlayerEntity)player, (int)xp);
            } else if (xpHandling == GraveConfigs.Common.ExperienceHandling.KEEP_ALL) {
                xp = (int)((float)xp + player.field_71106_cc * (float)player.func_71050_bK());
                while (player.field_71068_ca > 0) {
                    --player.field_71068_ca;
                    xp += player.func_71050_bK();
                }
            }
            ExperienceGraveData xpData = new ExperienceGraveData(xp);
            dataList.add(xpData);
        }
        if (CompatManager.isCuriosLoaded() && (curiosData = CurioCompat.generateCurioGraveData(player, drops)) != null) {
            dataList.add(curiosData);
        }
        playerInvData.addRemaining(drops);
        entry.dataList = dataList;
    }

    public static void setGraveRestored(UUID player, GraveEntity grave) {
        GraveManager.getWorldGraveData((IWorld)grave.field_70170_p).getGraveEntriesForPlayer(player).stream().filter(entry -> entry.graveUUID.equals(grave.func_110124_au())).findFirst().ifPresent(PlayerGraveEntry::setRestored);
    }

    public static boolean getSpawnPosition(World world, Vector3d deathPos, BlockPos.Mutable outPos) {
        GraveConfigs.Common configs = GraveConfigs.COMMON;
        BlockPos.Mutable pos = new BlockPos(deathPos).func_239590_i_();
        while (pos.func_177956_o() > 0) {
            BlockPos belowPos = new BlockPos((Vector3i)pos).func_177977_b();
            BlockState belowState = world.func_180495_p(belowPos);
            if (GraveManager.blocksMovement(belowState)) {
                outPos.func_189533_g((Vector3i)pos);
                return false;
            }
            pos = pos.func_189536_c(Direction.DOWN);
        }
        pos = new BlockPos(deathPos.field_72450_a, (double)((Integer)configs.scanHeight.get()).intValue(), deathPos.field_72449_c);
        for (int scan = 0; scan < (Integer)configs.scanRange.get(); ++scan) {
            BlockPos scanPos = new BlockPos((Vector3i)pos).func_177981_b(scan);
            if (!GraveManager.blocksMovement(world.func_180495_p(scanPos.func_177984_a())) && !GraveManager.blocksMovement(world.func_180495_p(scanPos)) && GraveManager.blocksMovement(world.func_180495_p(scanPos.func_177977_b()))) {
                outPos.func_189533_g((Vector3i)scanPos);
                return false;
            }
            if (scan <= 0 || GraveManager.blocksMovement(world.func_180495_p((scanPos = new BlockPos((Vector3i)pos).func_177979_c(scan)).func_177984_a())) || GraveManager.blocksMovement(world.func_180495_p(scanPos)) || !GraveManager.blocksMovement(world.func_180495_p(scanPos.func_177977_b()))) continue;
            outPos.func_189533_g((Vector3i)scanPos);
            return false;
        }
        if (!GraveManager.blocksMovement(world.func_180495_p((BlockPos)pos)) && !GraveManager.blocksMovement(world.func_180495_p(pos.func_177984_a()))) {
            outPos.func_189533_g((Vector3i)pos);
            return true;
        }
        outPos.func_189532_c(deathPos.field_72450_a, 1.0, deathPos.field_72449_c);
        return true;
    }

    private static boolean blocksMovement(BlockState state) {
        return state.func_185904_a().func_76230_c();
    }
}

