/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.grave;

import dev.quarris.enigmaticgraves.grave.GraveManager;
import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class PlayerGraveEntry
implements INBTSerializable<CompoundNBT> {
    public PlayerInventory inventory;
    public UUID graveUUID;
    public BlockPos gravePos;
    public Date timestamp;
    public List<IGraveData> dataList = new ArrayList<IGraveData>();
    private boolean restored;

    public PlayerGraveEntry(PlayerInventory inventory) {
        this.inventory = new PlayerInventory(inventory.field_70458_d);
        this.inventory.func_70455_b(inventory);
        this.timestamp = new Date();
    }

    public PlayerGraveEntry(CompoundNBT nbt) {
        this.dataList = new ArrayList<IGraveData>();
        this.deserializeNBT(nbt);
    }

    public String getEntryName(int id) {
        return String.format("death_%d_%s", id, GraveManager.TIMESTAMP_FORMAT.format(this.timestamp));
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_186854_a("Grave", this.graveUUID);
        nbt.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.gravePos));
        nbt.func_74772_a("Timestamp", this.timestamp.getTime());
        ListNBT dataNBT = new ListNBT();
        for (IGraveData data : this.dataList) {
            dataNBT.add((Object)data.serializeNBT());
        }
        nbt.func_218657_a("Data", (INBT)dataNBT);
        nbt.func_74757_a("Restored", this.restored);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.graveUUID = nbt.func_186857_a("Grave");
        this.gravePos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("Pos"));
        this.timestamp = new Date(nbt.func_74763_f("Timestamp"));
        ListNBT dataNBT = nbt.func_150295_c("Data", 10);
        for (INBT inbt : dataNBT) {
            CompoundNBT graveNBT = (CompoundNBT)inbt;
            ResourceLocation name = new ResourceLocation(graveNBT.func_74779_i("Name"));
            IGraveData data = GraveManager.GRAVE_DATA_SUPPLIERS.get(name).apply(graveNBT);
            this.dataList.add(data);
        }
        this.restored = nbt.func_74767_n("Restored");
    }

    public void setRestored() {
        this.restored = true;
    }

    public boolean isRestored() {
        return this.restored;
    }
}

