/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.grave;

import dev.quarris.enigmaticgraves.config.GraveConfigs;
import dev.quarris.enigmaticgraves.grave.PlayerGraveEntry;
import dev.quarris.enigmaticgraves.utils.ModRef;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.world.storage.WorldSavedData;

public class WorldGraveData
extends WorldSavedData {
    public static final String NAME = ModRef.res("graves").toString();
    private final Map<UUID, LinkedList<PlayerGraveEntry>> playerGraveEntries = new HashMap<UUID, LinkedList<PlayerGraveEntry>>();
    private final Set<UUID> restoredGraves = new HashSet<UUID>();

    public WorldGraveData() {
        super(NAME);
    }

    public LinkedList<PlayerGraveEntry> getGraveEntriesForPlayer(UUID playerUUID) {
        return this.playerGraveEntries.get(playerUUID);
    }

    public void setGraveRestored(UUID graveUUID) {
        this.restoredGraves.add(graveUUID);
        this.func_76185_a();
    }

    public void removeGraveRestored(UUID graveUUID) {
        this.restoredGraves.remove(graveUUID);
        this.func_76185_a();
    }

    public boolean isGraveRestored(UUID graveUUID) {
        return this.restoredGraves.contains(graveUUID);
    }

    public void addGraveEntry(UUID playerUUID, PlayerGraveEntry entry) {
        LinkedList entries = this.playerGraveEntries.computeIfAbsent(playerUUID, k -> new LinkedList());
        if (entries.size() >= (Integer)GraveConfigs.COMMON.graveEntryCount.get()) {
            entries.removeLast();
        }
        entries.addFirst(entry);
        this.func_76185_a();
    }

    public void clearGraveEntries(PlayerEntity player) {
        this.playerGraveEntries.remove(player.func_110124_au());
        this.func_76185_a();
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT playerGraveEntriesNBT = new ListNBT();
        for (UUID uuid : this.playerGraveEntries.keySet()) {
            CompoundNBT playerGravesNBT = new CompoundNBT();
            playerGravesNBT.func_186854_a("UUID", uuid);
            List entries = this.playerGraveEntries.get(uuid);
            ListNBT entriesNBT = new ListNBT();
            for (PlayerGraveEntry entry : entries) {
                entriesNBT.add((Object)entry.serializeNBT());
            }
            playerGravesNBT.func_218657_a("Entries", (INBT)entriesNBT);
            playerGraveEntriesNBT.add((Object)playerGravesNBT);
        }
        compound.func_218657_a("PlayerGraveEntries", (INBT)playerGraveEntriesNBT);
        ListNBT restoredGravesNBT = new ListNBT();
        for (UUID restoredGraveUUID : this.restoredGraves) {
            restoredGravesNBT.add((Object)NBTUtil.func_240626_a_((UUID)restoredGraveUUID));
        }
        compound.func_218657_a("RestoredGraves", (INBT)restoredGravesNBT);
        return compound;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.playerGraveEntries.clear();
        this.restoredGraves.clear();
        ListNBT playerGraveEntriesNBT = nbt.func_150295_c("PlayerGraveEntries", 10);
        for (INBT inbt : playerGraveEntriesNBT) {
            CompoundNBT playerGravesNBT = (CompoundNBT)inbt;
            UUID uuid = playerGravesNBT.func_186857_a("UUID");
            ListNBT entriesNBT = playerGravesNBT.func_150295_c("Entries", 10);
            LinkedList entries = this.playerGraveEntries.computeIfAbsent(uuid, k -> new LinkedList());
            for (int i = 0; i < entriesNBT.size(); ++i) {
                CompoundNBT entryNBT = entriesNBT.func_150305_b(i);
                PlayerGraveEntry entry = new PlayerGraveEntry(entryNBT);
                entries.addLast(entry);
            }
        }
        ListNBT restoredGravesNBT = nbt.func_150295_c("RestoredGraves", 10);
        for (INBT uuidNBT : restoredGravesNBT) {
            UUID restoredGraveUUID = NBTUtil.func_186860_b((INBT)uuidNBT);
            this.restoredGraves.add(restoredGraveUUID);
        }
    }
}

