/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.grave.data;

import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import dev.quarris.enigmaticgraves.utils.ModRef;
import dev.quarris.enigmaticgraves.utils.PlayerInventoryExtensions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CurioGraveData
implements IGraveData {
    public static final ResourceLocation NAME = ModRef.res("curios");
    public final Map<String, NonNullList<ItemStack>> curioStacks = new HashMap<String, NonNullList<ItemStack>>();
    public final Map<String, NonNullList<ItemStack>> curioCosmeticStacks = new HashMap<String, NonNullList<ItemStack>>();

    public CurioGraveData(ICuriosItemHandler curios, Collection<ItemStack> drops) {
        for (Map.Entry entry : curios.getCurios().entrySet()) {
            String id = (String)entry.getKey();
            ICurioStacksHandler curioItems = (ICurioStacksHandler)entry.getValue();
            NonNullList curioStacksList = NonNullList.func_191197_a((int)curioItems.getSlots(), (Object)ItemStack.field_190927_a);
            NonNullList curioCosmeticStacksList = NonNullList.func_191197_a((int)curioItems.getSlots(), (Object)ItemStack.field_190927_a);
            Iterator<ItemStack> ite = drops.iterator();
            block1: while (ite.hasNext()) {
                ItemStack stack;
                int slot;
                ItemStack drop = ite.next();
                for (slot = 0; slot < curioItems.getSlots(); ++slot) {
                    stack = curioItems.getStacks().getStackInSlot(slot);
                    if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)drop)) continue;
                    curioStacksList.set(slot, (Object)drop);
                    ite.remove();
                    continue block1;
                }
                for (slot = 0; slot < curioItems.getSlots(); ++slot) {
                    stack = curioItems.getCosmeticStacks().getStackInSlot(slot);
                    if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)drop)) continue;
                    curioCosmeticStacksList.set(slot, (Object)drop);
                    ite.remove();
                    continue block1;
                }
            }
            this.curioStacks.put(id, (NonNullList<ItemStack>)curioStacksList);
            this.curioCosmeticStacks.put(id, (NonNullList<ItemStack>)curioCosmeticStacksList);
        }
    }

    public CurioGraveData(CompoundNBT nbt) {
        this.deserializeNBT(nbt);
    }

    @Override
    public void restore(PlayerEntity player) {
        LazyOptional optional = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        optional.ifPresent(handler -> {
            ItemStack old;
            int slot;
            NonNullList<ItemStack> graveItems;
            ICurioStacksHandler stacks;
            Map curios = handler.getCurios();
            for (Map.Entry<String, NonNullList<ItemStack>> entry : this.curioStacks.entrySet()) {
                stacks = (ICurioStacksHandler)curios.get(entry.getKey());
                graveItems = entry.getValue();
                for (slot = 0; slot < graveItems.size(); ++slot) {
                    if (slot >= stacks.getSlots()) {
                        PlayerInventoryExtensions.tryAddItemToPlayerInvElseDrop(player, slot, (ItemStack)graveItems.get(slot));
                    }
                    old = stacks.getStacks().getStackInSlot(slot);
                    stacks.getStacks().setStackInSlot(slot, (ItemStack)graveItems.get(slot));
                    if (old.func_190926_b()) continue;
                    PlayerInventoryExtensions.tryAddItemToPlayerInvElseDrop(player, slot, old);
                }
            }
            for (Map.Entry<String, NonNullList<ItemStack>> entry : this.curioCosmeticStacks.entrySet()) {
                stacks = (ICurioStacksHandler)curios.get(entry.getKey());
                graveItems = entry.getValue();
                for (slot = 0; slot < graveItems.size(); ++slot) {
                    if (slot >= stacks.getSlots()) {
                        PlayerInventoryExtensions.tryAddItemToPlayerInvElseDrop(player, slot, (ItemStack)graveItems.get(slot));
                    }
                    old = stacks.getCosmeticStacks().getStackInSlot(slot);
                    stacks.getCosmeticStacks().setStackInSlot(slot, (ItemStack)graveItems.get(slot));
                    if (old.func_190926_b()) continue;
                    PlayerInventoryExtensions.tryAddItemToPlayerInvElseDrop(player, slot, old);
                }
            }
        });
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public CompoundNBT write(CompoundNBT nbt) {
        ListNBT stacksNBT = new ListNBT();
        for (Map.Entry<String, NonNullList<ItemStack>> entry : this.curioStacks.entrySet()) {
            CompoundNBT entryNBT = new CompoundNBT();
            entryNBT.func_74778_a("ID", entry.getKey());
            entryNBT.func_74768_a("Size", entry.getValue().size());
            entryNBT.func_218657_a("Stacks", (INBT)ItemStackHelper.func_191282_a((CompoundNBT)new CompoundNBT(), entry.getValue()));
            stacksNBT.add((Object)entryNBT);
        }
        nbt.func_218657_a("Stacks", (INBT)stacksNBT);
        ListNBT cosmeticStacksNBT = new ListNBT();
        for (Map.Entry<String, NonNullList<ItemStack>> entry : this.curioCosmeticStacks.entrySet()) {
            CompoundNBT entryNBT = new CompoundNBT();
            entryNBT.func_74778_a("ID", entry.getKey());
            entryNBT.func_74768_a("Size", entry.getValue().size());
            entryNBT.func_218657_a("Stacks", (INBT)ItemStackHelper.func_191282_a((CompoundNBT)new CompoundNBT(), entry.getValue()));
            cosmeticStacksNBT.add((Object)entryNBT);
        }
        nbt.func_218657_a("CosmeticStacks", (INBT)cosmeticStacksNBT);
        return nbt;
    }

    @Override
    public void read(CompoundNBT nbt) {
        ListNBT stacksNBT = nbt.func_150295_c("Stacks", 10);
        for (INBT inbt : stacksNBT) {
            CompoundNBT entryNBT = (CompoundNBT)inbt;
            String id = entryNBT.func_74779_i("ID");
            NonNullList stacks = NonNullList.func_191197_a((int)entryNBT.func_74762_e("Size"), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)entryNBT.func_74775_l("Stacks"), (NonNullList)stacks);
            this.curioStacks.put(id, (NonNullList<ItemStack>)stacks);
        }
        ListNBT cosmeticStacksNBT = nbt.func_150295_c("CosmeticStacks", 10);
        for (INBT inbt : cosmeticStacksNBT) {
            CompoundNBT entryNBT = (CompoundNBT)inbt;
            String id = entryNBT.func_74779_i("ID");
            NonNullList stacks = NonNullList.func_191197_a((int)entryNBT.func_74762_e("Size"), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)entryNBT.func_74775_l("Stacks"), (NonNullList)stacks);
            this.curioCosmeticStacks.put(id, (NonNullList<ItemStack>)stacks);
        }
    }
}

