/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.grave.data;

import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import dev.quarris.enigmaticgraves.utils.ModRef;
import dev.quarris.enigmaticgraves.utils.PlayerInventoryExtensions;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class PlayerInventoryGraveData
implements IGraveData {
    public static final ResourceLocation NAME = ModRef.res("player_inventory");
    private ListNBT data;
    private NonNullList<ItemStack> remainingItems;

    public PlayerInventoryGraveData(PlayerInventory inventory, Collection<ItemStack> drops) {
        PlayerInventory graveInv = new PlayerInventory(inventory.field_70458_d);
        graveInv.func_70455_b(inventory);
        block0: for (int slot = 0; slot < graveInv.func_70302_i_(); ++slot) {
            ItemStack stack = graveInv.func_70301_a(slot);
            Iterator<ItemStack> ite = drops.iterator();
            while (ite.hasNext()) {
                ItemStack drop = ite.next();
                if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)drop)) continue;
                ite.remove();
                continue block0;
            }
            graveInv.func_70304_b(slot);
        }
        this.data = graveInv.func_70442_a(new ListNBT());
    }

    public PlayerInventoryGraveData(CompoundNBT nbt) {
        this.deserializeNBT(nbt);
    }

    public void addRemaining(Collection<ItemStack> remaining) {
        this.remainingItems = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])remaining.toArray(new ItemStack[0]));
    }

    @Override
    public void restore(PlayerEntity player) {
        PlayerInventory highPriority = new PlayerInventory(player);
        highPriority.func_70443_b(this.data);
        PlayerInventory lowPriority = new PlayerInventory(player);
        lowPriority.func_70455_b(player.field_71071_by);
        player.field_71071_by.func_70455_b(highPriority);
        for (int slot = 0; slot < lowPriority.func_70302_i_(); ++slot) {
            ItemStack item = lowPriority.func_70301_a(slot);
            if (item.func_190926_b()) continue;
            PlayerInventoryExtensions.tryAddItemToPlayerInvElseDrop(player, slot, item);
        }
        if (this.remainingItems != null) {
            for (ItemStack remainingStack : this.remainingItems) {
                if (player.field_71071_by.func_70441_a(remainingStack)) continue;
                player.func_199701_a_(remainingStack);
            }
        }
    }

    @Override
    public CompoundNBT write(CompoundNBT nbt) {
        nbt.func_218657_a("Data", (INBT)this.data);
        if (this.remainingItems != null) {
            nbt.func_74768_a("RemainingSize", this.remainingItems.size());
            nbt.func_218657_a("Remaining", (INBT)ItemStackHelper.func_191282_a((CompoundNBT)new CompoundNBT(), this.remainingItems));
        }
        return nbt;
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.data = nbt.func_150295_c("Data", 10);
        if (nbt.func_74764_b("Remaining")) {
            int size = nbt.func_74762_e("RemainingSize");
            this.remainingItems = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)nbt.func_74775_l("Remaining"), this.remainingItems);
        }
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

