/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.setup;

import com.mojang.brigadier.CommandDispatcher;
import dev.quarris.enigmaticgraves.command.RestoreGraveCommand;
import dev.quarris.enigmaticgraves.grave.GraveManager;
import dev.quarris.enigmaticgraves.grave.PlayerGraveEntry;
import dev.quarris.enigmaticgraves.setup.Registry;
import java.util.LinkedList;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enigmaticgraves")
public class CommonEvents {
    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity) || event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        GraveManager.prepPlayerGrave(player);
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.isEndConquered()) {
            return;
        }
        ItemStack graveFinder = new ItemStack((IItemProvider)Registry.GRAVE_FINDER_ITEM.get());
        LinkedList<PlayerGraveEntry> entries = GraveManager.getWorldGraveData((IWorld)event.getPlayer().field_70170_p).getGraveEntriesForPlayer(event.getPlayer().func_110124_au());
        if (entries == null || entries.isEmpty()) {
            return;
        }
        PlayerGraveEntry latestEntry = entries.getFirst();
        CompoundNBT nbt = graveFinder.func_196082_o();
        nbt.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)latestEntry.gravePos));
        nbt.func_186854_a("GraveUUID", latestEntry.graveUUID);
        event.getPlayer().func_191521_c(graveFinder);
    }

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        RestoreGraveCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }
}

