/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.equipmentcompare;

import com.anthonyhilyard.equipmentcompare.Loader;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class EquipmentCompareConfig {
    public static final ForgeConfigSpec SPEC;
    public static final EquipmentCompareConfig INSTANCE;
    public final ForgeConfigSpec.BooleanValue defaultOn;
    public final ForgeConfigSpec.LongValue badgeBackgroundColor;
    public final ForgeConfigSpec.LongValue badgeBorderStartColor;
    public final ForgeConfigSpec.LongValue badgeBorderEndColor;
    public final ForgeConfigSpec.ConfigValue<String> badgeText;

    public EquipmentCompareConfig(ForgeConfigSpec.Builder build) {
        build.comment("Client Configuration").push("client").push("visual_options");
        this.badgeText = build.comment("The text shown on the badge above equipped tooltips.").define("badge_text", (Object)"Equipped");
        this.badgeBackgroundColor = build.comment("The background color of the \"equipped\" badge.").defineInRange("badge_bg", 0xF0101000L, 0L, 0xFFFFFFFFL);
        this.badgeBorderStartColor = build.comment("The start border color of the \"equipped\" badge.").defineInRange("badge_border_start", 3500839187L, 0L, 0xFFFFFFFFL);
        this.badgeBorderEndColor = build.comment("The end border color of the \"equipped\" badge.").defineInRange("badge_border_end", 1623360778L, 0L, 0xFFFFFFFFL);
        build.pop().push("control_options");
        this.defaultOn = build.comment("If the comparison tooltip should show by default (pressing bound key hides).").define("default_on", false);
        build.pop().pop();
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading e) {
        if (e.getConfig().getModId().equals("equipmentcompare")) {
            Loader.LOGGER.info("Equipment Compare config reloaded.");
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(EquipmentCompareConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (EquipmentCompareConfig)specPair.getLeft();
    }
}

