/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.equipmentcompare.mixin;

import com.anthonyhilyard.equipmentcompare.EquipmentCompare;
import com.anthonyhilyard.equipmentcompare.EquipmentCompareConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.MobEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ContainerScreen.class})
public class ContainerScreenMixin
extends Screen {
    @Shadow
    @Nullable
    protected Slot field_147006_u;

    protected ContainerScreenMixin(ITextComponent titleIn) {
        super(titleIn);
    }

    private static Rectangle2d calculateTooltipRect(ItemStack stack, MatrixStack mStack, List<? extends ITextProperties> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font) {
        int n;
        Rectangle2d rect = new Rectangle2d(0, 0, 0, 0);
        if (textLines.isEmpty()) {
            return rect;
        }
        RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, textLines, mStack, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return rect;
        }
        mouseX = event.getX();
        mouseY = event.getY();
        screenWidth = event.getScreenWidth();
        screenHeight = event.getScreenHeight();
        maxTextWidth = event.getMaxWidth();
        font = event.getFontRenderer();
        int tooltipTextWidth = 0;
        for (ITextProperties iTextProperties : textLines) {
            int textLineWidth = font.func_238414_a_(iTextProperties);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean needsWrap = false;
        boolean bl = true;
        int tooltipX = mouseX + 14;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 14 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<? extends ITextProperties> wrappedTextLines = new ArrayList<ITextProperties>();
            for (int i = 0; i < textLines.size(); ++i) {
                ITextProperties textLine = textLines.get(i);
                List wrappedLine = font.func_238420_b_().func_238362_b_(textLine, tooltipTextWidth, Style.field_240709_b_);
                if (i == 0) {
                    n = wrappedLine.size();
                }
                for (ITextProperties line : wrappedLine) {
                    int lineWidth = font.func_238414_a_(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add((ITextProperties)line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;
            tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 14;
        }
        int tooltipY = mouseY - 14;
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > n) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        rect = new Rectangle2d(tooltipX - 4, tooltipY - 4, tooltipTextWidth + 8, tooltipHeight + 8);
        return rect;
    }

    @Inject(method={"renderHoveredTooltip(Lcom/mojang/blaze3d/matrix/MatrixStack;II)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderHoveredTooltip(MatrixStack matrixStack, int x, int y, CallbackInfo info) {
        ItemStack itemStack;
        int bgColor = (int)((Long)EquipmentCompareConfig.INSTANCE.badgeBackgroundColor.get()).longValue();
        int borderStartColor = (int)((Long)EquipmentCompareConfig.INSTANCE.badgeBorderStartColor.get()).longValue();
        int borderEndColor = (int)((Long)EquipmentCompareConfig.INSTANCE.badgeBorderEndColor.get()).longValue();
        ItemStack itemStack2 = itemStack = this.field_147006_u != null ? this.field_147006_u.func_75211_c() : ItemStack.field_190927_a;
        if (this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && !itemStack.func_190926_b()) {
            EquipmentSlotType slot = MobEntity.func_184640_d((ItemStack)itemStack);
            if (slot == EquipmentSlotType.MAINHAND) {
                return;
            }
            ItemStack equippedItem = this.field_230706_i_.field_71439_g.func_184582_a(slot);
            if (equippedItem != ItemStack.field_190927_a && equippedItem != itemStack && EquipmentCompare.tooltipActive ^ (Boolean)EquipmentCompareConfig.INSTANCE.defaultOn.get()) {
                FontRenderer font = itemStack.func_77973_b().getFontRenderer(itemStack);
                if (font == null) {
                    font = this.field_230712_o_;
                }
                GuiUtils.preItemToolTip((ItemStack)itemStack);
                List itemStackTooltipLines = this.func_231151_a_(itemStack);
                List equippedTooltipLines = this.func_231151_a_(equippedItem);
                Rectangle2d itemStackRect = ContainerScreenMixin.calculateTooltipRect(itemStack, matrixStack, itemStackTooltipLines, x, y, this.field_230708_k_, this.field_230709_l_, 250, font);
                Rectangle2d equippedRect = ContainerScreenMixin.calculateTooltipRect(itemStack, matrixStack, equippedTooltipLines, x - itemStackRect.func_199316_c() - 14, y, this.field_230708_k_, this.field_230709_l_, 250, font);
                if (x + itemStackRect.func_199316_c() + 16 > this.field_230708_k_) {
                    itemStackRect = new Rectangle2d(this.field_230708_k_ - itemStackRect.func_199316_c() - 4, itemStackRect.func_199319_b(), itemStackRect.func_199316_c(), itemStackRect.func_199317_d());
                }
                StringTextComponent equippedBadge = new StringTextComponent((String)EquipmentCompareConfig.INSTANCE.badgeText.get());
                int tooltipWidth = equippedRect.func_199316_c();
                equippedRect = new Rectangle2d(equippedRect.func_199318_a(), equippedRect.func_199319_b(), Math.max(equippedRect.func_199316_c(), font.func_238414_a_((ITextProperties)equippedBadge) + 8), equippedRect.func_199317_d());
                equippedRect = new Rectangle2d(itemStackRect.func_199318_a() - equippedRect.func_199316_c() - 16 - (equippedRect.func_199316_c() - tooltipWidth) / 2, equippedRect.func_199319_b(), equippedRect.func_199316_c(), equippedRect.func_199317_d());
                if (equippedRect.func_199318_a() < 0) {
                    equippedRect = new Rectangle2d(0, equippedRect.func_199319_b(), equippedRect.func_199316_c(), equippedRect.func_199317_d());
                    itemStackRect = new Rectangle2d(equippedRect.func_199316_c() + 16, itemStackRect.func_199319_b(), itemStackRect.func_199316_c(), itemStackRect.func_199317_d());
                }
                GuiUtils.drawHoveringText((MatrixStack)matrixStack, (List)itemStackTooltipLines, (int)(itemStackRect.func_199318_a() - 10), (int)y, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)250, (FontRenderer)font);
                GuiUtils.postItemToolTip();
                GuiUtils.preItemToolTip((ItemStack)equippedItem);
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, 0.0, 401.0);
                IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(equippedRect.func_199318_a() + 1), (int)(equippedRect.func_199319_b() - 15), (int)(equippedRect.func_199318_a() + equippedRect.func_199316_c() - 1), (int)(equippedRect.func_199319_b() - 14), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(equippedRect.func_199318_a() + 1), (int)(equippedRect.func_199319_b() - 2), (int)(equippedRect.func_199318_a() + equippedRect.func_199316_c() - 1), (int)(equippedRect.func_199319_b() - 1), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(equippedRect.func_199318_a() + 1), (int)(equippedRect.func_199319_b() - 14), (int)(equippedRect.func_199318_a() + equippedRect.func_199316_c() - 1), (int)(equippedRect.func_199319_b() - 2), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)equippedRect.func_199318_a(), (int)(equippedRect.func_199319_b() - 14), (int)(equippedRect.func_199318_a() + 1), (int)(equippedRect.func_199319_b() - 2), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(equippedRect.func_199318_a() + equippedRect.func_199316_c() - 1), (int)(equippedRect.func_199319_b() - 14), (int)(equippedRect.func_199318_a() + equippedRect.func_199316_c()), (int)(equippedRect.func_199319_b() - 2), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(equippedRect.func_199318_a() + 1), (int)(equippedRect.func_199319_b() - 13), (int)(equippedRect.func_199318_a() + 2), (int)(equippedRect.func_199319_b() - 3), (int)borderStartColor, (int)borderEndColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(equippedRect.func_199318_a() + equippedRect.func_199316_c() - 2), (int)(equippedRect.func_199319_b() - 13), (int)(equippedRect.func_199318_a() + equippedRect.func_199316_c() - 1), (int)(equippedRect.func_199319_b() - 3), (int)borderStartColor, (int)borderEndColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(equippedRect.func_199318_a() + 1), (int)(equippedRect.func_199319_b() - 14), (int)(equippedRect.func_199318_a() + equippedRect.func_199316_c() - 1), (int)(equippedRect.func_199319_b() - 13), (int)borderStartColor, (int)borderStartColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(equippedRect.func_199318_a() + 1), (int)(equippedRect.func_199319_b() - 3), (int)(equippedRect.func_199318_a() + equippedRect.func_199316_c() - 1), (int)(equippedRect.func_199319_b() - 2), (int)borderEndColor, (int)borderEndColor);
                font.func_238416_a_(LanguageMap.func_74808_a().func_241870_a((ITextProperties)equippedBadge), (float)equippedRect.func_199318_a() + (float)((equippedRect.func_199316_c() - font.func_238414_a_((ITextProperties)equippedBadge)) / 2), (float)equippedRect.func_199319_b() - 12.0f, -1, true, matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderType, false, 0, 0xF000F0);
                renderType.func_228461_a_();
                matrixStack.func_227865_b_();
                GuiUtils.drawHoveringText((MatrixStack)matrixStack, (List)equippedTooltipLines, (int)(equippedRect.func_199318_a() - 8), (int)y, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)250, (FontRenderer)font);
                GuiUtils.postItemToolTip();
                info.cancel();
                return;
            }
            return;
        }
    }
}

