/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.eyes;

import com.google.common.base.Stopwatch;
import gigaherz.eyes.config.BiomeRules;
import gigaherz.eyes.config.ConfigData;
import gigaherz.eyes.config.DimensionRules;
import gigaherz.eyes.entity.EyesEntity;
import java.lang.reflect.Field;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EyesSpawningManager {
    private static final Logger LOGGER = LogManager.getLogger();
    @CapabilityInject(value=EyesSpawningManager.class)
    public static Capability<EyesSpawningManager> INSTANCE;
    private static final ResourceLocation CAP_KEY;
    private final Stopwatch watch = Stopwatch.createUnstarted();
    private final ServerLevel parent;
    private final ServerChunkCache chunkSource;
    private int cooldown;
    private int ticks;
    private static final Field f_spawnEnemies;

    public static void init() {
        CapabilityManager.INSTANCE.register(EyesSpawningManager.class);
        MinecraftForge.EVENT_BUS.addGenericListener(Level.class, EyesSpawningManager::onCapabilityAttach);
        MinecraftForge.EVENT_BUS.addListener(EyesSpawningManager::onWorldTick);
    }

    private static void onCapabilityAttach(AttachCapabilitiesEvent<Level> event) {
        final Level eventWorld = (Level)event.getObject();
        if (eventWorld instanceof ServerLevel) {
            event.addCapability(CAP_KEY, new ICapabilityProvider(){
                final ServerLevel world;
                final LazyOptional<EyesSpawningManager> supplier;
                {
                    this.world = (ServerLevel)eventWorld;
                    this.supplier = LazyOptional.of(() -> new EyesSpawningManager(this.world));
                }

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    if (cap == INSTANCE) {
                        return this.supplier.cast();
                    }
                    return LazyOptional.empty();
                }
            });
        }
    }

    private static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world.f_46443_) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        event.world.getCapability(INSTANCE).ifPresent(EyesSpawningManager::tick);
    }

    private EyesSpawningManager(ServerLevel world) {
        this.parent = world;
        this.chunkSource = this.parent.m_7726_();
        this.cooldown = 0;
    }

    public static int getDaysUntilNextHalloween() {
        Calendar nextHalloween;
        Calendar now = Calendar.getInstance();
        if (now.after(nextHalloween = new Calendar.Builder().setDate(now.get(1), 9, 31).setTimeOfDay(23, 59, 59, 999).build())) {
            nextHalloween.add(1, 1);
        }
        return (int)Math.min(ChronoUnit.DAYS.between(now.toInstant(), nextHalloween.toInstant()), 30L);
    }

    public static int getMinutesToMidnight() {
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        if (hour > 12) {
            hour -= 24;
        }
        return Math.abs(hour * 24 + minute);
    }

    private boolean isEnemySpawnEnabled() {
        try {
            return (Boolean)f_spawnEnemies.get(this.chunkSource);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error accessing field", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tick() {
        if (--this.cooldown > 0) {
            return;
        }
        this.cooldown = 150;
        if (!ConfigData.enableNaturalSpawn || !this.parent.m_46469_().m_46207_(GameRules.f_46134_)) {
            return;
        }
        if (!this.isEnemySpawnEnabled()) {
            return;
        }
        if (!DimensionRules.isDimensionAllowed(this.parent)) {
            return;
        }
        try {
            this.watch.start();
            ++this.ticks;
            int daysUntilNextHalloween = EyesSpawningManager.getDaysUntilNextHalloween();
            int minutesToMidnight = EyesSpawningManager.getMinutesToMidnight();
            this.cooldown = this.calculateSpawnCycleInterval(daysUntilNextHalloween, minutesToMidnight);
            int maxTotalEyesPerDimension = this.calculateMaxTotalEyesPerDimension(daysUntilNextHalloween, minutesToMidnight);
            int maxEyesAroundPlayer = this.calculateMaxEyesAroundPlayer(daysUntilNextHalloween, minutesToMidnight);
            int count = this.parent.m_143280_(EyesEntity.TYPE, e -> e.countsTowardSpawnCap()).size();
            if (count >= maxTotalEyesPerDimension) {
                return;
            }
            float d = (float)ConfigData.maxEyesSpawnDistance * 1.5f;
            float dSqr = d * d;
            AABB size = AABB.m_165882_((Vec3)Vec3.f_82478_, (double)d, (double)d, (double)d);
            List players = this.parent.m_6907_();
            int wrap = 20;
            for (ServerPlayer player : players) {
                List entities;
                if ((player.m_142049_() + this.ticks) % wrap != 0 || player.m_5833_() || (entities = this.parent.m_142425_(EyesEntity.TYPE, size.m_82383_(player.m_20182_()), e -> !e.countsTowardSpawnCap() && e.m_20280_((Entity)player) <= (double)dSqr)).size() >= maxEyesAroundPlayer) continue;
                this.spawnOneAround(player.m_20182_(), player, ConfigData.maxEyesSpawnDistance);
            }
        }
        finally {
            this.watch.stop();
            long us = this.watch.elapsed(TimeUnit.MICROSECONDS);
            if (us > ConfigData.longSpawnCycleWarning) {
                LOGGER.warn("WARNING: Unexpectedly long spawn cycle. It ran for {}ms!", (Object)((double)us / 1000.0));
            }
            this.watch.reset();
        }
    }

    private int calculateSpawnCycleInterval(int daysUntilNextHalloween, int minutesToMidnight) {
        return Math.max(1, this.calculateTimeBasedValueMin(ConfigData.spawnCycleIntervalNormal, ConfigData.spawnCycleIntervalMidnight, ConfigData.spawnCycleIntervalHalloween, daysUntilNextHalloween, minutesToMidnight));
    }

    private int calculateMaxTotalEyesPerDimension(int daysUntilNextHalloween, int minutesToMidnight) {
        return Math.max(1, this.calculateTimeBasedValueMax(ConfigData.maxTotalEyesPerDimensionNormal, ConfigData.maxTotalEyesPerDimensionMidnight, ConfigData.maxTotalEyesPerDimensionHalloween, daysUntilNextHalloween, minutesToMidnight));
    }

    private int calculateMaxEyesAroundPlayer(int daysUntilNextHalloween, int minutesToMidnight) {
        return Math.max(1, this.calculateTimeBasedValueMax(ConfigData.maxEyesAroundPlayerNormal, ConfigData.maxEyesAroundPlayerMidnight, ConfigData.maxEyesAroundPlayerHalloween, daysUntilNextHalloween, minutesToMidnight));
    }

    private int calculateTimeBasedValueMax(int normal, int midnight, int halloween, int daysUntilNextHalloween, int minutesToMidnight) {
        int valueByTime = normal + (midnight - normal) * Math.max(0, 240 - minutesToMidnight) / 240;
        int valueByDate = normal + (halloween - normal) * Math.max(0, 30 - daysUntilNextHalloween) / 30;
        return Math.max(valueByDate, valueByTime);
    }

    private int calculateTimeBasedValueMin(int normal, int midnight, int halloween, int daysUntilNextHalloween, int minutesToMidnight) {
        int valueByTime = normal + (midnight - normal) * Math.max(0, 240 - minutesToMidnight) / 240;
        int valueByDate = normal + (halloween - normal) * Math.max(0, 30 - daysUntilNextHalloween) / 30;
        return Math.min(valueByDate, valueByTime);
    }

    private void spawnOneAround(Vec3 positionVec, ServerPlayer player, float d) {
        float dSqr = d * d;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 100; ++i) {
            EyesEntity entity;
            double sX = (double)((1.0f - 2.0f * this.parent.f_46441_.nextFloat()) * d) + positionVec.m_7096_();
            double sZ = (double)((1.0f - 2.0f * this.parent.f_46441_.nextFloat()) * d) + positionVec.m_7094_();
            pos.m_122169_(sX, 0.0, sZ);
            int maxY = this.parent.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_());
            double sY = Mth.m_14008_((double)((double)(this.parent.f_46441_.nextFloat() * d) + positionVec.m_7098_()), (double)0.0, (double)maxY);
            pos.m_142448_((int)sY);
            double pX = (double)pos.m_123341_() + 0.5;
            double pY = pos.m_123342_();
            double pZ = (double)pos.m_123343_() + 0.5;
            double distanceSq = player.m_20275_(pX, pY, pZ);
            if (!(distanceSq < (double)dSqr) || !EyesSpawningManager.isValidSpawnSpot(this.parent, EyesEntity.TYPE, (BlockPos)pos, distanceSq) || (entity = (EyesEntity)EyesEntity.TYPE.m_20655_(this.parent, null, null, null, (BlockPos)pos, MobSpawnType.NATURAL, false, false)) == null) continue;
            int canSpawn = ForgeHooks.canEntitySpawn((Mob)entity, (LevelAccessor)this.parent, (double)pX, (double)pY, (double)pZ, null, (MobSpawnType)MobSpawnType.NATURAL);
            if (canSpawn != -1 && (canSpawn == 1 || entity.m_5545_((LevelAccessor)this.parent, MobSpawnType.NATURAL) && entity.m_6914_((LevelReader)this.parent))) {
                this.parent.m_7967_((Entity)entity);
                return;
            }
            entity.m_146870_();
        }
    }

    private static boolean isValidSpawnSpot(ServerLevel serverWorld, EntityType<?> entityType, BlockPos pos, double sqrDistanceToClosestPlayer) {
        int instantDespawnDistance = entityType.m_20674_().m_21611_();
        if (!entityType.m_20673_() && sqrDistanceToClosestPlayer > (double)(instantDespawnDistance * instantDespawnDistance)) {
            return false;
        }
        if (!BiomeRules.isBiomeAllowed(serverWorld.m_46857_(pos))) {
            return false;
        }
        return SpawnPlacements.m_21759_(entityType, (ServerLevelAccessor)serverWorld, (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)pos, (Random)serverWorld.f_46441_) && serverWorld.m_45772_(entityType.m_20585_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5));
    }

    static {
        CAP_KEY = new ResourceLocation("eyesinthedarkness:eyes_spawning_manager");
        f_spawnEnemies = ObfuscationReflectionHelper.findField(ServerChunkCache.class, (String)"f_8335_");
    }
}

