/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.eyes.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import gigaherz.eyes.EyesInTheDarkness;
import gigaherz.eyes.config.ConfigData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="eyesinthedarkness", bus=Mod.EventBusSubscriber.Bus.MOD)
public class JumpscareOverlay
extends GuiComponent
implements IIngameOverlay {
    private static final ResourceLocation TEXTURE_EYES = EyesInTheDarkness.location("textures/entity/eyes2.png");
    private static final ResourceLocation TEXTURE_FLASH = EyesInTheDarkness.location("textures/creepy.png");
    public static JumpscareOverlay INSTANCE = new JumpscareOverlay();
    private static final Rect2i[] FRAMES = new Rect2i[]{new Rect2i(0, 0, 13, 6), new Rect2i(0, 7, 13, 6), new Rect2i(0, 14, 13, 6), new Rect2i(0, 21, 13, 6), new Rect2i(15, 1, 15, 8), new Rect2i(15, 16, 15, 12)};
    private static final int ANIMATION_APPEAR = 10;
    private static final int ANIMATION_LINGER = 90;
    private static final int ANIMATION_BLINK = 60;
    private static final int ANIMATION_SCARE1 = 20;
    private static final int ANIMATION_FADE = 20;
    private static final int ANIMATION_BLINK_START = 100;
    private static final int ANIMATION_SCARE_START = 160;
    private static final int ANIMATION_FADE_START = 180;
    private static final int ANIMATION_TOTAL = 200;
    private Minecraft mc = Minecraft.m_91087_();
    private boolean visible = false;
    private float progress = 0.0f;

    @SubscribeEvent
    public static void register(FMLClientSetupEvent event) {
        OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.PORTAL_ELEMENT, (String)"Eyes in the Darkness Jumpscare", (IIngameOverlay)INSTANCE);
    }

    private JumpscareOverlay() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void show(double ex, double ey, double ez) {
        if (ConfigData.jumpscareClient) {
            this.visible = true;
            this.mc.f_91073_.m_7785_(ex, ey, ez, EyesInTheDarkness.eyes_jumpscare, SoundSource.HOSTILE, this.getJumpscareVolume(), 1.0f, false);
        }
    }

    protected float getJumpscareVolume() {
        return (float)ConfigData.eyeIdleVolume;
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (this.visible) {
            this.progress += 1.0f;
            if (this.progress >= 200.0f) {
                this.visible = false;
                this.progress = 0.0f;
            }
        }
    }

    public void render(ForgeIngameGui gui, PoseStack poseStack, float partialTicks, int width, int height) {
        if (!this.visible) {
            return;
        }
        int screenWidth = this.mc.m_91268_().m_85445_();
        int screenHeight = this.mc.m_91268_().m_85446_();
        float time = this.progress + Animation.getPartialTickTime();
        if (time >= 200.0f) {
            this.visible = false;
            this.progress = 0.0f;
            return;
        }
        RenderSystem.m_69421_((int)256, (boolean)false);
        poseStack.m_85836_();
        float darkening = Mth.m_14036_((float)Math.min(time / 10.0f, (200.0f - time) / 20.0f), (float)0.0f, (float)1.0f);
        boolean showCreep = false;
        int blinkstate = 0;
        if (time >= 100.0f) {
            if (time >= 160.0f) {
                blinkstate = 1;
                showCreep = time - 160.0f > 20.0f;
            } else {
                float fade = Math.max(0.0f, (time - 100.0f) / 60.0f);
                float blinkspeed = (float)(1.0 + Math.pow(fade, 3.0));
                blinkstate = Mth.m_14143_((float)(20.0f * blinkspeed)) & 1;
                showCreep = blinkstate == 1;
            }
        }
        int alpha = Mth.m_14143_((float)(darkening * 255.0f));
        if (showCreep) {
            int texW = 2048;
            int texH = 1024;
            float scale1 = (float)screenHeight / (float)texH;
            int drawY = 0;
            int drawH = screenHeight;
            int drawW = Mth.m_14143_((float)((float)texW * scale1));
            int drawX = (screenWidth - drawW) / 2;
            this.drawScaledCustomTexture(TEXTURE_FLASH, poseStack, texW, texH, 0, 0, texW, texH, drawX, drawY, drawW, drawH, alpha << 24 | 0xFFFFFF);
        } else {
            PoseStack temp = new PoseStack();
            JumpscareOverlay.m_93172_((PoseStack)temp, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)(alpha << 24));
        }
        if (blinkstate != 1) {
            float scale = Float.MAX_VALUE;
            for (Rect2i r : FRAMES) {
                float s = Math.min(Mth.m_14107_((double)((double)screenWidth * 0.8 / (double)r.m_110090_())), Mth.m_14107_((double)((double)screenHeight * 0.8 / (double)r.m_110091_())));
                scale = Math.min(scale, s);
            }
            scale = Math.min(1.0f, (1.0f + time) / 11.0f) * scale;
            int currentFrame = Math.min(FRAMES.length - 1, Mth.m_14143_((float)((float)FRAMES.length * time / 10.0f)));
            Rect2i rect = FRAMES[currentFrame];
            int tx = rect.m_110085_();
            int ty = rect.m_110086_();
            int tw = rect.m_110090_();
            int th = rect.m_110091_();
            float drawW = (float)tw * scale;
            float drawH = (float)th * scale;
            float drawX = ((float)screenWidth - drawW) / 2.0f;
            float drawY = ((float)screenHeight - drawH) / 2.0f;
            float texW = 32.0f;
            float texH = 32.0f;
            this.drawScaledCustomTexture(TEXTURE_EYES, poseStack, texW, texH, tx, ty, tw, th, drawX, drawY, drawW, drawH);
        }
        poseStack.m_85849_();
    }

    private void drawScaledCustomTexture(ResourceLocation tex, PoseStack poseStack, float texW, float texH, int tx, int ty, int tw, int th, float targetX, float targetY, float targetW, float targetH) {
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)tex);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_85982_(matrix, targetX, targetY, 0.0f).m_7421_((float)tx / texW, (float)ty / texH).m_5752_();
        buffer.m_85982_(matrix, targetX, targetY + targetH, 0.0f).m_7421_((float)tx / texW, (float)(ty + th) / texH).m_5752_();
        buffer.m_85982_(matrix, targetX + targetW, targetY + targetH, 0.0f).m_7421_((float)(tx + tw) / texW, (float)(ty + th) / texH).m_5752_();
        buffer.m_85982_(matrix, targetX + targetW, targetY, 0.0f).m_7421_((float)(tx + tw) / texW, (float)ty / texH).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    private void drawScaledCustomTexture(ResourceLocation tex, PoseStack poseStack, float texW, float texH, int tx, int ty, int tw, int th, float targetX, float targetY, float targetW, float targetH, int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        RenderSystem.m_69478_();
        RenderSystem.m_69493_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)tex);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_85982_(matrix, targetX, targetY, 0.0f).m_7421_((float)tx / texW, (float)ty / texH).m_6122_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, targetX, targetY + targetH, 0.0f).m_7421_((float)tx / texW, (float)(ty + th) / texH).m_6122_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, targetX + targetW, targetY + targetH, 0.0f).m_7421_((float)(tx + tw) / texW, (float)(ty + th) / texH).m_6122_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, targetX + targetW, targetY, 0.0f).m_7421_((float)(tx + tw) / texW, (float)ty / texH).m_6122_(r, g, b, a).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
    }
}

