/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.eyes.config;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

public class DimensionRules {
    private static final List<Rule> rules = Lists.newArrayList();

    static void parseRules(List<? extends String> dimensionRules) {
        rules.clear();
        dimensionRules.forEach(r -> rules.add(DimensionRules.parse(r)));
        rules.add(DimensionRules.disallowLabel("void"));
    }

    public static boolean isDimensionAllowed(ServerLevel world) {
        for (Rule rule : rules) {
            if (rule == null || !rule.test(world)) continue;
            return rule.allow;
        }
        return true;
    }

    private static Rule parse(String rule) {
        boolean allow = true;
        if (rule.startsWith("!")) {
            allow = false;
            rule = rule.substring(1);
        }
        boolean isLabel = false;
        if (rule.startsWith("#")) {
            isLabel = true;
            rule = rule.substring(1);
        } else if (rule.equals("*")) {
            rule = null;
        }
        return new Rule(allow, isLabel, rule);
    }

    private static Rule disallowLabel(String label) {
        return new Rule(false, true, label);
    }

    private static class Rule
    implements Predicate<ServerLevel> {
        public final boolean allow;
        public final boolean isType;
        public final ResourceLocation name;

        private Rule(boolean allow, boolean isType, String key) {
            this.allow = allow;
            this.isType = isType;
            this.name = key == null ? null : new ResourceLocation(key);
        }

        @Override
        public boolean test(ServerLevel world) {
            if (this.name == null) {
                return this.allow;
            }
            if (this.isType) {
                return this.name.equals((Object)world.m_5962_().m_175515_(Registry.f_122818_).m_7981_((Object)world.m_6042_()));
            }
            return this.name.equals((Object)world.m_46472_().m_135782_());
        }
    }
}

