/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.eyes.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import gigaherz.eyes.EyesInTheDarkness;
import gigaherz.eyes.entity.EyesEntity;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;

public class EyesRenderer
extends EntityRenderer<EyesEntity> {
    private static final ResourceLocation TEXTURE = EyesInTheDarkness.location("textures/entity/eyes1.png");
    private final RenderType renderType = RenderType.m_110473_((ResourceLocation)TEXTURE);

    public EyesRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(EyesEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int packedLightIn) {
        float mixAlpha;
        BlockPos position = entity.getBlockPosEyes();
        float blockLight = entity.f_19853_.m_45517_(LightLayer.BLOCK, position);
        if (entity.f_19853_.m_6042_().m_63935_()) {
            float skyLight = (float)entity.f_19853_.m_45517_(LightLayer.SKY, position) - (1.0f - ((ClientLevel)entity.f_19853_).m_104805_(partialTicks)) * 11.0f;
            blockLight = Math.max(blockLight, skyLight);
        }
        if ((mixAlpha = Mth.m_14036_((float)((8.0f - blockLight) / 8.0f), (float)0.0f, (float)1.0f)) <= 0.0f) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, (double)entity.m_20192_(), 0.0);
        matrixStack.m_85845_(this.f_114476_.m_114470_());
        float aggro = entity.getAggroLevel();
        float aggroColorAdjust = 1.0f - Mth.m_14036_((float)aggro, (float)0.0f, (float)1.0f);
        float w = 0.25f;
        float h = 0.09615385f;
        float tw = 0.40625f;
        float th = 0.15625f;
        float hoff = this.getBlinkState(entity, partialTicks, 0.15625f);
        int packedOverlayCoords = OverlayTexture.f_118083_;
        int packedLightmapCoords = 0xF000F0;
        VertexConsumer buffer = bufferIn.m_6299_(this.renderType);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        buffer.m_85982_(matrix, -0.25f, -0.09615385f, 0.0f).m_85950_(1.0f, aggroColorAdjust, aggroColorAdjust, mixAlpha).m_7421_(0.0f, hoff + 0.15625f).m_86008_(packedOverlayCoords).m_85969_(packedLightmapCoords).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(matrix, -0.25f, 0.09615385f, 0.0f).m_85950_(1.0f, aggroColorAdjust, aggroColorAdjust, mixAlpha).m_7421_(0.0f, hoff).m_86008_(packedOverlayCoords).m_85969_(packedLightmapCoords).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(matrix, 0.25f, 0.09615385f, 0.0f).m_85950_(1.0f, aggroColorAdjust, aggroColorAdjust, mixAlpha).m_7421_(0.40625f, hoff).m_86008_(packedOverlayCoords).m_85969_(packedLightmapCoords).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(matrix, 0.25f, -0.09615385f, 0.0f).m_85950_(1.0f, aggroColorAdjust, aggroColorAdjust, mixAlpha).m_7421_(0.40625f, hoff + 0.15625f).m_86008_(packedOverlayCoords).m_85969_(packedLightmapCoords).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        matrixStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStack, bufferIn, packedLightIn);
    }

    private float getBlinkState(EyesEntity entity, float partialTicks, float th) {
        float hoff = 0.0f;
        if (entity.blinkingState) {
            int half_blink = 2;
            hoff = entity.blinkProgress < half_blink ? (float)Mth.m_14143_((float)(((float)entity.blinkProgress + partialTicks) * 4.0f / (float)half_blink)) * th : (float)Math.max(0, 8 - Mth.m_14143_((float)(((float)entity.blinkProgress + partialTicks) * 4.0f / (float)half_blink))) * th;
        }
        return hoff;
    }

    public ResourceLocation getTextureLocation(EyesEntity entity) {
        return TEXTURE;
    }
}

