/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.eyes;

import dev.gigaherz.eyes.EyesSpawningManager;
import dev.gigaherz.eyes.InitiateJumpscarePacket;
import dev.gigaherz.eyes.config.ConfigData;
import dev.gigaherz.eyes.entity.EyesEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="eyesinthedarkness")
public class EyesInTheDarkness {
    public static final MobCategory CLASSIFICATION = MobCategory.create((String)"EITD_EYES", (String)"eitd_eyes", (int)15, (boolean)false, (boolean)false, (int)64);
    public static final String MODID = "eyesinthedarkness";
    public static final Logger LOGGER = LogManager.getLogger((String)"eyesinthedarkness");
    @ObjectHolder(value="eyesinthedarkness:eyes_laugh")
    public static SoundEvent eyes_laugh;
    @ObjectHolder(value="eyesinthedarkness:eyes_disappear")
    public static SoundEvent eyes_disappear;
    @ObjectHolder(value="eyesinthedarkness:eyes_jumpscare")
    public static SoundEvent eyes_jumpscare;
    private static final String CHANNEL = "main";
    private static final String PROTOCOL_VERSION = "1.0";
    public static SimpleChannel channel;
    private static final NonNullLazy<EntityType<EyesEntity>> eyesInit;

    public EyesInTheDarkness() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addGenericListener(SoundEvent.class, this::registerSounds);
        modEventBus.addGenericListener(EntityType.class, this::registerEntities);
        modEventBus.addGenericListener(Item.class, this::registerItems);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::entityAttributes);
        modEventBus.addListener(this::registerCapabilities);
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigData.SERVER_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigData.CLIENT_SPEC);
        MinecraftForge.EVENT_BUS.addListener(this::entityInit);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{(SoundEvent)new SoundEvent(EyesInTheDarkness.location("mob.eyes.laugh")).setRegistryName(EyesInTheDarkness.location("eyes_laugh")), (SoundEvent)new SoundEvent(EyesInTheDarkness.location("mob.eyes.disappear")).setRegistryName(EyesInTheDarkness.location("eyes_disappear")), (SoundEvent)new SoundEvent(EyesInTheDarkness.location("mob.eyes.jumpscare")).setRegistryName(EyesInTheDarkness.location("eyes_jumpscare"))});
    }

    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{(EntityType)((EntityType)eyesInit.get()).setRegistryName("eyesinthedarkness:eyes")});
        SpawnPlacements.m_21754_((EntityType)((EntityType)eyesInit.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConfigData::canEyesSpawnAt);
    }

    public void entityAttributes(EntityAttributeCreationEvent event) {
        event.put(EyesEntity.TYPE, EyesEntity.prepareAttributes().m_22265_());
    }

    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new SpawnEggItem((EntityType)eyesInit.get(), 0, 0x7F0000, new Item.Properties().m_41491_(CreativeModeTab.f_40753_)).setRegistryName(EyesInTheDarkness.location("eyes_spawn_egg"))});
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        EyesSpawningManager.init(event);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        int messageNumber = 0;
        channel.messageBuilder(InitiateJumpscarePacket.class, messageNumber++, NetworkDirection.PLAY_TO_CLIENT).encoder(InitiateJumpscarePacket::encode).decoder(InitiateJumpscarePacket::new).consumer(InitiateJumpscarePacket::handle).add();
        LOGGER.debug("Final message number: " + messageNumber);
    }

    public void entityInit(EntityJoinWorldEvent event) {
        Entity e = event.getEntity();
        if (e instanceof Wolf) {
            Wolf wolf = (Wolf)e;
            wolf.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)wolf, EyesEntity.class, false));
        }
        if (e instanceof Ocelot) {
            Ocelot cat = (Ocelot)e;
            cat.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)cat, EyesEntity.class, 6.0f, 1.0, 1.2));
        }
    }

    public static ResourceLocation location(String location) {
        return new ResourceLocation(MODID, location);
    }

    static {
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)EyesInTheDarkness.location(CHANNEL)).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
        eyesInit = NonNullLazy.of(() -> EntityType.Builder.m_20704_(EyesEntity::new, (MobCategory)CLASSIFICATION).setTrackingRange(80).setUpdateInterval(3).setCustomClientFactory((ent, world) -> (EyesEntity)EyesEntity.TYPE.m_20615_(world)).setShouldReceiveVelocityUpdates(true).m_20712_("eyesinthedarkness:eyes"));
    }
}

