/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.eyes.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BiomeRules {
    private static final AtomicReference<List<Rule>> rules = new AtomicReference(new ArrayList());

    static void parseRules(List<? extends String> dimensionRules) {
        ArrayList<Rule> list = new ArrayList<Rule>();
        dimensionRules.forEach(r -> list.add(BiomeRules.parse(r)));
        list.add(BiomeRules.disallowVoidBiomes());
        rules.set(list);
    }

    public static boolean isBiomeAllowed(Holder<Biome> key) {
        for (Rule rule : rules.get()) {
            if (!rule.test(key)) continue;
            return rule.allow;
        }
        return true;
    }

    private static Rule parse(String rule) {
        boolean allow = true;
        if (rule.startsWith("!")) {
            allow = false;
            rule = rule.substring(1);
        }
        if (rule.startsWith("#")) {
            return new Rule(allow, null, null, rule.substring(1));
        }
        if (rule.startsWith("$")) {
            return new Rule(allow, null, rule.substring(1), null);
        }
        if (rule.equals("*")) {
            return new Rule(allow, null, null, null);
        }
        return new Rule(allow, rule, null, null);
    }

    private static Rule disallowVoidBiomes() {
        return new Rule(false, null, null, "void");
    }

    private static class Rule
    implements Predicate<Holder<Biome>> {
        public final boolean allow;
        public final ResourceLocation registryName;
        public final TagKey<Biome> tagKey;
        public final BiomeDictionary.Type labelType;

        private Rule(boolean allow, @Nullable String registryName, @Nullable String tagName, @Nullable String dictionaryLabel) {
            this.allow = allow;
            this.registryName = registryName != null ? new ResourceLocation(registryName) : null;
            this.tagKey = tagName != null ? TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(tagName)) : null;
            this.labelType = dictionaryLabel != null ? BiomeDictionary.Type.getType((String)dictionaryLabel, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]) : null;
        }

        @Override
        public boolean test(Holder<Biome> biome) {
            if (this.labelType != null) {
                ResourceKey name = (ResourceKey)biome.m_203439_().map(key -> key, value -> ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)Objects.requireNonNull(value.getRegistryName())));
                return BiomeDictionary.hasType((ResourceKey)name, (BiomeDictionary.Type)this.labelType);
            }
            if (this.registryName != null) {
                ResourceLocation name = (ResourceLocation)biome.m_203439_().map(ResourceKey::m_135782_, ForgeRegistryEntry::getRegistryName);
                return this.registryName.equals((Object)name);
            }
            if (this.tagKey != null) {
                return biome.m_203656_(this.tagKey);
            }
            return true;
        }
    }
}

