/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.eyes.config;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

public class DimensionRules {
    private static final AtomicReference<List<Rule>> rules = new AtomicReference(new ArrayList());

    static void parseRules(List<? extends String> dimensionRules) {
        ArrayList<Rule> list = new ArrayList<Rule>();
        dimensionRules.forEach(r -> list.add(DimensionRules.parse(r)));
        list.add(DimensionRules.disallowLabel("void"));
        rules.set(list);
    }

    public static boolean isDimensionAllowed(ServerLevel world) {
        for (Rule rule : rules.get()) {
            if (rule == null || !rule.test(world)) continue;
            return rule.allow;
        }
        return true;
    }

    private static Rule parse(String rule) {
        boolean allow = true;
        if (rule.startsWith("!")) {
            allow = false;
            rule = rule.substring(1);
        }
        boolean isLabel = false;
        if (rule.startsWith("#")) {
            isLabel = true;
            rule = rule.substring(1);
        } else if (rule.equals("*")) {
            rule = null;
        }
        return new Rule(allow, isLabel, rule);
    }

    private static Rule disallowLabel(String label) {
        return new Rule(false, true, label);
    }

    private static class Rule
    implements Predicate<ServerLevel> {
        public final boolean allow;
        public final boolean isType;
        public final ResourceLocation name;

        private Rule(boolean allow, boolean isType, String key) {
            this.allow = allow;
            this.isType = isType;
            this.name = key == null ? null : new ResourceLocation(key);
        }

        @Override
        public boolean test(ServerLevel world) {
            if (this.name == null) {
                return true;
            }
            if (this.isType) {
                return this.name.equals((Object)world.m_5962_().m_175515_(Registry.f_122818_).m_7981_((Object)world.m_6042_()));
            }
            return this.name.equals((Object)world.m_46472_().m_135782_());
        }
    }
}

