/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.eyes.entity;

import dev.gigaherz.eyes.EyesInTheDarkness;
import dev.gigaherz.eyes.InitiateJumpscarePacket;
import dev.gigaherz.eyes.config.ConfigData;
import java.util.EnumSet;
import java.util.List;
import java.util.function.DoubleSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkHooks;

public class EyesEntity
extends Monster {
    private static final EntityDataAccessor<Boolean> IS_DORMANT = SynchedEntityData.m_135353_(EyesEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> AGGRO = SynchedEntityData.m_135353_(EyesEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final float AGGRO_ESCALATION_PER_TICK = 1.6666666E-4f;
    public static final int BLINK_DURATION = 5;
    public boolean blinkingState;
    public int blinkProgress;

    public EyesEntity(EntityType<? extends EyesEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(AGGRO, (Object)Float.valueOf(0.1f));
        this.f_19804_.m_135372_(IS_DORMANT, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.1));
        this.f_21345_.m_25352_(8, (Goal)new CreepTowardPlayer(this, this::getSpeedFromAggro));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public float getAggroLevel() {
        return ((Float)this.m_20088_().m_135370_(AGGRO)).floatValue();
    }

    public void setAggroLevel(float aggro) {
        this.m_20088_().m_135381_(AGGRO, (Object)Float.valueOf(Mth.m_14036_((float)aggro, (float)0.0f, (float)1.0f)));
    }

    public boolean getIsDormant() {
        return (Boolean)this.m_20088_().m_135370_(IS_DORMANT);
    }

    public void setIsDormant(boolean value) {
        this.m_20088_().m_135381_(IS_DORMANT, (Object)value);
    }

    private double getSpeedFromAggro() {
        if (this.getIsDormant()) {
            return 0.0;
        }
        return Mth.m_14085_((double)this.getAggroLevel(), (double)ConfigData.speedNoAggro, (double)ConfigData.speedFullAggro);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (ConfigData.eyeAggressionDependsOnLocalDifficulty) {
            float difficulty = difficultyIn.m_19057_();
            this.setAggroLevel(this.f_19853_.f_46441_.m_188501_() * difficulty);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean jumpScared;
        boolean bl = jumpScared = ConfigData.jumpscare && entityIn instanceof ServerPlayer;
        if (jumpScared) {
            this.jumpscare((ServerPlayer)entityIn);
        }
        if (ConfigData.jumpscareHurtLevel > 0 && entityIn instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entityIn;
            living.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, ConfigData.jumpscareHurtLevel - 1));
        }
        this.disappear(!jumpScared);
        return true;
    }

    public void jumpscare(ServerPlayer player) {
        EyesInTheDarkness.channel.sendTo((Object)new InitiateJumpscarePacket(this.m_20185_(), this.m_20186_(), this.m_20189_()), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_) {
            if (this.getIsDormant()) {
                return;
            }
            if (!this.blinkingState) {
                if (this.f_19853_.f_46441_.m_188501_() < 0.02f) {
                    this.blinkingState = true;
                    this.blinkProgress = 0;
                }
            } else {
                ++this.blinkProgress;
                if (this.blinkProgress >= 5) {
                    this.blinkingState = false;
                }
            }
            return;
        }
        this.setIsDormant(this.isIlluminated(ConfigData.eyesCanAttackWhileLit));
        if (this.getIsDormant()) {
            return;
        }
        float maxWatchDistance = 16.0f;
        Vec3 eyes = this.m_20299_(1.0f);
        List entities = this.f_19853_.m_6443_(Player.class, new AABB(eyes.f_82479_ - (double)maxWatchDistance, eyes.f_82480_ - (double)maxWatchDistance, eyes.f_82481_ - (double)maxWatchDistance, eyes.f_82479_ + (double)maxWatchDistance, eyes.f_82480_ + (double)maxWatchDistance, eyes.f_82481_ + (double)maxWatchDistance), player -> {
            if (player.m_5833_() || !player.m_6084_()) {
                return false;
            }
            if (player.m_20299_(1.0f).m_82554_(eyes) > (double)maxWatchDistance) {
                return false;
            }
            Vec3 vec3d = player.m_20252_(1.0f).m_82541_();
            Vec3 vec3d1 = new Vec3(this.m_20185_() - player.m_20185_(), this.m_20191_().f_82289_ + (double)this.m_20192_() - (player.m_20186_() + (double)player.m_20192_()), this.m_20189_() - player.m_20189_());
            double d0 = vec3d1.m_82553_();
            double d1 = vec3d.m_82526_(vec3d1 = vec3d1.m_82541_());
            return d1 > 1.0 - 0.025 / d0 && player.m_142582_((Entity)this);
        });
        if (entities.size() > 0) {
            this.disappear(true);
            return;
        }
        if (ConfigData.enableEyeAggressionEscalation && !this.getIsDormant()) {
            this.setAggroLevel(this.getAggroLevel() + 1.6666666E-4f);
        }
    }

    public boolean m_21222_() {
        return true;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_7334_(Entity entityIn) {
    }

    protected void m_7324_(Entity entityIn) {
        if (this.getIsDormant()) {
            return;
        }
        if (entityIn instanceof Player) {
            this.disappear(true);
        }
    }

    private void disappear(boolean playDeathSound) {
        this.m_6475_(DamageSource.f_19318_, 1.0f);
        if (playDeathSound) {
            this.m_5496_(this.m_5592_(), this.getDisappearVolume(), this.m_6100_());
        }
    }

    protected float m_6121_() {
        return super.m_6121_() * (float)ConfigData.eyeIdleVolume;
    }

    protected float getDisappearVolume() {
        return super.m_6121_() * (float)ConfigData.eyeDisappearVolume;
    }

    protected void m_6138_() {
        super.m_6138_();
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    protected void m_6153_() {
        this.f_20919_ = 19;
        super.m_6153_();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.f_19797_ == 0 || this.getIsDormant()) {
            return null;
        }
        return (SoundEvent)EyesInTheDarkness.EYES_LAUGH.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)EyesInTheDarkness.EYES_DISAPPEAR.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)EyesInTheDarkness.EYES_DISAPPEAR.get();
    }

    public BlockPos getBlockPosEyes() {
        return new BlockPos(this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_());
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getSunBrightness() {
        float angleRadians = this.f_19853_.m_46490_(1.0f);
        float f1 = 1.0f - (Mth.m_14089_((float)angleRadians) * 2.0f + 0.2f);
        f1 = Mth.m_14036_((float)f1, (float)0.0f, (float)1.0f);
        f1 = 1.0f - f1;
        f1 = (float)((double)f1 * (1.0 - (double)(this.f_19853_.m_46722_(1.0f) * 5.0f) / 16.0));
        f1 = (float)((double)f1 * (1.0 - (double)(this.f_19853_.m_46661_(1.0f) * 5.0f) / 16.0));
        return f1 * 0.8f + 0.2f;
    }

    private float getLightLevel(boolean excludeDaylight) {
        BlockPos position = this.getBlockPosEyes();
        float blockLight = 0.0f;
        if (excludeDaylight) {
            if (this.f_19853_.m_6042_().f_223549_()) {
                float skyLight1;
                float skyLight = (float)this.f_19853_.m_45517_(LightLayer.SKY, position) - (1.0f - this.getSunBrightness()) * 11.0f;
                if (skyLight != (skyLight1 = (float)(this.f_19853_.m_45517_(LightLayer.SKY, position) - this.f_19853_.m_7445_()))) {
                    // empty if block
                }
                blockLight = Math.max(blockLight, skyLight);
            }
        } else {
            blockLight = this.f_19853_.m_46803_(position);
        }
        return blockLight;
    }

    private boolean isIlluminated(boolean excludeDaylight) {
        float blockLight = this.getLightLevel(excludeDaylight);
        return blockLight >= 8.0f;
    }

    public boolean countsTowardSpawnCap() {
        return this.m_8023_() || this.m_21532_();
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
    }

    private static class CreepTowardPlayer
    extends Goal {
        protected final PathfinderMob attacker;
        private final EyesEntity eyes;
        private final DoubleSupplier speedGetter;
        protected int attackTick;
        private Path path;
        private int delayCounter;
        private double targetX;
        private double targetY;
        private double targetZ;

        public CreepTowardPlayer(EyesEntity creature, DoubleSupplier speedGetter) {
            this.attacker = creature;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.speedGetter = speedGetter;
            this.eyes = creature;
        }

        public boolean m_8036_() {
            if (this.eyes.getIsDormant()) {
                return false;
            }
            LivingEntity targetPlayer = this.attacker.m_5448_();
            if (targetPlayer == null || !targetPlayer.m_6084_()) {
                return false;
            }
            if (this.isPlayerLookingInMyGeneralDirection()) {
                return false;
            }
            this.path = this.attacker.m_21573_().m_6570_((Entity)targetPlayer, 0);
            return this.path != null || this.isWithinRange(targetPlayer);
        }

        public void m_8056_() {
            this.attacker.m_21573_().m_26536_(this.path, this.speedGetter.getAsDouble());
            this.attacker.m_21561_(true);
            this.delayCounter = 0;
        }

        public boolean m_8045_() {
            if (this.eyes.getIsDormant()) {
                return false;
            }
            if (this.isPlayerLookingInMyGeneralDirection()) {
                return false;
            }
            LivingEntity livingentity = this.attacker.m_5448_();
            if (livingentity == null || !livingentity.m_6084_()) {
                return false;
            }
            return !this.attacker.m_21573_().m_26571_();
        }

        private boolean isWithinRange(LivingEntity targetPlayer) {
            return this.getAttackReachSqr(targetPlayer) >= this.attacker.m_20275_(targetPlayer.m_20185_(), targetPlayer.m_20191_().f_82289_, targetPlayer.m_20189_());
        }

        private boolean isPlayerLookingInMyGeneralDirection() {
            if (this.eyes.getIsDormant()) {
                return false;
            }
            Vec3 selfPos = this.eyes.m_20182_();
            LivingEntity target = this.eyes.m_5448_();
            if (target == null) {
                return false;
            }
            Vec3 playerPos = target.m_20182_();
            Vec3 lookVec = target.m_20154_();
            Vec3 playerLook = new Vec3(lookVec.f_82479_, lookVec.f_82480_, lookVec.f_82481_);
            playerLook.m_82541_();
            playerPos.m_82546_(selfPos);
            playerPos.m_82541_();
            return playerLook.m_82526_(playerPos) < 0.0;
        }

        public void m_8041_() {
            LivingEntity livingentity = this.attacker.m_5448_();
            if (!EntitySelector.f_20406_.test(livingentity)) {
                this.attacker.m_6710_(null);
            }
            this.attacker.m_21561_(false);
            this.attacker.m_21573_().m_26573_();
        }

        public void m_8037_() {
            LivingEntity targetPlayer = this.attacker.m_5448_();
            this.attacker.m_21563_().m_24960_((Entity)targetPlayer, 30.0f, 30.0f);
            double distanceSquared = this.attacker.m_20275_(targetPlayer.m_20185_(), targetPlayer.m_20191_().f_82289_, targetPlayer.m_20189_());
            --this.delayCounter;
            if (this.attacker.m_21574_().m_148306_((Entity)targetPlayer) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || targetPlayer.m_20275_(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.m_217043_().m_188501_() < 0.05f)) {
                this.targetX = targetPlayer.m_20185_();
                this.targetY = targetPlayer.m_20191_().f_82289_;
                this.targetZ = targetPlayer.m_20189_();
                this.delayCounter = 4 + this.attacker.m_217043_().m_188503_(7);
                if (distanceSquared > 1024.0) {
                    this.delayCounter += 10;
                } else if (distanceSquared > 256.0) {
                    this.delayCounter += 5;
                }
                if (!this.attacker.m_21573_().m_5624_((Entity)targetPlayer, this.speedGetter.getAsDouble())) {
                    this.delayCounter += 15;
                }
            }
            this.attackTick = Math.max(this.attackTick - 1, 0);
            this.checkAndPerformAttack(targetPlayer, distanceSquared);
        }

        protected void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
            double reachSqr = this.getAttackReachSqr(enemy);
            if (distToEnemySqr <= reachSqr && this.attackTick <= 0) {
                this.attackTick = 20;
                this.attacker.m_6674_(InteractionHand.MAIN_HAND);
                this.attacker.m_7327_((Entity)enemy);
            }
        }

        protected double getAttackReachSqr(LivingEntity attackTarget) {
            return this.attacker.m_20205_() * 2.0f * this.attacker.m_20205_() * 2.0f + attackTarget.m_20205_();
        }
    }
}

