/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.eyes;

import dev.gigaherz.eyes.EyesSpawningManager;
import dev.gigaherz.eyes.InitiateJumpscarePacket;
import dev.gigaherz.eyes.config.ConfigData;
import dev.gigaherz.eyes.entity.EyesEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="eyesinthedarkness")
public class EyesInTheDarkness {
    public static final MobCategory CLASSIFICATION = MobCategory.create((String)"EITD_EYES", (String)"eitd_eyes", (int)15, (boolean)false, (boolean)false, (int)64);
    public static final String MODID = "eyesinthedarkness";
    public static final Logger LOGGER = LogManager.getLogger((String)"eyesinthedarkness");
    private static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"eyesinthedarkness");
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"eyesinthedarkness");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"eyesinthedarkness");
    public static final RegistryObject<SoundEvent> EYES_LAUGH = SOUND_EVENTS.register("eyes_laugh", () -> SoundEvent.m_262824_((ResourceLocation)EyesInTheDarkness.location("mob.eyes.laugh")));
    public static final RegistryObject<SoundEvent> EYES_DISAPPEAR = SOUND_EVENTS.register("eyes_disappear", () -> SoundEvent.m_262824_((ResourceLocation)EyesInTheDarkness.location("mob.eyes.disappear")));
    public static final RegistryObject<SoundEvent> EYES_JUMPSCARE = SOUND_EVENTS.register("eyes_jumpscare", () -> SoundEvent.m_262824_((ResourceLocation)EyesInTheDarkness.location("mob.eyes.jumpscare")));
    public static final RegistryObject<EntityType<EyesEntity>> EYES = ENTITY_TYPES.register("eyes", () -> EntityType.Builder.m_20704_(EyesEntity::new, (MobCategory)CLASSIFICATION).setTrackingRange(80).setUpdateInterval(3).setCustomClientFactory((ent, world) -> (EyesEntity)((EntityType)EYES.get()).m_20615_(world)).setShouldReceiveVelocityUpdates(true).m_20712_("eyesinthedarkness:eyes"));
    public static final RegistryObject<SpawnEggItem> EYES_EGG = ITEMS.register("eyes_spawn_egg", () -> new ForgeSpawnEggItem(EYES, 0, 0x7F0000, new Item.Properties()));
    private static final String PROTOCOL_VERSION = "1.0";
    public static final SimpleChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)EyesInTheDarkness.location("main")).clientAcceptedVersions("1.0"::equals).serverAcceptedVersions("1.0"::equals).networkProtocolVersion(() -> "1.0").simpleChannel();

    public EyesInTheDarkness() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        SOUND_EVENTS.register(modEventBus);
        ENTITY_TYPES.register(modEventBus);
        ITEMS.register(modEventBus);
        modEventBus.addListener(this::construct);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::entityAttributes);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(this::addItemsToTabs);
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigData.SERVER_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigData.CLIENT_SPEC);
        MinecraftForge.EVENT_BUS.addListener(this::entityInit);
    }

    private void addItemsToTabs(CreativeModeTabEvent.BuildContents event) {
        if (event.getTab() == CreativeModeTabs.f_256731_) {
            event.m_246326_((ItemLike)EYES_EGG.get());
        }
    }

    public void construct(FMLConstructModEvent event) {
        event.enqueueWork(() -> SpawnPlacements.m_21754_((EntityType)((EntityType)EYES.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConfigData::canEyesSpawnAt));
    }

    public void entityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)EYES.get(), EyesEntity.prepareAttributes().m_22265_());
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        EyesSpawningManager.init(event);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        int messageNumber = 0;
        channel.messageBuilder(InitiateJumpscarePacket.class, messageNumber++, NetworkDirection.PLAY_TO_CLIENT).encoder(InitiateJumpscarePacket::encode).decoder(InitiateJumpscarePacket::new).consumer(InitiateJumpscarePacket::handle).add();
        LOGGER.debug("Final message number: " + messageNumber);
    }

    public void entityInit(LivingSpawnEvent.SpecialSpawn event) {
        Ocelot cat;
        Mob e = event.getEntity();
        if (e instanceof Wolf) {
            Wolf wolf = (Wolf)e;
            wolf.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)wolf, EyesEntity.class, false));
        }
        if (e instanceof Ocelot) {
            cat = (Ocelot)e;
            cat.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)cat, EyesEntity.class, 6.0f, 1.0, 1.2));
        }
        if (e instanceof Cat) {
            cat = (Cat)e;
            cat.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)cat, EyesEntity.class, 6.0f, 1.0, 1.2));
        }
    }

    public static ResourceLocation location(String location) {
        return new ResourceLocation(MODID, location);
    }
}

