/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.config;

import com.mactso.regrowth.config.ModConfigs;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class RegrowthEntitiesManager {
    public static Hashtable<String, RegrowthMobItem> regrowthMobHashtable = new Hashtable();
    public static String[] defaultRegrowthMobs;

    public static RegrowthMobItem getRegrowthMobInfo(String key) {
        String iKey = key;
        if (regrowthMobHashtable.isEmpty()) {
            RegrowthEntitiesManager.regrowthMobInit();
        }
        RegrowthMobItem r = regrowthMobHashtable.get(iKey);
        return r;
    }

    public static String getRegrowthHashAsString() {
        Object returnString = "";
        for (String key : regrowthMobHashtable.keySet()) {
            String regrowthType = RegrowthEntitiesManager.regrowthMobHashtable.get((Object)key).regrowthAction;
            double percentage = RegrowthEntitiesManager.regrowthMobHashtable.get((Object)key).regrowthEventSeconds;
            String tempString = key + "," + regrowthType + "," + percentage + ";";
            returnString = (String)returnString + tempString;
        }
        return returnString;
    }

    public static void regrowthMobInit() {
        regrowthMobHashtable.clear();
        String oneMob = "";
        StringTokenizer tokenizedMobString = new StringTokenizer(ModConfigs.getActionMobList(), ";");
        while (tokenizedMobString.hasMoreElements()) {
            oneMob = tokenizedMobString.nextToken().trim();
            if (oneMob.isEmpty()) continue;
            try {
                String modAndEntity;
                StringTokenizer st = new StringTokenizer(oneMob, ",");
                String key = modAndEntity = st.nextToken();
                String regrowthType = st.nextToken();
                String secondsString = st.nextToken();
                double seconds = Double.parseDouble(secondsString.trim());
                if (seconds <= 1.0) {
                    seconds = 1.0;
                }
                regrowthMobHashtable.put(key, new RegrowthMobItem(regrowthType, seconds));
            }
            catch (Exception e) {
                System.out.println("Regrowth Debug:  Bad Mob Config : " + oneMob);
            }
        }
    }

    public static class RegrowthMobItem {
        double regrowthEventSeconds;
        String regrowthAction;

        public RegrowthMobItem(String regrowthType, double regrowthEventSeconds) {
            this.regrowthAction = regrowthType;
            this.regrowthEventSeconds = regrowthEventSeconds;
        }

        public String getRegrowthActions() {
            return this.regrowthAction.toLowerCase();
        }

        public double getRegrowthEventSeconds() {
            return this.regrowthEventSeconds;
        }
    }
}

