/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.events;

import com.google.common.collect.Lists;
import com.mactso.regrowth.config.ModConfigs;
import com.mactso.regrowth.config.RegrowthEntitiesManager;
import com.mactso.regrowth.config.WallBiomeDataManager;
import com.mactso.regrowth.config.WallFoundationDataManager;
import com.mactso.regrowth.utility.Utility;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1439;
import net.minecraft.class_1496;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2266;
import net.minecraft.class_2298;
import net.minecraft.class_2299;
import net.minecraft.class_2301;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2356;
import net.minecraft.class_2372;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2381;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2397;
import net.minecraft.class_2418;
import net.minecraft.class_2420;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2473;
import net.minecraft.class_2488;
import net.minecraft.class_2521;
import net.minecraft.class_2526;
import net.minecraft.class_2527;
import net.minecraft.class_2544;
import net.minecraft.class_2555;
import net.minecraft.class_2561;
import net.minecraft.class_2577;
import net.minecraft.class_2585;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2902;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3481;
import net.minecraft.class_3852;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4158;
import net.minecraft.class_4208;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_5575;
import net.minecraft.class_6880;

public class MoveEntityEvent {
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2746 OPEN = class_2349.field_11026;
    private static Random moveRand = new Random();
    private static final class_2248[] coralPlants = new class_2248[]{class_2246.field_10238, class_2246.field_10376, class_2246.field_10476, class_2246.field_10079, class_2246.field_10427, class_2246.field_10551, class_2246.field_10005, class_2246.field_10053, class_2246.field_10079, class_2246.field_10427, class_2246.field_10551, class_2246.field_10005, class_2246.field_10053};
    private static final class_2248[] coralfans = new class_2248[]{class_2246.field_10186, class_2246.field_10447, class_2246.field_10498, class_2246.field_9976, class_2246.field_10584};
    private static final class_2470[] coralfanrotations = new class_2470[]{class_2470.field_11464, class_2470.field_11465, class_2470.field_11463, class_2470.field_11467};
    private static int[] dx = new int[]{1, 0, -1, 0};
    private static int[] dz = new int[]{0, 1, 0, -1};
    private static int CHECKS_PER_SECOND = 10;
    private static int[][] facingArray = new int[][]{{0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}, {1, 0}, {1, 1}};
    private static int lastTorchX = 0;
    private static int lastTorchY = 0;
    private static int lastTorchZ = 0;
    static final int WALL_CENTER = 0;
    static final int FENCE_CENTER = 0;
    static final int WALL_TYPE_WALL = -1;
    static final int WALL_TYPE_FENCE = -2;
    static final String ACTION_GROW = "grow";
    static final String ACTION_EAT = "eat";
    static final String ACTION_BOTH = "both";
    static final String ACTION_TALL = "tall";
    static final String ACTION_MUSHROOM = "mushroom";
    static final String ACTION_STUMBLE = "stumble";
    static final String ACTION_REFOREST = "reforest";
    static final String ACTION_CORAL = "coral";
    private static class_2680 footBlockState;
    private static class_2680 groundBlockState;
    private static class_2248 footBlock;
    private static class_2248 groundBlock;
    private static class_1959 localBiome;
    private static boolean isRoadPiece;
    private static class_1959.class_1961 biomeCategory;
    static class_2338 adjustedPos;

    public static boolean handleTrampleEvent(class_1297 entity) {
        class_1646 ve;
        class_2338 pos = entity.method_24515();
        Utility.debugMsg(1, pos, "Enter handleTrampleEvent");
        if (entity instanceof class_1646 && (ve = (class_1646)entity).method_7231().method_16924() == class_3852.field_17056 && ve.method_7231().method_16925() > 3) {
            Utility.debugMsg(1, pos, "Villager is L3 farmer");
            return true;
        }
        if (entity instanceof class_3222) {
            class_3222 spe = (class_3222)entity;
            if (spe.method_7337()) {
                return true;
            }
            Utility.debugMsg(1, pos, "FarmlandTrampleCancelled");
        }
        return false;
    }

    public static void handleEntityMoveEvents(class_1309 entity) {
        if (entity instanceof class_1657) {
            return;
        }
        if ((long)(entity.method_5628() % 2) == entity.field_6002.method_8510() % 2L) {
            return;
        }
        if (entity.method_24515() == null) {
            return;
        }
        String registryNameAsString = MoveEntityEvent.helperGetRegistryNameAsString((class_1297)entity);
        RegrowthEntitiesManager.RegrowthMobItem currentRegrowthMobItem = RegrowthEntitiesManager.getRegrowthMobInfo(registryNameAsString);
        if (currentRegrowthMobItem == null) {
            return;
        }
        class_1937 class_19372 = entity.field_6002;
        if (class_19372 instanceof class_3218) {
            class_1646 ve;
            class_3218 sLevel = (class_3218)class_19372;
            adjustedPos = MoveEntityEvent.getAdjustedBlockPos((class_1297)entity);
            footBlockState = MoveEntityEvent.getAdjustedFootBlockState((class_1297)entity);
            footBlock = footBlockState.method_26204();
            if (footBlock instanceof class_2577) {
                return;
            }
            groundBlockState = MoveEntityEvent.getAdjustedGroundBlockState((class_1297)entity);
            groundBlock = groundBlockState.method_26204();
            if (groundBlockState.method_26215()) {
                return;
            }
            localBiome = (class_1959)entity.field_6002.method_23753(entity.method_24515()).comp_349();
            biomeCategory = class_1959.method_40136((class_6880)sLevel.method_23753(entity.method_24515()));
            String regrowthActions = currentRegrowthMobItem.getRegrowthActions();
            if (MoveEntityEvent.isImpossibleRegrowthEvent(regrowthActions)) {
                return;
            }
            double regrowthEventOdds = 1.0 / (currentRegrowthMobItem.getRegrowthEventSeconds() * (double)CHECKS_PER_SECOND);
            if (MoveEntityEvent.isHorseTypeEatingNow((class_1297)entity)) {
                regrowthEventOdds *= 20.0;
            }
            double randomD100Roll = entity.field_6002.field_9229.nextDouble();
            boolean debugvalue = false;
            long chunkAge = entity.field_6002.method_22350(entity.method_24515()).method_12033();
            if (chunkAge < 480000L && entity instanceof class_1646) {
                ve = (class_1646)entity;
                if (ve.field_6002.method_8510() % 12L == 0L) {
                    if (regrowthActions.contains("r")) {
                        MoveEntityEvent.vImproveRoads(ve, "preRoad");
                    }
                    if (regrowthActions.contains("w")) {
                        MoveEntityEvent.vImproveVillageWall(ve, regrowthActions);
                    }
                }
            }
            if (randomD100Roll <= regrowthEventOdds + (double)debugvalue) {
                if (entity instanceof class_1646) {
                    ve = (class_1646)entity;
                    MoveEntityEvent.improvePowderedSnow((class_1297)entity);
                    if (ve.method_24828() && !(footBlock instanceof class_2244)) {
                        MoveEntityEvent.doVillagerRegrowthEvents(ve, registryNameAsString, regrowthActions);
                    }
                } else {
                    MoveEntityEvent.doMobRegrowthEvents((class_1297)entity, registryNameAsString, regrowthActions);
                }
            }
        }
    }

    private static String helperGetRegistryNameAsString(class_1297 entity) {
        return Utility.getResourceLocationString(entity);
    }

    private static class_2680 getAdjustedFootBlockState(class_1297 e) {
        if (e.method_23318() == (double)e.method_24515().method_10264()) {
            return e.field_6002.method_8320(e.method_24515());
        }
        return e.field_6002.method_8320(e.method_24515().method_10084());
    }

    private static int getAdjustedY(class_1297 e) {
        if (e.method_23318() == (double)e.method_24515().method_10264()) {
            return 1;
        }
        return 0;
    }

    private static class_2680 getAdjustedGroundBlockState(class_1297 e) {
        return e.field_6002.method_8320(e.method_24515().method_10087(MoveEntityEvent.getAdjustedY(e)));
    }

    private static class_2338 getAdjustedBlockPos(class_1297 e) {
        if (e.method_23318() == (double)e.method_24515().method_10264()) {
            return e.method_24515();
        }
        return e.method_24515().method_10084();
    }

    private static void improvePowderedSnow(class_1297 entity) {
        class_1937 sLevel = entity.field_6002;
        if (entity.field_27857) {
            int hp = 0;
            if (sLevel.method_8320(entity.method_24515().method_10086(2)).method_26204() == class_2246.field_27879) {
                entity.field_6002.method_22352(entity.method_24515().method_10086(2), false);
                hp = 2;
            }
            if (sLevel.method_8320(entity.method_24515().method_10084()).method_26204() == class_2246.field_27879) {
                entity.field_6002.method_22352(entity.method_24515().method_10084(), false);
                hp += 2;
            }
            if (sLevel.method_8320(entity.method_24515()).method_26204() == class_2246.field_27879) {
                int layers = 2 + hp;
                class_2680 snowBlock = (class_2680)class_2246.field_10477.method_9564().method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(layers));
                entity.field_6002.method_8501(entity.method_24515(), snowBlock);
            }
        }
    }

    private static void doMobRegrowthEvents(class_1297 entity, String key, String regrowthType) {
        if (regrowthType.equals(ACTION_STUMBLE)) {
            if (footBlock instanceof class_2527 || footBlock instanceof class_2555) {
                MoveEntityEvent.mobStumbleAction(entity, key);
            }
            return;
        }
        if (regrowthType.equals(ACTION_REFOREST)) {
            MoveEntityEvent.mobReforestAction(entity, key);
            return;
        }
        if (regrowthType.equals(ACTION_MUSHROOM)) {
            MoveEntityEvent.mobGrowMushroomAction(entity, key);
            return;
        }
        if (regrowthType.equals(ACTION_CORAL)) {
            MoveEntityEvent.mobGrowCoralAction(entity, key);
            return;
        }
        MoveEntityEvent.mobHandleOverCrowding(entity, key);
        if (!MoveEntityEvent.isKindOfGrassBlock(groundBlockState)) {
            return;
        }
        if (regrowthType.equals(ACTION_TALL)) {
            MoveEntityEvent.mobGrowTallAction(entity, key);
            return;
        }
        if (regrowthType.equals(ACTION_BOTH)) {
            regrowthType = entity.field_6002.field_9229.nextDouble() * 100.0 > 85.0 ? ACTION_GROW : ACTION_EAT;
        }
        if (regrowthType.contentEquals(ACTION_EAT)) {
            MoveEntityEvent.mobEatPlantsAction(entity, key, regrowthType);
            return;
        }
        if (regrowthType.equals(ACTION_GROW)) {
            MoveEntityEvent.mobGrowPlantsAction(entity, key);
            return;
        }
    }

    private static void mobHandleOverCrowding(class_1297 e, String key) {
        class_2338 ePos = new class_2338(e.method_23317(), e.method_23318(), e.method_23321());
        if (e instanceof class_1429) {
            class_1429 a = (class_1429)e;
            class_1937 class_19372 = e.field_6002;
            if (class_19372 instanceof class_3218) {
                class_3218 world = (class_3218)class_19372;
                class_238 box = new class_238(ePos.method_10089(3).method_10086(2).method_10076(3), ePos.method_10088(3).method_10087(2).method_10077(3));
                int excess = world.method_18023((class_5575)e.method_5864(), box, entity -> true).size() - 16;
                if (excess > 0) {
                    if (excess > 16) {
                        e.field_6002.method_8486(e.method_23317(), e.method_23318(), e.method_23321(), class_3417.field_14857, class_3419.field_15254, 1.1f, 0.54f, true);
                        e.method_5814(e.method_23317(), -66.0, e.method_23321());
                    } else {
                        float hurt = (float)excess + world.method_8409().nextFloat() / 6.0f;
                        e.method_5643(class_1282.field_5855, hurt);
                    }
                }
            }
        }
    }

    private static boolean mobGrowCoralAction(class_1297 e, String key) {
        class_1937 level = e.field_6002;
        int sealevel = level.method_8615();
        Random rand = level.method_8409();
        moveRand.setSeed(e.method_31478() * 1151 + e.method_31477() * 51 + e.method_31479() * 31);
        double docoralplant = moveRand.nextDouble();
        docoralplant = moveRand.nextDouble();
        double docoralfan = moveRand.nextDouble();
        int coralfanDirection = moveRand.nextInt(4);
        int minCoraldepth = sealevel - 4 + moveRand.nextInt(2);
        int maxCoraldepth = sealevel - 16;
        if (e.method_31478() > minCoraldepth) {
            return false;
        }
        if (e.method_31478() < maxCoraldepth) {
            return false;
        }
        class_2338 pos = e.method_24515();
        if (level.method_8320(pos.method_10087(0)).method_26204() != class_2246.field_10382) {
            return false;
        }
        if (level.method_8320(pos.method_10087(1)).method_26204() != class_2246.field_10382) {
            return false;
        }
        class_2248 b = level.method_8320(pos.method_10087(2)).method_26204();
        if (level.method_8320(pos.method_10087(2)).method_26204() != class_2246.field_10382 && b != class_2246.field_10340 && b != class_2246.field_10033) {
            Utility.debugMsg(1, pos, "Block: " + level.method_8320(pos.method_10087(2)).method_26204().method_9539());
        }
        boolean fabpatch = false;
        if (level.method_8320(pos.method_10087(2)).method_26204() instanceof class_2298) {
            fabpatch = true;
        }
        if (level.method_8320(pos.method_10087(2)).method_26204() instanceof class_2301) {
            fabpatch = true;
        }
        if (fabpatch) {
            int count;
            Utility.debugMsg(1, pos, "Coral plant opportunity:" + e.method_5864().method_40124().toString() + " .");
            if (docoralfan < 0.3) {
                class_2350 d = class_2350.method_10139((int)coralfanDirection);
                class_2338 fanPos = e.method_24515().method_10087(2).method_10093(d);
                if (level.method_8320(fanPos).method_26204() == class_2246.field_10382) {
                    level.method_8501(fanPos, (class_2680)coralfans[rand.nextInt(coralfans.length)].method_9564().method_11657((class_2769)class_2299.field_9933, (Comparable)d));
                }
            }
            if ((count = MoveEntityEvent.countCoral(e)) > 5) {
                return false;
            }
            class_2680 theCoralBlock = level.method_8320(pos.method_10087(2));
            if (count < 6 && e.method_31478() == minCoraldepth) {
                if (docoralplant < 0.3) {
                    return false;
                }
                Utility.debugMsg(1, pos, "CORAL Plant grows over Coral Block:" + e.method_5864().method_40124().toString() + " .");
                level.method_8501(pos.method_10087(1), coralPlants[rand.nextInt(coralPlants.length)].method_9564());
                level.method_8396(null, pos, class_3417.field_14756, class_3419.field_15256, 0.9f, 1.4f);
                return true;
            }
            if (e.method_31478() < minCoraldepth) {
                int ew = rand.nextInt(3) - 1;
                int ns = rand.nextInt(3) - 1;
                if (level.method_8320(pos.method_10087(1).method_10089(ew).method_10076(ns)).method_26204() != class_2246.field_10382) {
                    return false;
                }
                Utility.debugMsg(1, pos, "CORAL Block grows over Coral Block:" + e.method_5864().method_40124().toString() + " .");
                level.method_8501(pos.method_10087(1).method_10089(ew).method_10076(ns), theCoralBlock);
                level.method_8396(null, pos, class_3417.field_14817, class_3419.field_15256, 0.9f, 1.4f);
                Utility.debugMsg(1, pos, "CORAL:" + e.method_5864().method_40124().toString() + " new block set at near " + pos.method_10087(1) + " .");
            }
        }
        return true;
    }

    private static int countCoral(class_1297 e) {
        int c = 0;
        for (int ud = -1; ud <= 0; ++ud) {
            for (int ew = -1; ew <= 1; ++ew) {
                for (int ns = -1; ns <= 1; ++ns) {
                    if (!(e.field_6002.method_8320(e.method_24515().method_10087(1).method_10089(ew).method_10076(ns)).method_26204() instanceof class_2301)) continue;
                    ++c;
                }
            }
        }
        return c;
    }

    private static boolean mobGrowPlantsAction(class_1297 entity, String key) {
        if (footBlockState.method_26215()) {
            if (!(groundBlock instanceof class_2256)) {
                return false;
            }
            class_2338 bpos = entity.method_24515();
            if (bpos == null) {
                Utility.debugMsg(1, "ERROR:" + key + "grow plant null position.");
                return false;
            }
            class_2256 ib = (class_2256)groundBlock;
            Utility.debugMsg(1, entity.method_24515(), key + " growable plant found.");
            try {
                class_3218 serverworld = (class_3218)entity.field_6002;
                class_2680 bs = entity.field_6002.method_8320(bpos);
                ib.method_9652(serverworld, entity.field_6002.field_9229, bpos, bs);
                Utility.debugMsg(1, bpos, key + " grew plant.");
            }
            catch (Exception e) {
                Utility.debugMsg(1, bpos, key + " caught grow attempt exception.");
            }
        }
        return true;
    }

    private static boolean isNearWater(class_1937 world, class_2338 pos) {
        class_238 box = new class_238(pos.method_10089(4).method_10076(4), pos.method_10088(4).method_10077(4));
        return world.method_22345(box);
    }

    private static boolean isKindOfGrassBlock(class_2680 groundBlockState) {
        if (groundBlockState.method_26204() instanceof class_2372) {
            return true;
        }
        return groundBlockState.method_26204().method_9539().equals("block.byg.meadow_grass_block");
    }

    private static boolean isBlockGrassOrDirt(class_2680 tempBlockState) {
        return MoveEntityEvent.isKindOfGrassBlock(tempBlockState) || tempBlockState.method_26204() == class_2246.field_10566;
    }

    private static class_2680 helperSaplingState(class_1937 world, class_2338 pos, class_1959 localBiome, class_2680 sapling) {
        sapling = class_2246.field_10394.method_9564();
        class_5321 k = class_2378.field_25114;
        String biomeName = ((class_5321)world.method_30349().method_30530(k).method_29113((Object)localBiome).get()).method_29177().toString();
        if (biomeName.contains("birch")) {
            sapling = class_2246.field_10575.method_9564();
        }
        if (biomeName.contains("taiga")) {
            sapling = class_2246.field_10217.method_9564();
        }
        if (biomeName.contains("jungle")) {
            sapling = class_2246.field_10276.method_9564();
        }
        if (biomeName.contains("savanna")) {
            sapling = class_2246.field_10385.method_9564();
        }
        if (biomeName.contains("desert")) {
            sapling = class_2246.field_10385.method_9564();
        }
        return sapling;
    }

    private static void mobReforestAction(class_1297 entity, String key) {
        if (footBlock != class_2246.field_10124) {
            return;
        }
        if (!MoveEntityEvent.isBlockGrassOrDirt(groundBlockState)) {
            return;
        }
        class_2338 ePos = MoveEntityEvent.getAdjustedBlockPos(entity);
        double sinY = Math.sin((double)((ePos.method_10264() + 64) % 256) / 256.0);
        if (entity.field_6002.field_9229.nextDouble() > Math.abs(sinY)) {
            return;
        }
        class_2680 sapling = null;
        sapling = MoveEntityEvent.helperSaplingState(entity.field_6002, ePos, localBiome, sapling);
        int hval = 5;
        int yval = 0;
        int yrange = 0;
        if (MoveEntityEvent.helperCountBlocksBB(class_2473.class, 1, entity.field_6002, ePos, hval, yrange) > 0) {
            return;
        }
        int leafCount = 0;
        yval = 4;
        yrange = 0;
        hval = 4;
        if (sapling == class_2246.field_10385.method_9564()) {
            yval = 5;
            hval = 7;
        }
        if ((leafCount = MoveEntityEvent.helperCountBlocksBB(class_2397.class, 1, entity.field_6002, ePos.method_10086(yval), hval, yrange)) > 0) {
            return;
        }
        entity.field_6002.method_8501(ePos, sapling);
        Utility.debugMsg(1, ePos, key + " planted sapling.");
    }

    private static void mobGrowMushroomAction(class_1297 entity, String key) {
        int huge;
        class_3218 sWorld = (class_3218)entity.field_6002;
        class_2338 ePos = entity.method_24515();
        if (sWorld.method_8320(ePos).method_26204() instanceof class_2381) {
            return;
        }
        if (sWorld.method_8311(ePos)) {
            return;
        }
        if (!MoveEntityEvent.isGoodMushroomTemperature(entity)) {
            return;
        }
        Random mushRand = new Random(MoveEntityEvent.helperLongRandomSeed(entity.method_24515()));
        double fertilityDouble = mushRand.nextDouble();
        fertilityDouble = mushRand.nextDouble();
        if (fertilityDouble < 0.75) {
            Utility.debugMsg(1, ePos, key + " Mushroom fertility (" + fertilityDouble + ") non-growing spot.");
            return;
        }
        int smallMushroomCount = MoveEntityEvent.helperCountBlocksBB(class_2381.class, 4, (class_1937)sWorld, ePos, 4, 1);
        if (smallMushroomCount > 3) {
            Utility.debugMsg(1, ePos, key + " smallMushroomCount (" + smallMushroomCount + ") mushroom too crowded.");
            return;
        }
        int myceliumCount = MoveEntityEvent.helperCountBlocksBB(class_2418.class, 4, (class_1937)sWorld, ePos, 4, 1);
        if (myceliumCount > 2) {
            Utility.debugMsg(1, ePos, key + " myceliumCount (" + myceliumCount + ") mycelium too crowded.");
            return;
        }
        if (groundBlock == class_2246.field_10240) {
            sWorld.method_8501(ePos, class_2246.field_10559.method_9564());
            return;
        }
        if (groundBlock == class_2246.field_10580) {
            sWorld.method_8501(ePos, class_2246.field_10251.method_9564());
            return;
        }
        int hugeMushroomCount = MoveEntityEvent.helperCountBlocksBB(class_2381.class, 1, (class_1937)sWorld, ePos, 1, 1);
        if (hugeMushroomCount <= 0 && (huge = MoveEntityEvent.helperCountBlocksBB(class_2381.class, 1, (class_1937)sWorld, ePos, ModConfigs.getMushroomDensity(), 1)) > 0) {
            Utility.debugMsg(1, ePos, key + " huge (" + huge + ") mushroom too crowded.");
            return;
        }
        boolean growMushroom = false;
        if (class_3481.field_25806 == null) {
            Utility.warn("BlockTags.BASE_STONE_OVERWORLD missing.");
            if (groundBlock == class_2246.field_10340 || groundBlock == class_2246.field_10508 || groundBlock == class_2246.field_10115 || groundBlock == class_2246.field_10474) {
                growMushroom = true;
            }
        } else {
            if (!groundBlockState.method_26164(class_3481.field_25806)) {
                return;
            }
            growMushroom = true;
        }
        if (sWorld.method_18458((double)ePos.method_10263(), (double)ePos.method_10264(), (double)ePos.method_10260(), 12.0)) {
            growMushroom = false;
        }
        if (growMushroom) {
            double vx = entity.method_19538().method_10216() - ((double)ePos.method_10263() + 0.5);
            double vz = entity.method_19538().method_10215() - ((double)ePos.method_10260() + 0.5);
            class_243 vM = new class_243(vx, 0.0, vz).method_1029().method_1021(1.0).method_1031(0.0, 0.5, 0.0);
            entity.method_18799(entity.method_18798().method_1019(vM));
            if (fertilityDouble > 0.9) {
                sWorld.method_8501(ePos.method_10074(), class_2246.field_10402.method_9564());
            }
            class_2248 theBlock = null;
            theBlock = sWorld.field_9229.nextDouble() * 100.0 > 75.0 ? class_2246.field_10559 : class_2246.field_10251;
            sWorld.method_8501(ePos, theBlock.method_9564());
            class_2420 mb = (class_2420)theBlock;
            try {
                mb.method_9652(sWorld, sWorld.field_9229, ePos, theBlock.method_9564());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (theBlock == class_2246.field_10559) {
                for (int y = 9; y > 3; --y) {
                    class_2248 b = sWorld.method_8320(ePos.method_10086(y)).method_26204();
                    if (b != class_2246.field_10556) continue;
                    sWorld.method_8501(ePos.method_10086(y), class_2246.field_22122.method_9564());
                    break;
                }
            }
            Utility.debugMsg(1, ePos, key + " grow mushroom.");
        }
    }

    private static long helperLongRandomSeed(class_2338 ePos) {
        return (long)Math.abs(ePos.method_10263() * 31) + (long)Math.abs(ePos.method_10260() * 11) + (long)Math.abs(ePos.method_10264() * 7);
    }

    public static int helperCountBlocksOrthogonalBB(class_2248 searchBlock, int maxCount, class_1937 w, class_2338 bPos, int boundY) {
        return MoveEntityEvent.helperCountBlocksOrthogonalBB(searchBlock, maxCount, w, bPos, 0 - boundY, 0 + boundY);
    }

    public static int helperCountBlocksOrthogonalBB(class_2248 searchBlock, int maxCount, class_1937 w, class_2338 bPos, int lowerBoundY, int upperBoundY) {
        int count = 0;
        for (int j = lowerBoundY; j <= upperBoundY; ++j) {
            if (w.method_8320(bPos.method_10086(j).method_10078()).method_26204() == searchBlock) {
                ++count;
            }
            if (w.method_8320(bPos.method_10086(j).method_10067()).method_26204() == searchBlock) {
                ++count;
            }
            if (w.method_8320(bPos.method_10086(j).method_10095()).method_26204() == searchBlock) {
                ++count;
            }
            if (w.method_8320(bPos.method_10086(j).method_10072()).method_26204() == searchBlock) {
                ++count;
            }
            if (count < maxCount) continue;
            return count;
        }
        return count;
    }

    public static int helperCountBlocksBB(class_2248 searchBlock, int maxCount, class_1937 w, class_2338 bPos, int boxSize) {
        return MoveEntityEvent.helperCountBlocksBB(searchBlock, maxCount, w, bPos, boxSize, boxSize);
    }

    public static int helperCountBlocksBB(class_2248 searchBlock, int maxCount, class_1937 w, class_2338 bPos, int boxSize, int ySize) {
        int count = 0;
        int minX = bPos.method_10263() - boxSize;
        int maxX = bPos.method_10263() + boxSize;
        int minZ = bPos.method_10260() - boxSize;
        int maxZ = bPos.method_10260() + boxSize;
        int minY = bPos.method_10264() - ySize;
        int maxY = bPos.method_10264() + ySize;
        class_2338.class_2339 mPos = new class_2338.class_2339();
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dz = minZ; dz <= maxZ; ++dz) {
                for (int dy = minY; dy <= maxY; ++dy) {
                    mPos.method_10103(dx, dy, dz);
                    if (w.method_8320((class_2338)mPos).method_26204() != searchBlock || ++count < maxCount) continue;
                    return count;
                }
            }
        }
        Utility.debugMsg(1, bPos, Utility.getResourceLocationString(searchBlock) + " Sparse count:" + count + " countBlockBB ");
        return count;
    }

    public static int helperCountBlocksBB(Class<? extends class_2248> searchBlock, int maxCount, class_1937 w, class_2338 bPos, int boxSize) {
        return MoveEntityEvent.helperCountBlocksBB(searchBlock, maxCount, w, bPos, boxSize, 0);
    }

    public static int helperCountBlocksBB(Class<? extends class_2248> searchBlock, int maxCount, class_1937 w, class_2338 bPos, int boxSize, int ySize) {
        int count = 0;
        int minX = bPos.method_10263() - boxSize;
        int maxX = bPos.method_10263() + boxSize;
        int minZ = bPos.method_10260() - boxSize;
        int maxZ = bPos.method_10260() + boxSize;
        int minY = bPos.method_10264() - ySize;
        int maxY = bPos.method_10264() + ySize;
        class_2338.class_2339 mPos = new class_2338.class_2339();
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dz = minZ; dz <= maxZ; ++dz) {
                for (int dy = minY; dy <= maxY; ++dy) {
                    mPos.method_10103(dx, dy, dz);
                    if (!searchBlock.isInstance(w.method_8320((class_2338)mPos).method_26204()) || ++count < maxCount) continue;
                    return count;
                }
            }
        }
        Utility.debugMsg(1, bPos, searchBlock.getSimpleName() + " Sparse count:" + count + " countBlockBB ");
        return count;
    }

    private static boolean isGoodMushroomTemperature(class_1297 entity) {
        class_2338 ePos = MoveEntityEvent.getAdjustedBlockPos(entity);
        float biomeTemp = ((class_1959)entity.field_6002.method_23753(ePos).comp_349()).method_8712();
        Utility.debugMsg(1, ePos, "Mushroom Biome temp: " + biomeTemp + ".");
        if ((double)biomeTemp < ModConfigs.getMushroomMinTemp()) {
            return false;
        }
        return !((double)biomeTemp > ModConfigs.getMushroomMaxTemp());
    }

    private static boolean mobEatPlantsAction(class_1297 entity, String key, String regrowthType) {
        if (MoveEntityEvent.mobEatGrassOrFlower(entity, regrowthType)) {
            Utility.debugMsg(1, MoveEntityEvent.getAdjustedBlockPos(entity), key + " ate plants.");
            return true;
        }
        return false;
    }

    private static boolean isHorseTypeEatingNow(class_1297 entity) {
        class_1496 h;
        return entity instanceof class_1496 && (h = (class_1496)entity).method_6724();
    }

    private static void mobStumbleAction(class_1297 entity, String key) {
        entity.field_6002.method_22352(MoveEntityEvent.getAdjustedBlockPos(entity), true);
        Utility.debugMsg(1, MoveEntityEvent.getAdjustedBlockPos(entity), key + " stumbled over torch.");
    }

    private static void doVillagerRegrowthEvents(class_1646 ve, String debugKey, String regrowthActions) {
        if (!ve.method_24828()) {
            return;
        }
        if (groundBlockState.method_26204() instanceof class_2527) {
            return;
        }
        if (groundBlockState.method_26204() instanceof class_2555) {
            return;
        }
        if (ModConfigs.getDebugLevel() > 0) {
            class_2585 tName = new class_2585("");
            float veYaw = ve.method_5705(1.0f);
            tName = new class_2585("Reg-" + ve.method_23317() + "," + ve.method_23321() + ": " + veYaw);
            ve.method_5665((class_2561)tName);
        } else if (ve.method_5797() != null && ve.method_5797().toString().contains("Reg-")) {
            ve.method_5665(null);
        }
        if (MoveEntityEvent.vImproveFarm(ve, regrowthActions)) {
            Utility.debugMsg(1, ve.method_24515(), debugKey + " farm improved.");
        }
        if (regrowthActions.contains("h")) {
            MoveEntityEvent.vClericalHealing(ve);
            MoveEntityEvent.vToolMasterHealing(ve);
        }
        MoveEntityEvent.vBeeKeeperFlowers(ve);
        if (regrowthActions.contains("v")) {
            MoveEntityEvent.vImproveLeaves(ve, debugKey);
        }
        if (regrowthActions.contains("c") && (footBlock == class_2246.field_10214 || footBlock instanceof class_2320 || footBlock.method_9539().equals("block.byg.short_grass"))) {
            ve.field_6002.method_22352(ve.method_24515(), false);
            Utility.debugMsg(1, ve.method_24515(), debugKey + " grass cut.");
        }
        if (regrowthActions.contains("r")) {
            Utility.debugMsg(1, ve.method_24515(), debugKey + " try road improve.");
            MoveEntityEvent.vImproveRoads(ve, debugKey);
        }
        if (regrowthActions.contains("w")) {
            Utility.debugMsg(1, ve.method_24515(), " try town wall build.");
            MoveEntityEvent.vImproveWalls(ve, debugKey, regrowthActions);
        }
        if (regrowthActions.contains("p")) {
            Utility.debugMsg(1, ve.method_24515(), " try personal fence build.");
            MoveEntityEvent.vImproveFences(ve, debugKey, regrowthActions);
        }
        if (regrowthActions.contains("t") && footBlock != class_2246.field_10336 && MoveEntityEvent.vImproveLighting(ve)) {
            Utility.debugMsg(1, ve.method_24515(), debugKey + "-" + footBlock + ", " + groundBlock + " pitch: " + ve.method_5791() + " lighting improved.");
        }
    }

    private static void helperJumpAway(class_1297 e) {
        class_2248 postActionFootBlock = MoveEntityEvent.getAdjustedFootBlockState(e).method_26204();
        if (postActionFootBlock == class_2246.field_10194) {
            e.method_18800(0.0, 0.33, 0.0);
            return;
        }
        if (postActionFootBlock instanceof class_2544 || postActionFootBlock instanceof class_2354) {
            float veYaw = e.method_5705(1.0f) / 45.0f;
            int facingNdx = Math.round(veYaw);
            if (facingNdx < 0) {
                facingNdx = Math.abs(facingNdx);
            }
            double dx = (double)facingArray[facingNdx %= 8][0] / 2.0;
            double dz = (double)facingArray[facingNdx][1] / 2.0;
            e.method_18800(dx, 0.55, dz);
        }
    }

    private static boolean mobEatGrassOrFlower(class_1297 entity, String regrowthType) {
        class_2338 ePos = MoveEntityEvent.getAdjustedBlockPos(entity);
        if (!MoveEntityEvent.isGrassOrFlower(footBlockState)) {
            return false;
        }
        if (MoveEntityEvent.isKindOfGrassBlock(groundBlockState)) {
            MoveEntityEvent.mobTrodGrassBlock(entity);
        }
        entity.field_6002.method_22352(ePos, false);
        class_1309 le = (class_1309)entity;
        MoveEntityEvent.helperChildAgeEntity(entity);
        if (le.method_6063() > le.method_6032() && ModConfigs.getEatingHeals()) {
            class_1293 ei = new class_1293(class_1294.field_5914, 1, 0, false, true);
            le.method_6092(ei);
        }
        return true;
    }

    private static void mobTrodGrassBlock(class_1297 e) {
        class_2338 ePos = new class_2338(e.method_23317(), e.method_23318(), e.method_23321());
        class_1937 class_19372 = e.field_6002;
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            class_238 box = new class_238(ePos.method_10089(2).method_10086(2).method_10076(2), ePos.method_10088(2).method_10087(2).method_10077(2));
            List entityList = world.method_18023((class_5575)e.method_5864(), box, entity -> true);
            if (entityList.size() >= 9) {
                world.method_8501(ePos.method_10074(), class_2246.field_10194.method_9564());
                e.method_5643(class_1282.field_5855, 0.25f);
            }
        }
    }

    private static boolean isBlockGrassPathOrDirt(class_2248 tempBlock) {
        return tempBlock == class_2246.field_10194 || tempBlock == class_2246.field_10566;
    }

    private static void helperChildAgeEntity(class_1297 ent) {
        if (ent.field_6012 < 0) {
            ent.field_6012 += 30;
        }
    }

    private static boolean mobGrowTallAction(class_1297 ent, String key) {
        if (footBlock == class_2246.field_10479) {
            class_2338 ePos = MoveEntityEvent.getAdjustedBlockPos(ent);
            class_2256 ib = (class_2256)footBlock;
            try {
                ib.method_9652((class_3218)ent.field_6002, ent.field_6002.field_9229, ePos, ent.field_6002.method_8320(ePos));
                Utility.debugMsg(1, ePos, key + " grew and hid in tall plant.");
            }
            catch (Exception e) {
                Utility.debugMsg(1, ent.method_24515(), key + " caught grow attempt exception.");
            }
            return true;
        }
        return false;
    }

    private static class_2680 helperBiomeRoadBlockType(class_1959 localBiome) {
        class_2680 gateBlockType = class_2246.field_10194.method_9564();
        if (biomeCategory == class_1959.class_1961.field_9368) {
            gateBlockType = class_2246.field_10218.method_9564();
        }
        return gateBlockType;
    }

    private static boolean vImproveFarm(class_1646 ve, String regrowthType) {
        if (ve.method_7231().method_16924() != class_3852.field_17056) {
            return false;
        }
        class_2338 vePos = MoveEntityEvent.getAdjustedBlockPos((class_1297)ve);
        class_2248 groundBlock = groundBlockState.method_26204();
        class_2248 footBlock = footBlockState.method_26204();
        if (MoveEntityEvent.helperCountBlocksOrthogonalBB(class_2246.field_10362, 1, ve.field_6002, vePos.method_10087(1), 0) > 0) {
            if (MoveEntityEvent.isNearWater(ve.field_6002, vePos.method_10087(1)) && groundBlock instanceof class_2372) {
                ve.field_6002.method_8501(vePos.method_10074(), class_2246.field_10362.method_9564());
                return true;
            }
            if (!regrowthType.contains("t") || footBlock != class_2246.field_10124) {
                return false;
            }
            if (ve.field_6002.method_8314(class_1944.field_9282, vePos) > 12) {
                return false;
            }
            int veX = vePos.method_10263();
            int veY = vePos.method_10264();
            int veZ = vePos.method_10260();
            if (lastTorchX == veX && lastTorchY == veY && lastTorchZ == veZ) {
                return false;
            }
            boolean placeTorch = false;
            int waterValue = MoveEntityEvent.helperCountBlocksOrthogonalBB(class_2246.field_10382, 1, ve.field_6002, vePos.method_10074(), 0);
            if (waterValue > 0 && groundBlockState.method_26164(class_3481.field_15475) || groundBlock == class_2246.field_10467) {
                ve.field_6002.method_8501(vePos, class_2246.field_10336.method_9564());
                lastTorchX = veX;
                lastTorchY = veY;
                lastTorchZ = veZ;
                return true;
            }
        }
        return false;
    }

    private static void vBeeKeeperFlowers(class_1646 ve) {
        if (!ve.method_7231().method_16924().method_35202().contains("beekeeper")) {
            return;
        }
        if (ve.method_23317() % 6.0 == 0.0 && ve.method_23321() % 7.0 == 0.0 && MoveEntityEvent.isBlockGrassOrDirt(groundBlockState) && MoveEntityEvent.helperCountBlocksOrthogonalBB(class_2246.field_10194, 1, ve.field_6002, ve.method_24515().method_10074(), 0) == 1) {
            class_2680 flowerBlockState = class_2246.field_10573.method_9564();
            ve.field_6002.method_8501(adjustedPos, flowerBlockState);
        }
    }

    private static void vToolMasterHealing(class_1646 ve) {
        if (ve.method_7231().method_16924() != class_3852.field_17064) {
            return;
        }
        long daytime = ve.field_6002.method_8532() % 24000L;
        if (daytime < 9000L || daytime > 11000L) {
            return;
        }
        class_1937 class_19372 = ve.field_6002;
        if (class_19372 instanceof class_3218) {
            class_3218 varW = (class_3218)class_19372;
            int villagerLevel = ve.method_7231().method_16925();
            if (villagerLevel < 1) {
                return;
            }
            class_2338 vePos = new class_2338(ve.method_23317(), ve.method_23318() + 0.99, ve.method_23321());
            class_238 box = new class_238(vePos.method_10089(6).method_10086(3).method_10076(6), vePos.method_10088(6).method_10087(2).method_10077(6));
            List l = varW.method_18023((class_5575)class_1299.field_6147, box, e -> true);
            for (class_1439 e2 : l) {
                boolean heal = true;
                if (e2.method_6032() >= e2.method_6063()) {
                    heal = false;
                }
                if (e2.method_6112(class_1294.field_5924) != null) {
                    heal = false;
                }
                if (!heal) continue;
                e2.method_37222(new class_1293(class_1294.field_5924, villagerLevel * 51, 0), (class_1297)ve);
                ve.method_37222(new class_1293(class_1294.field_5924, villagerLevel * 11, 0), (class_1297)ve);
                ve.field_6002.method_8396(null, vePos, class_3417.field_20680, class_3419.field_15254, 0.5f, 0.5f);
                return;
            }
        }
    }

    private static void vClericalHealing(class_1646 ve) {
        if (ve.method_7231().method_16924() != class_3852.field_17055) {
            return;
        }
        long daytime = ve.field_6002.method_8532() % 24000L;
        if (daytime < 9000L || daytime > 11000L) {
            return;
        }
        class_1937 class_19372 = ve.field_6002;
        if (class_19372 instanceof class_3218) {
            class_3218 varW = (class_3218)class_19372;
            int clericalLevel = ve.method_7231().method_16925();
            class_2338 vePos = new class_2338(ve.method_23317(), ve.method_23318() + 0.99, ve.method_23321());
            class_238 box = new class_238(vePos.method_10089(4).method_10086(2).method_10076(4), vePos.method_10088(4).method_10087(2).method_10077(4));
            List l = varW.method_8333(null, box, e -> e instanceof class_1646 || e instanceof class_1657);
            for (class_1297 e2 : l) {
                class_1657 pe;
                int rep;
                boolean heal = true;
                class_1309 le = (class_1309)e2;
                if (le.method_6032() >= le.method_6063()) {
                    heal = false;
                }
                if (le.method_6112(class_1294.field_5924) != null) {
                    heal = false;
                }
                if (e2 instanceof class_1657 && (rep = ve.method_20594(pe = (class_1657)e2)) < 0) {
                    heal = false;
                }
                if (!heal) continue;
                le.method_37222(new class_1293(class_1294.field_5924, clericalLevel * 51, 0), (class_1297)ve);
                ve.field_6002.method_8396(null, vePos, class_3417.field_26942, class_3419.field_15254, 1.2f, 1.52f);
                return;
            }
        }
    }

    private static void vImproveLeaves(class_1646 ve, String key) {
        float veYaw = ve.method_5705(1.0f) / 45.0f;
        class_2338 vePos = MoveEntityEvent.getAdjustedBlockPos((class_1297)ve);
        int facingNdx = Math.round(veYaw);
        if (facingNdx < 0) {
            facingNdx = Math.abs(facingNdx);
        }
        int dx = facingArray[facingNdx %= 8][0];
        int dz = facingArray[facingNdx][1];
        class_2338 tmpBP = null;
        class_2680 tempBS = null;
        class_2248 tempBlock = null;
        boolean destroyBlock = false;
        for (int iY = 0; iY < 2; ++iY) {
            boolean persistantLeaves;
            tmpBP = new class_2338(vePos.method_10263() + dx, vePos.method_10264() + iY, vePos.method_10260() + dz);
            tempBS = ve.field_6002.method_8320(tmpBP);
            tempBlock = tempBS.method_26204();
            if (tempBlock instanceof class_2397 && !(persistantLeaves = ((Boolean)tempBS.method_11654((class_2769)class_2397.field_11200)).booleanValue())) {
                destroyBlock = true;
            }
            if (tempBlock instanceof class_2266) {
                destroyBlock = true;
            }
            if (!destroyBlock) continue;
            ve.field_6002.method_22352(tmpBP, false);
            destroyBlock = false;
            Utility.debugMsg(1, vePos, key + " cleared " + tempBlock.method_9539().toString());
        }
    }

    private static boolean vImproveLighting(class_1646 ve) {
        class_2338 vePos = MoveEntityEvent.getAdjustedBlockPos((class_1297)ve);
        int blockLightValue = ve.field_6002.method_8314(class_1944.field_9282, vePos);
        int skyLightValue = ve.field_6002.method_8314(class_1944.field_9284, vePos);
        if (blockLightValue > ModConfigs.getTorchLightLevel()) {
            return false;
        }
        if (skyLightValue > 11) {
            return false;
        }
        if (ve.method_6113()) {
            return false;
        }
        if (footBlockState.method_26204() instanceof class_2244) {
            return false;
        }
        if (MoveEntityEvent.isValidGroundBlockToPlaceTorchOn(ve) && footBlockState.method_26215() || MoveEntityEvent.isNatProgPebbleOrStick()) {
            ve.field_6002.method_8652(vePos, class_2246.field_10336.method_9564(), 3);
        }
        return true;
    }

    private static void vImproveRoads(class_1646 ve, String debugkey) {
        class_2585 tName = new class_2585("-");
        isRoadPiece = false;
        boolean isInsideStructurePiece = false;
        boolean test = true;
        class_2338 piecePos = null;
        List<Object> sList = new ArrayList();
        if (test) {
            class_1923 c = new class_1923(ve.method_24515());
            sList = MoveEntityEvent.getStarts(ve.field_6002, class_3195.field_24858, c.field_9181, c.field_9180);
        }
        if (!sList.isEmpty()) {
            for (class_3443 piece : ((class_3449)sList.get(0)).method_14963()) {
                int i;
                piecePos = piece.method_35458();
                if (!piece.method_14935().method_14662((class_2382)ve.method_24515())) continue;
                piecePos = piece.method_35458();
                if (piece.toString().contains("streets")) {
                    isRoadPiece = true;
                }
                if ((i = piece.toString().indexOf("minecraft")) >= 0) {
                    tName = new class_2585(isRoadPiece + " " + piece.toString().substring(i));
                } else {
                    i = piece.toString().indexOf("minecraft");
                    if (i >= 0) {
                        tName = new class_2585(isRoadPiece + " " + piece.toString().substring(i));
                    }
                }
                isInsideStructurePiece = true;
                break;
            }
        }
        if (MoveEntityEvent.vImproveRoadsClearSnow((class_1297)ve)) {
            Utility.debugMsg(1, ve.method_24515(), debugkey + " clear snow on road.");
        }
        if (MoveEntityEvent.vImproveRoadsFixPatches((class_1297)ve)) {
            Utility.debugMsg(1, ve.method_24515(), debugkey + " fix patches on road.");
        }
        if (MoveEntityEvent.vImproveRoadsFixPotholes((class_1297)ve)) {
            Utility.debugMsg(1, ve.method_24515(), debugkey + " fix potholes in road.");
        }
        if (MoveEntityEvent.vImproveRoadsSmoothHeight(ve)) {
            Utility.debugMsg(1, ve.method_24515(), debugkey + " Smooth road slope.");
        }
    }

    private static List<class_3449> getStarts(class_1937 worldIn, class_3195<?> struct, int x, int z) {
        ArrayList list = Lists.newArrayList();
        class_2791 ichunk = worldIn.method_22342(x, z, class_2806.field_16422);
        for (Map.Entry r : ichunk.method_12179().entrySet()) {
            if (((class_5312)r.getKey()).field_24835 != struct) continue;
            LongIterator longiterator = ((LongSet)r.getValue()).iterator();
            while (longiterator.hasNext()) {
                long i = longiterator.nextLong();
                class_2791 istructurereader = worldIn.method_22342(class_1923.method_8325((long)i), class_1923.method_8332((long)i), class_2806.field_16423);
                class_3449 structurestart = istructurereader.method_12181((class_5312)r.getKey());
                if (structurestart == null) continue;
                list.add(structurestart);
            }
        }
        return list;
    }

    private static boolean vImproveRoadsClearSnow(class_1297 e) {
        class_2248 biomeRoadBlock = MoveEntityEvent.helperBiomeRoadBlockType(localBiome).method_26204();
        if (groundBlock != biomeRoadBlock) {
            return false;
        }
        if (footBlock == class_2246.field_10477) {
            e.field_6002.method_22352(adjustedPos, false);
            footBlockState = class_2246.field_10124.method_9564();
            footBlock = footBlockState.method_26204();
            return true;
        }
        return false;
    }

    private static boolean vImproveRoadsFixPatches(class_1297 e) {
        if (!e.field_6002.method_8311(e.method_24515())) {
            return false;
        }
        class_2248 biomeRoadBlock = MoveEntityEvent.helperBiomeRoadBlockType(localBiome).method_26204();
        if (groundBlock == biomeRoadBlock) {
            return false;
        }
        int roadY = 0;
        int roadBlocks = 0;
        class_2338 vePos = MoveEntityEvent.getAdjustedBlockPos(e);
        for (int i = 0; i < 4; ++i) {
            roadY = e.field_6002.method_8624(class_2902.class_2903.field_13203, vePos.method_10263() + dx[i], vePos.method_10260() + dz[i]) - 1;
            class_2248 tempBlock = e.field_6002.method_8320(new class_2338(vePos.method_10263() + dx[i], roadY, vePos.method_10260() + dz[i])).method_26204();
            if (tempBlock != biomeRoadBlock || ++roadBlocks < 3) continue;
            if (footBlock instanceof class_2488) {
                e.field_6002.method_22352(adjustedPos, false);
                footBlockState = class_2246.field_10124.method_9564();
                footBlock = footBlockState.method_26204();
            }
            e.field_6002.method_8501(adjustedPos.method_10074(), biomeRoadBlock.method_9564());
            return true;
        }
        return false;
    }

    private static boolean vImproveRoadsFixPotholes(class_1297 e) {
        if (!e.field_6002.method_8311(e.method_24515())) {
            return false;
        }
        class_2248 biomeRoadBlock = MoveEntityEvent.helperBiomeRoadBlockType(localBiome).method_26204();
        if (groundBlock == biomeRoadBlock && footBlock instanceof class_2488) {
            e.field_6002.method_22352(MoveEntityEvent.getAdjustedBlockPos(e), false);
        }
        class_2338 vePos = e.method_24515();
        int veX = vePos.method_10263();
        int veY = vePos.method_10264();
        int veZ = vePos.method_10260();
        int roadY = 0;
        int higherRoadBlocks = 0;
        for (int i = 0; i < 4; ++i) {
            roadY = e.field_6002.method_8624(class_2902.class_2903.field_13203, veX + dx[i], veZ + dz[i]) - 1;
            class_2248 tempBlock = e.field_6002.method_8320(new class_2338(veX + dx[i], roadY, veZ + dz[i])).method_26204();
            if (tempBlock != biomeRoadBlock || roadY <= veY) continue;
            ++higherRoadBlocks;
        }
        if (higherRoadBlocks == 4) {
            e.field_6002.method_8501(adjustedPos, biomeRoadBlock.method_9564());
            return true;
        }
        return false;
    }

    private static boolean vImproveRoadsSmoothHeight(class_1646 ve) {
        if (!ve.method_24828()) {
            return false;
        }
        if (ve.method_6109()) {
            return false;
        }
        class_2338 vePos = MoveEntityEvent.getAdjustedBlockPos((class_1297)ve);
        if (!ve.field_6002.method_8311(ve.method_24515())) {
            return false;
        }
        class_2248 biomeRoadBlock = MoveEntityEvent.helperBiomeRoadBlockType(localBiome).method_26204();
        if (biomeRoadBlock == class_2246.field_10467 && !isRoadPiece) {
            return false;
        }
        if (groundBlockState.method_26204() != biomeRoadBlock && footBlockState.method_26204() != biomeRoadBlock) {
            return false;
        }
        class_2680 biomeRoadBlockState = biomeRoadBlock.method_9564();
        int poiDistance = 3;
        if (class_1959.method_40136((class_6880)ve.field_6002.method_23753(vePos)) == class_1959.class_1961.field_9368) {
            poiDistance = 7;
        }
        if (MoveEntityEvent.isNearbyPoi(ve, localBiome, vePos, poiDistance)) {
            return false;
        }
        int veX = vePos.method_10263();
        int veY = vePos.method_10264();
        int veZ = vePos.method_10260();
        int roadY = 0;
        for (int i = 0; i < 4; ++i) {
            class_2248 tempBlock;
            roadY = ve.field_6002.method_8624(class_2902.class_2903.field_13203, veX + dx[i], veZ + dz[i]) - 1;
            if (roadY <= veY || (tempBlock = ve.field_6002.method_8320(new class_2338(veX + dx[i], roadY, veZ + dz[i])).method_26204()) != biomeRoadBlock) continue;
            ve.field_6002.method_8501(new class_2338(veX, veY, veZ), biomeRoadBlockState);
            if (ve.field_6002.method_8320(vePos.method_10086(2)).method_26204() == biomeRoadBlockState.method_26204()) {
                ve.field_6002.method_22352(vePos.method_10086(2), true);
            } else if (ve.field_6002.method_8320(vePos.method_10086(3)).method_26204() == biomeRoadBlockState.method_26204()) {
                ve.field_6002.method_22352(vePos.method_10086(3), true);
            }
            ve.method_18800(0.0, 0.4, 0.0);
            return true;
        }
        return false;
    }

    private static boolean isNearbyPoi(class_1646 ve, class_1959 localBiome, class_2338 vePos, int poiDistance) {
        Collection result = ((class_3218)ve.field_6002).method_19494().method_22383(t -> true, ve.method_24515(), poiDistance, class_4153.class_4155.field_18489).collect(Collectors.toCollection(ArrayList::new));
        if (!result.isEmpty()) {
            for (class_4156 p : result) {
                int disX = Math.abs(ve.method_24515().method_10263() - p.method_19141().method_10263());
                int disZ = Math.abs(ve.method_24515().method_10260() - p.method_19141().method_10260());
                if (disX >= poiDistance || disZ >= poiDistance) continue;
                Utility.debugMsg(1, vePos, "Point of Interest too Close: " + p.method_19142().toString() + ".");
                return true;
            }
        }
        return false;
    }

    private static boolean vImproveVillageWall(class_1646 ve, String regrowthActions) {
        if (!ve.method_18868().method_18904(class_4140.field_18440).isPresent()) {
            return false;
        }
        if (!MoveEntityEvent.isOkayToBuildWallHere(ve)) {
            return false;
        }
        class_2338 gVMPPos = ((class_4208)ve.method_18868().method_18904(class_4140.field_18440).get()).method_19446();
        if (ModConfigs.getPlayerWallControlBlock() != class_2246.field_10124) {
            if (ve.field_6002.method_22350(gVMPPos).method_12033() < 200L) {
                ve.field_6002.method_8501(gVMPPos.method_10086(1), ModConfigs.getPlayerWallControlBlock().method_9564());
            }
            if (ve.field_6002.method_8320(gVMPPos.method_10086(1)).method_26204() != ModConfigs.playerWallControlBlock) {
                return false;
            }
        }
        class_2338 vePos = MoveEntityEvent.getAdjustedBlockPos((class_1297)ve);
        Object key = "minecraft:" + biomeCategory.toString();
        key = ((String)key).toLowerCase();
        Utility.debugMsg(1, vePos, (String)key + " wall improvement.");
        WallBiomeDataManager.WallBiomeDataItem currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem((String)key);
        Utility.debugMsg(1, vePos, (String)key + " biome for wall improvement. ");
        int wallRadius = currentWallBiomeDataItem.getWallDiameter();
        wallRadius = wallRadius / 2 - 1;
        if (MoveEntityEvent.isOnWallRadius((class_1297)ve, wallRadius, gVMPPos)) {
            class_2680 wallTypeBlockState;
            class_2680 wallBlock;
            int wallTorchSpacing;
            Utility.debugMsg(1, ve.method_24515(), "villager on wall perimeter: " + wallRadius);
            Collection result = ((class_3218)ve.field_6002).method_19494().method_22383(t -> t == class_4158.field_18518, ve.method_24515(), 41, class_4153.class_4155.field_18489).collect(Collectors.toCollection(ArrayList::new));
            boolean buildWall = true;
            if (!result.isEmpty()) {
                for (class_4156 P : result) {
                    if (gVMPPos.method_10263() == P.method_19141().method_10263() && gVMPPos.method_10264() == P.method_19141().method_10264() && gVMPPos.method_10260() == P.method_19141().method_10260()) continue;
                    int disX = Math.abs(ve.method_24515().method_10263() - P.method_19141().method_10263());
                    int disZ = Math.abs(ve.method_24515().method_10260() - P.method_19141().method_10260());
                    if (disX >= wallRadius || disZ >= wallRadius) continue;
                    buildWall = false;
                    break;
                }
            }
            if (buildWall && MoveEntityEvent.helperPlaceOneWallPiece((class_1297)ve, wallRadius, wallTorchSpacing = (wallRadius + 1) / 4, wallBlock = (wallTypeBlockState = currentWallBiomeDataItem.getWallBlockState()), gVMPPos)) {
                if (regrowthActions.contains("t") && MoveEntityEvent.isValidTorchLocation(wallRadius, wallTorchSpacing, MoveEntityEvent.getAbsVX((class_1297)ve, gVMPPos), MoveEntityEvent.getAbsVZ((class_1297)ve, gVMPPos), ve.field_6002.method_8320(vePos).method_26204())) {
                    ve.field_6002.method_8652(vePos.method_10084(), class_2246.field_10336.method_9564(), 3);
                }
                MoveEntityEvent.helperJumpAway((class_1297)ve);
                return true;
            }
        }
        return false;
    }

    private static boolean vImproveHomeFence(class_1646 ve, class_2338 vHomePos, String regrowthActions) {
        class_2680 fenceBlockState;
        class_2338 vePos = MoveEntityEvent.getAdjustedBlockPos((class_1297)ve);
        Object key = "minecraft:" + biomeCategory.toString();
        WallBiomeDataManager.WallBiomeDataItem currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem((String)(key = ((String)key).toLowerCase()));
        if (currentWallBiomeDataItem == null && (currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem((String)(key = "minecraft:" + biomeCategory.toString().toLowerCase()))) == null) {
            currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem("minecraft:plains");
        }
        int homeFenceDiameter = currentWallBiomeDataItem.getWallDiameter();
        int wallTorchSpacing = (homeFenceDiameter /= 4) / 4;
        homeFenceDiameter = homeFenceDiameter / 2 - 1;
        int absvx = (int)Math.abs(ve.method_23317() - (double)vHomePos.method_10263());
        int absvz = (int)Math.abs(ve.method_23321() - (double)vHomePos.method_10260());
        Collection result = ((class_3218)ve.field_6002).method_19494().method_22383(t -> t == class_4158.field_18517, vePos, 17, class_4153.class_4155.field_18489).collect(Collectors.toCollection(ArrayList::new));
        boolean buildFence = true;
        if (!result.isEmpty()) {
            for (class_4156 P : result) {
                if (vHomePos.method_10263() == P.method_19141().method_10263() && vHomePos.method_10264() == P.method_19141().method_10264() && vHomePos.method_10260() == P.method_19141().method_10260()) continue;
                int disX = Math.abs(vePos.method_10263() - P.method_19141().method_10263());
                int disZ = Math.abs(vePos.method_10260() - P.method_19141().method_10260());
                Utility.debugMsg(1, P.method_19141(), "extra Point of Interest Found.");
                if (disX >= homeFenceDiameter || disZ >= homeFenceDiameter) continue;
                buildFence = false;
                break;
            }
        } else if (result.isEmpty()) {
            buildFence = true;
        }
        if (buildFence && MoveEntityEvent.helperPlaceOneWallPiece((class_1297)ve, homeFenceDiameter, wallTorchSpacing, fenceBlockState = currentWallBiomeDataItem.getFenceBlockState(), vHomePos)) {
            if (regrowthActions.contains("t") && MoveEntityEvent.isValidTorchLocation(homeFenceDiameter, wallTorchSpacing, absvx, absvz, ve.field_6002.method_8320(vePos).method_26204())) {
                ve.field_6002.method_8501(vePos.method_10084(), class_2246.field_10336.method_9564());
            }
            MoveEntityEvent.helperJumpAway((class_1297)ve);
            return true;
        }
        return false;
    }

    private static void vImproveWalls(class_1646 ve, String key, String regrowthType) {
        if (groundBlockState.method_26215()) {
            return;
        }
        class_2338 vePos = MoveEntityEvent.getAdjustedBlockPos((class_1297)ve);
        if (!ve.method_18868().method_18904(class_4140.field_18440).isPresent()) {
            return;
        }
        Utility.debugMsg(1, vePos, "Checking Improve Wall.");
        if (MoveEntityEvent.vImproveVillageWall(ve, regrowthType)) {
            Utility.debugMsg(1, vePos, "Meeting Wall Improved.");
        }
    }

    private static void vImproveFences(class_1646 ve, String key, String regrowthType) {
        class_2338 ePos = ve.method_24515();
        class_4095 vb = ve.method_18868();
        Optional vMeetingPlace = vb.method_18904(class_4140.field_18440);
        if (!vMeetingPlace.isPresent()) {
            return;
        }
        if (MoveEntityEvent.isOkayToBuildWallHere(ve)) {
            class_4208 gVMP = (class_4208)vMeetingPlace.get();
            class_2338 villageMeetingPlaceBlockPos = gVMP.method_19446();
            if (!(ve.field_6002.method_8320(villageMeetingPlaceBlockPos.method_10086(1)).method_26204() instanceof class_2544)) {
                return;
            }
            if (regrowthType.contains("p")) {
                Utility.debugMsg(1, ePos, "Checking Improve Fence.");
                Optional villagerHome = vb.method_18904(class_4140.field_18438);
                if (!villagerHome.isPresent()) {
                    return;
                }
                class_4208 gVHP = (class_4208)villagerHome.get();
                class_2338 villagerHomePos = gVHP.method_19446();
                if (MoveEntityEvent.isOutsideMeetingPlaceWall(ve, vMeetingPlace, ((class_4208)vMeetingPlace.get()).method_19446(), localBiome)) {
                    Utility.debugMsg(1, ePos, "Outside meeting place wall.");
                    if (MoveEntityEvent.vImproveHomeFence(ve, villagerHomePos, regrowthType)) {
                        Utility.debugMsg(1, ePos, "Home Fence Improved.");
                    }
                }
            }
        }
    }

    private static boolean isFootBlockOkayToBuildIn(class_2680 footBlockState) {
        if (footBlockState.method_26215() || MoveEntityEvent.isGrassOrFlower(footBlockState)) {
            return true;
        }
        if (footBlockState.method_26204() instanceof class_2488) {
            return true;
        }
        return MoveEntityEvent.isNatProgPebbleOrStick();
    }

    private static boolean isNatProgPebbleOrStick() {
        String rl = Utility.getResourceLocationString(footBlock);
        if (rl.contains("natprog") && rl.contains("pebble")) {
            return true;
        }
        if (rl.equals("natprog") && rl.contains("twigs")) {
            return true;
        }
        return rl.equals("minecraft") && rl.contains("button");
    }

    private static boolean isGrassOrFlower(class_2680 footBlockState) {
        class_2248 footBlock;
        block10: {
            footBlock = footBlockState.method_26204();
            if (footBlock instanceof class_2521) {
                return true;
            }
            if (footBlock instanceof class_2356) {
                return true;
            }
            if (footBlock instanceof class_2320) {
                return true;
            }
            if (footBlock instanceof class_2526) {
                return true;
            }
            try {
                if (footBlockState.method_26164(class_3481.field_20339)) {
                    return true;
                }
                if (footBlockState.method_26164(class_3481.field_20338)) {
                    return true;
                }
            }
            catch (Exception e) {
                if (ModConfigs.getDebugLevel() <= 0) break block10;
                System.out.println("Tag Exception 1009-1014:" + footBlock.method_9539() + ".");
            }
        }
        if (footBlock.method_9539().equals("block.byg.short_grass")) {
            return true;
        }
        if (ModConfigs.getDebugLevel() > 0) {
            System.out.println("Not grass or Flower:" + footBlock.method_9539() + ".");
        }
        return false;
    }

    private static boolean isImpossibleRegrowthEvent(String regrowthType) {
        if (regrowthType.equals(ACTION_EAT) && footBlockState.method_26215()) {
            return true;
        }
        if (regrowthType.equals(ACTION_GROW) && footBlockState.method_26204() instanceof class_2320) {
            return true;
        }
        if (regrowthType.equals(ACTION_GROW) && footBlockState.method_26204() instanceof class_2356) {
            return true;
        }
        return regrowthType.equals(ACTION_TALL) && footBlockState.method_26204() instanceof class_2320;
    }

    private static boolean isOkayToBuildWallHere(class_1646 ve) {
        boolean okayToBuildWalls = true;
        if (!MoveEntityEvent.isOnGround((class_1297)ve)) {
            okayToBuildWalls = false;
        }
        if (!MoveEntityEvent.isFootBlockOkayToBuildIn(footBlockState)) {
            okayToBuildWalls = false;
        }
        if (!MoveEntityEvent.isValidGroundBlockToBuildWallOn((class_1297)ve)) {
            okayToBuildWalls = false;
        }
        return okayToBuildWalls;
    }

    private static boolean isOnGround(class_1297 e) {
        return e.method_24828();
    }

    private static boolean isOutsideMeetingPlaceWall(class_1646 ve, Optional<class_4208> vMeetingPlace, class_2338 meetingPlacePos, class_1959 localBiome) {
        class_2338 vePos = MoveEntityEvent.getAdjustedBlockPos((class_1297)ve);
        Object key = "minecraft:" + Utility.getBiomeCategory(localBiome).toString();
        int wallDiameter = 64;
        WallBiomeDataManager.WallBiomeDataItem currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem((String)(key = ((String)key).toLowerCase()));
        if (currentWallBiomeDataItem != null) {
            wallDiameter = currentWallBiomeDataItem.getWallDiameter();
        }
        wallDiameter = wallDiameter / 2 - 1;
        int absVMpX = Math.abs(vePos.method_10263() - meetingPlacePos.method_10263());
        int absVMpZ = Math.abs(vePos.method_10260() - meetingPlacePos.method_10260());
        if (absVMpX > wallDiameter + 1) {
            return true;
        }
        return absVMpZ > wallDiameter + 1;
    }

    private static boolean isValidGroundBlockToPlaceTorchOn(class_1646 ve) {
        String key = Utility.getResourceLocationString(groundBlockState);
        WallFoundationDataManager.wallFoundationItem currentWallFoundationItem = WallFoundationDataManager.getWallFoundationInfo(key);
        return currentWallFoundationItem != null;
    }

    private static boolean isValidGroundBlockToBuildWallOn(class_1297 e) {
        if (e.field_6002.method_8314(class_1944.field_9284, e.method_24515()) < 13) {
            return false;
        }
        if (groundBlock instanceof class_2488) {
            return false;
        }
        if (groundBlock instanceof class_2527) {
            return false;
        }
        if (e.field_6002.method_8320(e.method_24515().method_10084()).method_26204() instanceof class_2544) {
            return false;
        }
        if (e.field_6002.method_8320(e.method_24515().method_10074()).method_26204() instanceof class_2544) {
            return false;
        }
        if (e.field_6002.method_8320(e.method_24515().method_10087(1)).method_26204() instanceof class_2544) {
            return false;
        }
        if (e.field_6002.method_8320(e.method_24515().method_10087(2)).method_26204() instanceof class_2527) {
            return false;
        }
        if (e.field_6002.method_8320(e.method_24515().method_10084()).method_26204() instanceof class_2527) {
            return false;
        }
        if (e.field_6002.method_8320(e.method_24515().method_10074()).method_26204() instanceof class_2527) {
            return false;
        }
        if (e.field_6002.method_8320(e.method_24515().method_10087(1)).method_26204() instanceof class_2527) {
            return false;
        }
        if (e.field_6002.method_8320(e.method_24515().method_10087(2)).method_26204() instanceof class_2527) {
            return false;
        }
        groundBlock = groundBlockState.method_26204();
        Utility.debugMsg(1, e.method_24515(), "Build Wall : gb" + Utility.getResourceLocationString(groundBlock) + ", fb:" + Utility.getResourceLocationString(footBlock));
        WallFoundationDataManager.wallFoundationItem currentWallFoundationItem = WallFoundationDataManager.getWallFoundationInfo(Utility.getResourceLocationString(groundBlock));
        return currentWallFoundationItem != null;
    }

    private static boolean isValidTorchLocation(int wallRadius, int wallTorchSpacing, int absvx, int absvz, class_2248 wallFenceBlock) {
        boolean hasAWallUnderIt = false;
        if (wallFenceBlock instanceof class_2544) {
            hasAWallUnderIt = true;
        }
        if (wallFenceBlock instanceof class_2354) {
            hasAWallUnderIt = true;
        }
        if (!hasAWallUnderIt) {
            return false;
        }
        if (absvx == wallRadius && absvz % wallTorchSpacing == 1) {
            return true;
        }
        if (absvx % wallTorchSpacing == 1 && absvz == wallRadius) {
            return true;
        }
        return absvx == wallRadius && absvz == wallRadius;
    }

    private static boolean isOnWallRadius(class_1297 e, int wallRadius, class_2338 gVMPPos) {
        if (MoveEntityEvent.getAbsVX(e, gVMPPos) == wallRadius && MoveEntityEvent.getAbsVZ(e, gVMPPos) <= wallRadius) {
            return true;
        }
        return MoveEntityEvent.getAbsVZ(e, gVMPPos) == wallRadius && MoveEntityEvent.getAbsVX(e, gVMPPos) <= wallRadius;
    }

    private static int getAbsVZ(class_1297 e, class_2338 gVMPPos) {
        return Math.abs(MoveEntityEvent.getVZ(e, gVMPPos));
    }

    private static int getAbsVX(class_1297 e, class_2338 gVMPPos) {
        int absvx = Math.abs(MoveEntityEvent.getVX(e, gVMPPos));
        return absvx;
    }

    private static int getVZ(class_1297 e, class_2338 gVMPPos) {
        return (int)(e.method_23321() - (double)gVMPPos.method_10260());
    }

    private static int getVX(class_1297 e, class_2338 gVMPPos) {
        return (int)(e.method_23317() - (double)gVMPPos.method_10263());
    }

    private static boolean helperPlaceOneWallPiece(class_1297 e, int wallRadius, int wallTorchSpacing, class_2680 wallType, class_2338 gVMPPos) {
        class_2680 gateBlockState = (class_2680)((class_2680)class_2246.field_10188.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11034)).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(true));
        class_2350 d = null;
        if (MoveEntityEvent.getAbsVX(e, gVMPPos) == wallRadius && MoveEntityEvent.getAbsVZ(e, gVMPPos) <= wallRadius) {
            d = MoveEntityEvent.getVX(e, gVMPPos) > 0 ? class_2350.field_11034 : class_2350.field_11039;
            return MoveEntityEvent.helperPlaceWallPiece(e, wallType, (class_2680)gateBlockState.method_11657((class_2769)FACING, (Comparable)d), MoveEntityEvent.getVZ(e, gVMPPos));
        }
        if (MoveEntityEvent.getAbsVZ(e, gVMPPos) == wallRadius && MoveEntityEvent.getAbsVX(e, gVMPPos) <= wallRadius) {
            d = MoveEntityEvent.getVZ(e, gVMPPos) > 0 ? class_2350.field_11043 : class_2350.field_11035;
            return MoveEntityEvent.helperPlaceWallPiece(e, wallType, (class_2680)gateBlockState.method_11657((class_2769)FACING, (Comparable)d), MoveEntityEvent.getVX(e, gVMPPos));
        }
        return false;
    }

    private static boolean helperPlaceWallPiece(class_1297 e, class_2680 wallType, class_2680 gateBlockType, int va) {
        int absva;
        class_2338 vePos = MoveEntityEvent.getAdjustedBlockPos(e);
        if (footBlock == class_2246.field_10477) {
            e.field_6002.method_22352(vePos, false);
        }
        if (MoveEntityEvent.isNatProgPebbleOrStick()) {
            e.field_6002.method_22352(vePos, true);
        }
        if (footBlock instanceof class_2473 || footBlock == class_2246.field_10479 || footBlock instanceof class_2356 || footBlock instanceof class_2320) {
            e.field_6002.method_22352(vePos, true);
        }
        if ((absva = Math.abs(va)) == 0) {
            e.field_6002.method_8652(vePos, gateBlockType, 3);
            return true;
        }
        if (e.field_6002.method_8652(vePos, wallType, 3)) {
            return true;
        }
        Utility.debugMsg(1, e.method_24515(), "Building Wall Fail: SetBlockAndUpdate Time End = " + e.field_6002.method_8510());
        return false;
    }

    static {
        isRoadPiece = false;
    }
}

