/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.config;

import com.mactso.regrowth.config.MyConfig;
import com.mactso.regrowth.utility.Utility;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_6880;
import net.minecraft.class_6885;

public class WallBiomeDataManager {
    private static Hashtable<String, WallBiomeDataItem> wallBiomeDataHashtable = new Hashtable();
    private static class_2680 DEFAULT_WALL_BLOCKSTATE = class_2246.field_10625.method_9564();
    private static class_2680 DEFAULT_FENCE_BLOCKSTATE = class_2246.field_10620.method_9564();
    private static WallBiomeDataItem DEFAULT_WALL_ITEM = new WallBiomeDataItem(36, DEFAULT_WALL_BLOCKSTATE, DEFAULT_FENCE_BLOCKSTATE);

    public static WallBiomeDataItem getWallBiomeDataItem(String key) {
        WallBiomeDataItem r;
        String iKey = key;
        if (wallBiomeDataHashtable.isEmpty()) {
            WallBiomeDataManager.wallBiomeDataInit();
        }
        if ((r = wallBiomeDataHashtable.get(iKey)) == null) {
            if (MyConfig.getDebugLevel() > 0) {
                System.out.println("Error! Requested wall has unknown Biome:" + key + ".");
            }
            r = DEFAULT_WALL_ITEM;
        }
        if (MyConfig.getDebugLevel() > 1) {
            System.out.println("222 WallBiomeDataItem: " + iKey + " wall=" + r.getWallBlockState().method_26204().toString() + "fence=" + r.getFenceBlockState().method_26204().toString() + ".");
        }
        return r;
    }

    public static String getWallBiomeDataHashAsString() {
        Object returnString = "";
        for (String key : wallBiomeDataHashtable.keySet()) {
            int wallDiameter = WallBiomeDataManager.wallBiomeDataHashtable.get((Object)key).wallDiameter;
            class_2680 wallTypeBlockState = wallBiomeDataHashtable.get(key).getWallBlockState();
            String tempString = key + "," + wallDiameter + "," + wallTypeBlockState.toString() + ";";
            returnString = (String)returnString + tempString;
        }
        return returnString;
    }

    public static void wallBiomeDataInit() {
        class_6885.class_6888 walls = class_2378.field_11146.method_40260(class_3481.field_15504);
        if (!walls.iterator().hasNext()) {
            System.out.println("failed to get walls all tags ");
            return;
        }
        System.out.println("succeeded in loading walls all tags");
        class_6885.class_6888 fences = class_2378.field_11146.method_40260(class_3481.field_16584);
        if (!fences.iterator().hasNext()) {
            System.out.println("failed to get fences all tags ");
            return;
        }
        System.out.println("succeeded in loading fences all tags");
        wallBiomeDataHashtable.clear();
        String oneLine = "";
        StringTokenizer tokenizedMobString = new StringTokenizer(MyConfig.getWallblockList(), ";");
        while (tokenizedMobString.hasMoreElements()) {
            oneLine = tokenizedMobString.nextToken().trim();
            if (oneLine.isEmpty()) continue;
            try {
                String modAndBiome;
                StringTokenizer st = new StringTokenizer(oneLine, ",");
                String key = modAndBiome = st.nextToken();
                String wallDiameterString = st.nextToken();
                String wallBlockString = st.nextToken();
                String fenceBlockString = st.nextToken();
                int wallDiameter = WallBiomeDataManager.validatedWallDiameter(Integer.parseInt(wallDiameterString.trim()));
                class_2680 wallBlockState = DEFAULT_WALL_BLOCKSTATE;
                for (class_6880 w : walls) {
                    String wbs = Utility.getResourceLocationString((class_2248)w.comp_349());
                    if (!wbs.equals(wallBlockString)) continue;
                    wallBlockState = ((class_2248)w.comp_349()).method_9564();
                    break;
                }
                class_2680 fenceBlockState = DEFAULT_FENCE_BLOCKSTATE;
                for (class_6880 f : fences) {
                    String fbs = Utility.getResourceLocationString((class_2248)f.comp_349());
                    if (!fbs.equals(fenceBlockString)) continue;
                    fenceBlockState = ((class_2248)f.comp_349()).method_9564();
                    break;
                }
                wallBiomeDataHashtable.put(key, new WallBiomeDataItem(wallDiameter, wallBlockState, fenceBlockState));
                if (!modAndBiome.contentEquals("Regrowth:default") && !modAndBiome.contentEquals("Regrowth:minimum") && !modAndBiome.contentEquals("minecraft:icy") && !modAndBiome.contentEquals("minecraft:extreme_hills") && !modAndBiome.contentEquals("minecraft:mesa") && modAndBiome.contentEquals("minecraft:nether")) continue;
            }
            catch (Exception e) {
                System.out.println("Regrowth Debug:  Bad Wall Biome Data Config : " + oneLine);
            }
        }
    }

    private static int validatedWallDiameter(int wallDiameter) {
        if (wallDiameter <= 24) {
            wallDiameter = 24;
        }
        if (wallDiameter > 80) {
            wallDiameter = 80;
        }
        return wallDiameter;
    }

    public static class WallBiomeDataItem {
        int wallDiameter;
        class_2680 wallBlockState;
        class_2680 fenceBlockState;

        public WallBiomeDataItem(int wallRadius, class_2680 wallBlockState, class_2680 fenceBlockState) {
            this.wallDiameter = wallRadius;
            this.wallBlockState = wallBlockState;
            this.fenceBlockState = fenceBlockState;
        }

        public int getWallDiameter() {
            return this.wallDiameter;
        }

        public int getWallRadius() {
            return this.wallDiameter / 2 + 1;
        }

        public class_2680 getWallBlockState() {
            return this.wallBlockState;
        }

        public class_2680 getFenceBlockState() {
            return this.fenceBlockState;
        }
    }
}

