/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.events;

import com.mactso.regrowth.config.MyConfig;
import com.mactso.regrowth.config.RegrowthEntitiesManager;
import com.mactso.regrowth.config.WallBiomeDataManager;
import com.mactso.regrowth.config.WallFoundationDataManager;
import com.mactso.regrowth.utility.Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1429;
import net.minecraft.class_1439;
import net.minecraft.class_1496;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2266;
import net.minecraft.class_2298;
import net.minecraft.class_2299;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2356;
import net.minecraft.class_2372;
import net.minecraft.class_238;
import net.minecraft.class_2383;
import net.minecraft.class_2397;
import net.minecraft.class_2418;
import net.minecraft.class_2420;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2473;
import net.minecraft.class_2488;
import net.minecraft.class_2521;
import net.minecraft.class_2526;
import net.minecraft.class_2527;
import net.minecraft.class_2544;
import net.minecraft.class_2555;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3852;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4208;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5575;
import net.minecraft.class_5815;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7477;

public class MoveEntityEvent {
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2746 OPEN = class_2349.field_11026;
    static final int WALL_CENTER = 0;
    static final int FENCE_CENTER = 0;
    static final int WALL_TYPE_WALL = -1;
    static final int WALL_TYPE_FENCE = -2;
    static final String ACTION_GROW = "grow";
    static final String ACTION_EAT = "eat";
    static final String ACTION_BOTH = "both";
    static final String ACTION_TALL = "tall";
    static final String ACTION_MUSHROOM = "mushroom";
    static final String ACTION_STUMBLE = "stumble";
    static final String ACTION_REFOREST = "reforest";
    static final String ACTION_CORAL = "coral";
    private static Random moveRand = new Random();
    private static final class_2248[] coralPlants = new class_2248[]{class_2246.field_10238, class_2246.field_10376, class_2246.field_10476, class_2246.field_10079, class_2246.field_10427, class_2246.field_10551, class_2246.field_10005, class_2246.field_10053, class_2246.field_10079, class_2246.field_10427, class_2246.field_10551, class_2246.field_10005, class_2246.field_10053};
    private static final class_2248[] coralfans = new class_2248[]{class_2246.field_10186, class_2246.field_10447, class_2246.field_10498, class_2246.field_9976, class_2246.field_10584};
    private final class_2470[] coralfanrotations = new class_2470[]{class_2470.field_11464, class_2470.field_11465, class_2470.field_11463, class_2470.field_11467};
    private static int[] dx = new int[]{1, 0, -1, 0};
    private static int[] dz = new int[]{0, 1, 0, -1};
    private static int CHECKS_PER_SECOND = 10;
    private static int[][] facingArray = new int[][]{{0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}, {1, 0}, {1, 1}};
    private static int lastTorchX = 0;
    private static int lastTorchY = 0;
    private static int lastTorchZ = 0;
    private static class_2680 footBlockState;
    private static class_2680 groundBlockState;
    private static class_2248 footBlock;
    private static class_2248 groundBlock;
    private static class_1959 localBiome;
    private static boolean isRoadPiece;
    private static String biomeCategory;
    static class_2338 adjustedPos;

    private static void doMobRegrowthEvents(class_1309 entity, String key, String regrowthType) {
        Utility.debugMsg(1, "enter Mob Events");
        if (regrowthType.equals(ACTION_STUMBLE)) {
            if (footBlock instanceof class_2527 || footBlock instanceof class_2555) {
                MoveEntityEvent.mobStumbleAction((class_1297)entity, key);
            }
            return;
        }
        if (regrowthType.equals(ACTION_REFOREST)) {
            MoveEntityEvent.mobReforestAction((class_1297)entity, key);
            return;
        }
        if (regrowthType.equals(ACTION_MUSHROOM)) {
            MoveEntityEvent.mobGrowMushroomAction(entity, key);
            return;
        }
        if (regrowthType.equals(ACTION_CORAL)) {
            MoveEntityEvent.mobGrowCoralAction(entity, key);
            return;
        }
        MoveEntityEvent.mobHandleOverCrowding(entity, key);
        if (!MoveEntityEvent.isKindOfGrassBlock(groundBlockState)) {
            return;
        }
        if (regrowthType.equals(ACTION_TALL)) {
            MoveEntityEvent.mobGrowTallAction((class_1297)entity, key);
            return;
        }
        if (regrowthType.equals(ACTION_BOTH)) {
            regrowthType = entity.method_37908().field_9229.method_43058() * 100.0 > 85.0 ? ACTION_GROW : ACTION_EAT;
        }
        if (regrowthType.contentEquals(ACTION_EAT)) {
            MoveEntityEvent.mobEatPlantsAction(entity, key, regrowthType);
            return;
        }
        if (regrowthType.equals(ACTION_GROW)) {
            MoveEntityEvent.mobGrowPlantsAction(entity, key);
            return;
        }
    }

    private static void doVillagerRegrowthEvents(class_1646 ve, String debugKey, String regrowthActions) {
        if (!ve.method_24828()) {
            return;
        }
        if (groundBlockState.method_26204() instanceof class_2527) {
            return;
        }
        if (groundBlockState.method_26204() instanceof class_2555) {
            return;
        }
        if (MyConfig.getDebugLevel() > 0) {
            float veYaw = ve.method_5705(1.0f);
            class_5250 tName = class_2561.method_43470((String)("Reg-" + ve.method_23317() + "," + ve.method_23321() + ": " + veYaw));
            ve.method_5665((class_2561)tName);
        } else if (ve.method_5797() != null && ve.method_5797().toString().contains("Reg-")) {
            ve.method_5665(null);
        }
        if (MoveEntityEvent.vImproveFarm(ve, regrowthActions)) {
            Utility.debugMsg(1, (class_1309)ve, debugKey + " farm improved.");
        }
        if (regrowthActions.contains("h")) {
            MoveEntityEvent.vClericalHealing(ve);
            MoveEntityEvent.vToolMasterHealing(ve);
        }
        MoveEntityEvent.vBeeKeeperFlowers(ve);
        if (regrowthActions.contains("v")) {
            MoveEntityEvent.vImproveLeaves(ve, debugKey);
        }
        if (regrowthActions.contains("c") && (footBlock instanceof class_2526 || footBlock instanceof class_2320 || footBlock.method_9539().equals("block.byg.short_grass"))) {
            ve.method_37908().method_22352(ve.method_24515(), false);
            Utility.debugMsg(1, (class_1309)ve, debugKey + " grass cut.");
        }
        if (regrowthActions.contains("r")) {
            Utility.debugMsg(1, (class_1309)ve, debugKey + " try road improve.");
            MoveEntityEvent.vImproveRoads(ve, debugKey);
        }
        if (regrowthActions.contains("w")) {
            Utility.debugMsg(1, (class_1309)ve, " try town wall build.");
            MoveEntityEvent.vImproveWalls(ve, debugKey, regrowthActions);
        }
        if (regrowthActions.contains("p")) {
            Utility.debugMsg(1, (class_1309)ve, " try personal fence build.");
            MoveEntityEvent.vImproveFences(ve, debugKey, regrowthActions);
        }
        if (regrowthActions.contains("t") && footBlock != class_2246.field_10336 && MoveEntityEvent.vImproveLighting(ve)) {
            Utility.debugMsg(1, (class_1309)ve, debugKey + "-" + footBlock + ", " + groundBlock + " pitch: " + ve.method_36455() + " lighting improved.");
        }
        Utility.debugMsg(1, "exit Village Events");
    }

    private static int getAbsVX(class_1297 e, class_2338 gVMPPos) {
        int absvx = Math.abs(MoveEntityEvent.getVX(e, gVMPPos));
        return absvx;
    }

    private static int getAbsVZ(class_1297 e, class_2338 gVMPPos) {
        return Math.abs(MoveEntityEvent.getVZ(e, gVMPPos));
    }

    private static class_2338 getAdjustedBlockPos(class_1297 e) {
        if (e.method_23318() == (double)e.method_24515().method_10264()) {
            return e.method_24515();
        }
        return e.method_24515().method_10084();
    }

    private static class_2680 getAdjustedFootBlockState(class_1297 e) {
        if (e.method_23318() == (double)e.method_24515().method_10264()) {
            return e.method_37908().method_8320(e.method_24515());
        }
        return e.method_37908().method_8320(e.method_24515().method_10084());
    }

    private static class_2680 getAdjustedGroundBlockState(class_1297 e) {
        return e.method_37908().method_8320(e.method_24515().method_10087(MoveEntityEvent.getAdjustedY(e)));
    }

    private static int getAdjustedY(class_1297 e) {
        if (e.method_23318() == (double)e.method_24515().method_10264()) {
            return 1;
        }
        return 0;
    }

    private static int getVX(class_1297 e, class_2338 gVMPPos) {
        return (int)(e.method_23317() - (double)gVMPPos.method_10263());
    }

    private static int getVZ(class_1297 e, class_2338 gVMPPos) {
        return (int)(e.method_23321() - (double)gVMPPos.method_10260());
    }

    public static void handleEntityMoveEvents(class_1309 le) {
        class_1646 ve;
        class_1937 level = le.method_37908();
        if (level.field_9236) {
            return;
        }
        Utility.debugMsg(1, "enter serverside Handle Entity Move Events");
        class_3218 sLevel = (class_3218)le.method_37908();
        if (le instanceof class_1657) {
            return;
        }
        if ((long)(le.method_5628() % 2) == le.method_37908().method_8510() % 2L) {
            return;
        }
        if (le.method_24515() == null) {
            return;
        }
        int x = 3;
        String rlString = Utility.getResourceLocationString((class_1297)le).toString();
        RegrowthEntitiesManager.RegrowthMobItem currentRegrowthMobItem = RegrowthEntitiesManager.getRegrowthMobInfo(rlString);
        if (currentRegrowthMobItem == null) {
            return;
        }
        adjustedPos = MoveEntityEvent.getAdjustedBlockPos((class_1297)le);
        footBlockState = MoveEntityEvent.getAdjustedFootBlockState((class_1297)le);
        footBlock = footBlockState.method_26204();
        if (footBlock instanceof class_5815) {
            return;
        }
        groundBlockState = MoveEntityEvent.getAdjustedGroundBlockState((class_1297)le);
        groundBlock = groundBlockState.method_26204();
        if (groundBlockState.method_26215() && !(le instanceof class_1420)) {
            return;
        }
        biomeCategory = Utility.getMyBC((class_6880<class_1959>)le.method_37908().method_23753(le.method_24515()));
        localBiome = (class_1959)le.method_37908().method_23753(le.method_24515()).comp_349();
        String regrowthActions = currentRegrowthMobItem.getRegrowthActions();
        if (MoveEntityEvent.isImpossibleRegrowthEvent(regrowthActions)) {
            return;
        }
        double regrowthEventOdds = 1.0 / (currentRegrowthMobItem.getRegrowthEventSeconds() * (double)CHECKS_PER_SECOND);
        if (MoveEntityEvent.isHorseTypeEatingNow((class_1297)le)) {
            regrowthEventOdds *= 20.0;
        }
        double randomD100Roll = le.method_37908().field_9229.method_43058();
        boolean debugvalue = false;
        long chunkAge = le.method_37908().method_8500(le.method_24515()).method_12033();
        if (chunkAge < 480000L && le instanceof class_1646 && (ve = (class_1646)le).method_37908().method_8510() % 12L == 0L) {
            if (regrowthActions.contains("r")) {
                MoveEntityEvent.vImproveRoads(ve, "preRoad");
            }
            if (regrowthActions.contains("w")) {
                MoveEntityEvent.vImproveVillageWall(ve, regrowthActions);
            }
        }
        if (randomD100Roll <= regrowthEventOdds + (double)debugvalue) {
            if (le instanceof class_1646) {
                ve = (class_1646)le;
                MoveEntityEvent.improvePowderedSnow((class_1297)le);
                if (ve.method_24828() && !(footBlock instanceof class_2244)) {
                    MoveEntityEvent.doVillagerRegrowthEvents(ve, rlString, regrowthActions);
                }
            } else {
                MoveEntityEvent.doMobRegrowthEvents(le, rlString, regrowthActions);
            }
        }
        Utility.debugMsg(1, "fall out of Handle Entity tick Events");
    }

    private static class_2680 helperBiomeRoadBlockType(String localBiome) {
        class_2680 gateBlockType = class_2246.field_10194.method_9564();
        if (biomeCategory.equals(Utility.DESERT)) {
            gateBlockType = class_2246.field_10218.method_9564();
        }
        return gateBlockType;
    }

    private static void helperChildAgeEntity(class_1297 ent) {
        class_1296 aEnt;
        if (ent instanceof class_1296 && (aEnt = (class_1296)ent).method_6109()) {
            aEnt.method_5614(aEnt.method_5618() + 30);
        }
    }

    public static int helperCountBlocksBB(class_2248 searchBlock, int maxCount, class_3218 serverLevel, class_2338 bPos, int boxSize) {
        return MoveEntityEvent.helperCountBlocksBB(searchBlock, maxCount, serverLevel, bPos, boxSize, boxSize);
    }

    public static int helperCountBlocksBB(class_2248 searchBlock, int maxCount, class_3218 serverLevel, class_2338 bPos, int boxSize, int ySize) {
        int count = 0;
        int minX = bPos.method_10263() - boxSize;
        int maxX = bPos.method_10263() + boxSize;
        int minZ = bPos.method_10260() - boxSize;
        int maxZ = bPos.method_10260() + boxSize;
        int minY = bPos.method_10264() - ySize;
        int maxY = bPos.method_10264() + ySize;
        class_2338.class_2339 mPos = new class_2338.class_2339();
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dz = minZ; dz <= maxZ; ++dz) {
                for (int dy = minY; dy <= maxY; ++dy) {
                    mPos.method_10103(dx, dy, dz);
                    if (serverLevel.method_8320((class_2338)mPos).method_26204() != searchBlock || ++count < maxCount) continue;
                    return count;
                }
            }
        }
        Utility.debugMsg(2, bPos, Utility.getResourceLocationString(searchBlock) + " Sparse count:" + count + " countBlockBB ");
        return count;
    }

    public static int helperCountBlocksBB(Class<? extends class_2248> searchBlock, int maxCount, class_3218 serverLevel, class_2338 bPos, int boxSize, int ySize) {
        int count = 0;
        int minX = bPos.method_10263() - boxSize;
        int maxX = bPos.method_10263() + boxSize;
        int minZ = bPos.method_10260() - boxSize;
        int maxZ = bPos.method_10260() + boxSize;
        int minY = bPos.method_10264() - ySize;
        int maxY = bPos.method_10264() + ySize;
        class_2338.class_2339 mPos = new class_2338.class_2339();
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dz = minZ; dz <= maxZ; ++dz) {
                for (int dy = minY; dy <= maxY; ++dy) {
                    mPos.method_10103(dx, dy, dz);
                    if (!searchBlock.isInstance(serverLevel.method_8320((class_2338)mPos).method_26204()) || ++count < maxCount) continue;
                    return count;
                }
            }
        }
        Utility.debugMsg(2, bPos, searchBlock.getSimpleName() + " Sparse count:" + count + " countBlockBB ");
        return count;
    }

    public static int helperCountBlocksOrthogonalBB(class_2248 searchBlock, int maxCount, class_1937 w, class_2338 bPos, int boundY) {
        return MoveEntityEvent.helperCountBlocksOrthogonalBB(searchBlock, maxCount, w, bPos, 0 - boundY, 0 + boundY);
    }

    public static int helperCountBlocksOrthogonalBB(class_2248 searchBlock, int maxCount, class_1937 w, class_2338 bPos, int lowerBoundY, int upperBoundY) {
        int count = 0;
        for (int j = lowerBoundY; j <= upperBoundY; ++j) {
            if (w.method_8320(bPos.method_10086(j).method_10078()).method_26204() == searchBlock) {
                ++count;
            }
            if (w.method_8320(bPos.method_10086(j).method_10067()).method_26204() == searchBlock) {
                ++count;
            }
            if (w.method_8320(bPos.method_10086(j).method_10095()).method_26204() == searchBlock) {
                ++count;
            }
            if (w.method_8320(bPos.method_10086(j).method_10072()).method_26204() == searchBlock) {
                ++count;
            }
            if (count < maxCount) continue;
            return count;
        }
        return count;
    }

    private static int helperCountCoral(class_1297 e) {
        int c = 0;
        for (int ud = -1; ud <= 0; ++ud) {
            for (int ew = -1; ew <= 1; ++ew) {
                for (int ns = -1; ns <= 1; ++ns) {
                    if (!(e.method_37908().method_8320(e.method_24515().method_10087(1).method_10089(ew).method_10076(ns)).method_26204() instanceof class_2298)) continue;
                    ++c;
                }
            }
        }
        return c;
    }

    private static String helperGetRegistryNameAsString(class_1297 entity) {
        return Utility.getResourceLocationString(entity);
    }

    private static void helperJumpAway(class_1297 e) {
        class_2248 postActionFootBlock = MoveEntityEvent.getAdjustedFootBlockState(e).method_26204();
        if (postActionFootBlock == class_2246.field_10194) {
            e.method_18800(0.0, 0.33, 0.0);
            return;
        }
        if (postActionFootBlock instanceof class_2544 || postActionFootBlock instanceof class_2354) {
            float veYaw = e.method_5705(1.0f) / 45.0f;
            int facingNdx = Math.round(veYaw);
            if (facingNdx < 0) {
                facingNdx = Math.abs(facingNdx);
            }
            double dx = (double)facingArray[facingNdx %= 8][0] / 2.0;
            double dz = (double)facingArray[facingNdx][1] / 2.0;
            e.method_18800(dx, 0.55, dz);
        }
    }

    private static long helperLongRandomSeed(class_2338 ePos) {
        return (long)Math.abs(ePos.method_10263() * 31) + (long)Math.abs(ePos.method_10260() * 11) + (long)Math.abs(ePos.method_10264() * 7);
    }

    private static boolean helperPlaceOneWallPiece(class_1309 le, int wallRadius, int wallTorchSpacing, class_2680 wallType, class_2338 gVMPPos) {
        class_2680 gateBlockState = (class_2680)((class_2680)class_2246.field_10188.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11034)).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(true));
        class_2350 d = null;
        if (MoveEntityEvent.getAbsVX((class_1297)le, gVMPPos) == wallRadius && MoveEntityEvent.getAbsVZ((class_1297)le, gVMPPos) <= wallRadius) {
            d = MoveEntityEvent.getVX((class_1297)le, gVMPPos) > 0 ? class_2350.field_11034 : class_2350.field_11039;
            return MoveEntityEvent.helperPlaceWallPiece(le, wallType, (class_2680)gateBlockState.method_11657((class_2769)FACING, (Comparable)d), MoveEntityEvent.getVZ((class_1297)le, gVMPPos));
        }
        if (MoveEntityEvent.getAbsVZ((class_1297)le, gVMPPos) == wallRadius && MoveEntityEvent.getAbsVX((class_1297)le, gVMPPos) <= wallRadius) {
            d = MoveEntityEvent.getVZ((class_1297)le, gVMPPos) > 0 ? class_2350.field_11043 : class_2350.field_11035;
            return MoveEntityEvent.helperPlaceWallPiece(le, wallType, (class_2680)gateBlockState.method_11657((class_2769)FACING, (Comparable)d), MoveEntityEvent.getVX((class_1297)le, gVMPPos));
        }
        return false;
    }

    private static boolean helperPlaceWallPiece(class_1309 le, class_2680 wallType, class_2680 gateBlockType, int va) {
        int absva;
        class_2338 vePos = MoveEntityEvent.getAdjustedBlockPos((class_1297)le);
        if (footBlock instanceof class_2488) {
            le.method_37908().method_22352(vePos, false);
        }
        if (MoveEntityEvent.isNatProgPebbleOrStick((class_3218)le.method_37908())) {
            le.method_37908().method_22352(vePos, true);
        }
        if (footBlock instanceof class_2473 || footBlock instanceof class_2526 || footBlock instanceof class_2356 || footBlock instanceof class_2320) {
            le.method_37908().method_22352(vePos, true);
        }
        if ((absva = Math.abs(va)) == 0) {
            le.method_37908().method_8652(vePos, gateBlockType, 3);
            return true;
        }
        int x = 3;
        if (le.method_37908().method_8652(vePos, wallType, 3)) {
            return true;
        }
        Utility.debugMsg(1, le, "Building Wall Fail: SetBlockAndUpdate Time End = " + le.method_37908().method_8510());
        return false;
    }

    private static class_2680 helperSaplingState(class_3218 serverLevel, class_2338 pos, class_1959 localBiome, class_2680 sapling) {
        sapling = class_2246.field_10394.method_9564();
        class_5321 k = (class_5321)serverLevel.method_22385().method_22393(pos).method_40230().get();
        String biomeName = k.method_29177().method_12832();
        if (biomeName.contains("birch")) {
            sapling = class_2246.field_10575.method_9564();
        }
        if (biomeName.contains("taiga")) {
            sapling = class_2246.field_10217.method_9564();
        }
        if (biomeName.contains("jungle")) {
            sapling = class_2246.field_10276.method_9564();
        }
        if (biomeName.contains("savanna")) {
            sapling = class_2246.field_10385.method_9564();
        }
        if (biomeName.contains("desert")) {
            sapling = class_2246.field_10385.method_9564();
        }
        return sapling;
    }

    private static void improvePowderedSnow(class_1297 entity) {
        class_1937 sLevel = entity.method_37908();
        if (entity.field_27857) {
            int hp = 0;
            if (sLevel.method_8320(entity.method_24515().method_10086(2)).method_26204() == class_2246.field_27879) {
                entity.method_37908().method_22352(entity.method_24515().method_10086(2), false);
                hp = 2;
            }
            if (sLevel.method_8320(entity.method_24515().method_10084()).method_26204() == class_2246.field_27879) {
                entity.method_37908().method_22352(entity.method_24515().method_10084(), false);
                hp += 2;
            }
            if (sLevel.method_8320(entity.method_24515()).method_26204() == class_2246.field_27879) {
                class_2680 SnowLayer = (class_2680)class_2246.field_10477.method_9564().method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(2 + hp));
                entity.method_37908().method_8501(entity.method_24515(), SnowLayer);
            }
        }
    }

    private static boolean isBlockGrassOrDirt(class_2680 tempBlockState) {
        return MoveEntityEvent.isKindOfGrassBlock(tempBlockState) || tempBlockState.method_26204() == class_2246.field_10566;
    }

    private static boolean isBlockGrassPathOrDirt(class_2248 tempBlock) {
        return tempBlock == class_2246.field_10194 || tempBlock == class_2246.field_10566;
    }

    private static boolean isFootBlockOkayToBuildIn(class_3218 serverLevel) {
        if (footBlockState.method_26215() || MoveEntityEvent.isGrassOrFlower(footBlockState)) {
            return true;
        }
        if (footBlockState.method_26204() instanceof class_2488) {
            return true;
        }
        return MoveEntityEvent.isNatProgPebbleOrStick(serverLevel);
    }

    private static boolean isGoodMushroomTemperature(class_1297 entity) {
        class_2338 ePos = MoveEntityEvent.getAdjustedBlockPos(entity);
        float biomeTemp = ((class_1959)entity.method_37908().method_23753(ePos).comp_349()).method_8712();
        Utility.debugMsg(1, ePos, "Mushroom Biome temp: " + biomeTemp + ".");
        if ((double)biomeTemp < MyConfig.getMushroomMinTemp()) {
            return false;
        }
        return !((double)biomeTemp > MyConfig.getMushroomMaxTemp());
    }

    private static boolean isGrassOrFlower(class_2680 footBlockState) {
        class_2248 footBlock;
        block9: {
            footBlock = footBlockState.method_26204();
            if (footBlock instanceof class_2521) {
                return true;
            }
            if (footBlock instanceof class_2356) {
                return true;
            }
            if (footBlock instanceof class_2320) {
                return true;
            }
            try {
                if (footBlockState.method_26164(class_3481.field_20339)) {
                    return true;
                }
                if (footBlockState.method_26164(class_3481.field_20338)) {
                    return true;
                }
            }
            catch (Exception e) {
                if (MyConfig.getDebugLevel() <= 0) break block9;
                System.out.println("Tag Exception 1009-1014:" + footBlock.method_9539() + ".");
            }
        }
        if (footBlock.method_9539().equals("block.byg.short_grass")) {
            return true;
        }
        if (MyConfig.getDebugLevel() > 0) {
            System.out.println("Not grass or Flower:" + footBlock.method_9539() + ".");
        }
        return false;
    }

    private static boolean isHorseTypeEatingNow(class_1297 entity) {
        class_1496 h;
        return entity instanceof class_1496 && (h = (class_1496)entity).method_6724();
    }

    private static boolean isImpossibleRegrowthEvent(String regrowthType) {
        if (regrowthType.equals(ACTION_EAT) && footBlockState.method_26215()) {
            return true;
        }
        if (regrowthType.equals(ACTION_GROW) && footBlockState.method_26204() instanceof class_2526) {
            return true;
        }
        if (regrowthType.equals(ACTION_GROW) && footBlockState.method_26204() instanceof class_2356) {
            return true;
        }
        return regrowthType.equals(ACTION_TALL) && !(footBlockState.method_26204() instanceof class_2526);
    }

    private static boolean isKindOfGrassBlock(class_2680 groundBlockState) {
        if (groundBlockState.method_26204() instanceof class_2372) {
            return true;
        }
        return groundBlockState.method_26204().method_9539().equals("block.byg.meadow_grass_block");
    }

    private static boolean isNatProgPebbleOrStick(class_3218 serverLevel) {
        String rl = Utility.getResourceLocationString(footBlock);
        if (rl.contains("natprog") && rl.contains("pebble")) {
            return true;
        }
        if (rl.contains("natprog") && rl.contains("twigs")) {
            return true;
        }
        return rl.contains("minecraft") && rl.contains("button");
    }

    private static boolean isNearbyPoi(class_1646 ve, class_1959 localBiome, class_2338 vePos, int poiDistance) {
        Collection result = ((class_3218)ve.method_37908()).method_19494().method_22383(t -> true, ve.method_24515(), poiDistance, class_4153.class_4155.field_18489).collect(Collectors.toCollection(ArrayList::new));
        if (!result.isEmpty()) {
            for (class_4156 P : result) {
                int disX = Math.abs(ve.method_24515().method_10263() - P.method_19141().method_10263());
                int disZ = Math.abs(ve.method_24515().method_10260() - P.method_19141().method_10260());
                if (disX >= poiDistance || disZ >= poiDistance) continue;
                Utility.debugMsg(1, (class_1309)ve, "Point of Interest too Close: " + P.method_19142().toString() + ".");
                return true;
            }
        }
        return false;
    }

    private static boolean isNearWater(class_1937 level, class_2338 pos) {
        class_238 box = new class_238(pos.method_10089(4).method_10076(4), pos.method_10088(4).method_10077(4));
        return level.method_22345(box);
    }

    private static boolean isOkayToBuildWallHere(class_1646 ve) {
        boolean okayToBuildWalls = true;
        if (!MoveEntityEvent.isOnGround((class_1297)ve)) {
            okayToBuildWalls = false;
        }
        if (!MoveEntityEvent.isFootBlockOkayToBuildIn((class_3218)ve.method_37908())) {
            okayToBuildWalls = false;
        }
        if (!MoveEntityEvent.isValidGroundBlockToBuildWallOn((class_1309)ve)) {
            okayToBuildWalls = false;
        }
        return okayToBuildWalls;
    }

    private static boolean isOnGround(class_1297 e) {
        return e.method_24828();
    }

    private static boolean isOnWallRadius(class_1297 e, int wallRadius, class_2338 gVMPPos) {
        if (MoveEntityEvent.getAbsVX(e, gVMPPos) == wallRadius && MoveEntityEvent.getAbsVZ(e, gVMPPos) <= wallRadius) {
            return true;
        }
        return MoveEntityEvent.getAbsVZ(e, gVMPPos) == wallRadius && MoveEntityEvent.getAbsVX(e, gVMPPos) <= wallRadius;
    }

    private static boolean isOutsideMeetingPlaceWall(class_1646 ve, Optional<class_4208> vMeetingPlace, class_2338 meetingPlacePos, class_1959 localBiome) {
        class_2338 vePos = MoveEntityEvent.getAdjustedBlockPos((class_1297)ve);
        Object key = "minecraft:" + localBiome.toString();
        int wallDiameter = 64;
        WallBiomeDataManager.WallBiomeDataItem currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem((String)(key = ((String)key).toLowerCase()));
        if (currentWallBiomeDataItem != null) {
            wallDiameter = currentWallBiomeDataItem.getWallDiameter();
        }
        wallDiameter = wallDiameter / 2 - 1;
        int absVMpX = Math.abs(vePos.method_10263() - meetingPlacePos.method_10263());
        int absVMpZ = Math.abs(vePos.method_10260() - meetingPlacePos.method_10260());
        if (absVMpX > wallDiameter + 1) {
            return true;
        }
        return absVMpZ > wallDiameter + 1;
    }

    private static boolean isValidGroundBlockToBuildWallOn(class_1309 le) {
        if (le.method_37908().method_8314(class_1944.field_9284, le.method_24515()) < 13) {
            return false;
        }
        if (groundBlock instanceof class_2488) {
            return false;
        }
        if (groundBlock instanceof class_2527) {
            return false;
        }
        if (le.method_37908().method_8320(le.method_24515().method_10084()).method_26204() instanceof class_2544) {
            return false;
        }
        if (le.method_37908().method_8320(le.method_24515().method_10074()).method_26204() instanceof class_2544) {
            return false;
        }
        if (le.method_37908().method_8320(le.method_24515().method_10087(1)).method_26204() instanceof class_2544) {
            return false;
        }
        if (le.method_37908().method_8320(le.method_24515().method_10087(2)).method_26204() instanceof class_2527) {
            return false;
        }
        if (le.method_37908().method_8320(le.method_24515().method_10084()).method_26204() instanceof class_2527) {
            return false;
        }
        if (le.method_37908().method_8320(le.method_24515().method_10074()).method_26204() instanceof class_2527) {
            return false;
        }
        if (le.method_37908().method_8320(le.method_24515().method_10087(1)).method_26204() instanceof class_2527) {
            return false;
        }
        if (le.method_37908().method_8320(le.method_24515().method_10087(2)).method_26204() instanceof class_2527) {
            return false;
        }
        groundBlock = groundBlockState.method_26204();
        Utility.debugMsg(1, le, "Build Wall : gb" + groundBlock.toString() + ", fb:" + footBlock.toString());
        int debug = 3;
        WallFoundationDataManager.wallFoundationItem currentWallFoundationItem = WallFoundationDataManager.getWallFoundationInfo(Utility.getResourceLocationString(groundBlock));
        return currentWallFoundationItem != null;
    }

    private static boolean isValidGroundBlockToPlaceTorchOn(class_1646 ve) {
        String key = Utility.getResourceLocationString(groundBlockState);
        WallFoundationDataManager.wallFoundationItem currentWallFoundationItem = WallFoundationDataManager.getWallFoundationInfo(key);
        return currentWallFoundationItem != null;
    }

    private static boolean isValidTorchLocation(int wallRadius, int wallTorchSpacing, int absvx, int absvz, class_2248 wallFenceBlock) {
        boolean hasAWallUnderIt = false;
        if (wallFenceBlock instanceof class_2544) {
            hasAWallUnderIt = true;
        }
        if (wallFenceBlock instanceof class_2354) {
            hasAWallUnderIt = true;
        }
        if (!hasAWallUnderIt) {
            return false;
        }
        if (absvx == wallRadius && absvz % wallTorchSpacing == 1) {
            return true;
        }
        if (absvx % wallTorchSpacing == 1 && absvz == wallRadius) {
            return true;
        }
        return absvx == wallRadius && absvz == wallRadius;
    }

    private static boolean mobEatGrassOrFlower(class_1297 entity, String regrowthType) {
        class_2338 ePos = MoveEntityEvent.getAdjustedBlockPos(entity);
        if (!MoveEntityEvent.isGrassOrFlower(footBlockState)) {
            return false;
        }
        if (MoveEntityEvent.isKindOfGrassBlock(groundBlockState)) {
            MoveEntityEvent.mobTrodGrassBlock(entity);
        }
        entity.method_37908().method_22352(ePos, false);
        class_1309 le = (class_1309)entity;
        MoveEntityEvent.helperChildAgeEntity(entity);
        if (le.method_6063() > le.method_6032() && MyConfig.getEatingHeals()) {
            class_1293 ei = new class_1293(class_1294.field_5915, 1, 0, false, true);
            le.method_6092(ei);
        }
        return true;
    }

    private static boolean mobEatPlantsAction(class_1309 entity, String key, String regrowthType) {
        if (MoveEntityEvent.mobEatGrassOrFlower((class_1297)entity, regrowthType)) {
            Utility.debugMsg(2, MoveEntityEvent.getAdjustedBlockPos((class_1297)entity), key + " ate plants.");
            return true;
        }
        return false;
    }

    private static boolean mobGrowCoralAction(class_1309 le, String key) {
        class_1937 level = le.method_37908();
        int sealevel = level.method_8615();
        class_5819 rand = level.method_8409();
        moveRand.setSeed(le.method_31478() * 1151 + le.method_31477() * 51 + le.method_31479() * 31);
        double docoralplant = moveRand.nextDouble();
        docoralplant = moveRand.nextDouble();
        double docoralfan = moveRand.nextDouble();
        int coralfanDirection = moveRand.nextInt(4);
        int minCoraldepth = sealevel - 4 + moveRand.nextInt(2);
        int maxCoraldepth = sealevel - 16;
        if (le.method_31478() > minCoraldepth) {
            return false;
        }
        if (le.method_31478() < maxCoraldepth) {
            return false;
        }
        class_2338 pos = le.method_24515();
        if (level.method_8320(pos.method_10087(0)).method_26204() != class_2246.field_10382) {
            return false;
        }
        if (level.method_8320(pos.method_10087(1)).method_26204() != class_2246.field_10382) {
            return false;
        }
        class_2248 b = level.method_8320(pos.method_10087(2)).method_26204();
        if (level.method_8320(pos.method_10087(2)).method_26204() != class_2246.field_10382 && b != class_2246.field_10340 && b != class_2246.field_10033) {
            Utility.debugMsg(1, pos, "Block: " + level.method_8320(pos.method_10087(2)).toString());
        }
        boolean fabpatch = false;
        if (level.method_8320(pos.method_10087(2)).method_26204() instanceof class_2298) {
            fabpatch = true;
        }
        if (level.method_8320(pos.method_10087(2)).method_26204() instanceof class_2298) {
            fabpatch = true;
        }
        if (fabpatch) {
            if (docoralfan < 0.3) {
                class_2350 d = class_2350.method_10139((int)coralfanDirection);
                class_2338 fanPos = le.method_24515().method_10087(2).method_10093(d);
                if (level.method_8320(fanPos).method_26204() == class_2246.field_10382) {
                    level.method_8501(fanPos, (class_2680)coralfans[rand.method_43048(coralfans.length)].method_9564().method_11657((class_2769)class_2299.field_9933, (Comparable)d));
                }
            }
            int count = MoveEntityEvent.helperCountCoral((class_1297)le);
            Utility.debugMsg(2, le, "CORAL count = :" + count + ", " + Utility.getResourceLocationString((class_1297)le) + " .");
            if (count > 5) {
                return false;
            }
            class_2680 theCoralBlock = level.method_8320(pos.method_10087(2));
            if (count < 6 && le.method_31478() == minCoraldepth) {
                if (docoralplant < 0.3) {
                    return false;
                }
                Utility.debugMsg(2, pos, "CORAL Plant grows over Coral Block:" + Utility.getResourceLocationString((class_1297)le) + " .");
                level.method_8501(pos.method_10087(1), coralPlants[rand.method_43048(coralPlants.length)].method_9564());
                level.method_8396(null, pos, class_3417.field_14756, class_3419.field_15256, 0.9f, 1.4f);
                return true;
            }
            if (le.method_31478() < minCoraldepth) {
                int ew = rand.method_43048(3) - 1;
                int ns = rand.method_43048(3) - 1;
                if (level.method_8320(pos.method_10087(1).method_10089(ew).method_10076(ns)).method_26204() != class_2246.field_10382) {
                    return false;
                }
                Utility.debugMsg(2, pos, "CORAL Block grows over Coral Block:" + Utility.getResourceLocationString((class_1297)le) + " .");
                level.method_8501(pos.method_10087(1).method_10089(ew).method_10076(ns), theCoralBlock);
                level.method_8396(null, pos, class_3417.field_14817, class_3419.field_15256, 0.9f, 1.4f);
                Utility.debugMsg(2, pos, "CORAL:" + Utility.getResourceLocationString((class_1297)le) + " new block set at near " + pos.method_10087(1) + " .");
            }
        }
        return true;
    }

    private static void mobGrowMushroomAction(class_1309 le, String key) {
        int huge;
        class_2338 ePos;
        class_3218 sLevel = (class_3218)le.method_37908();
        if (sLevel.method_8320(ePos = le.method_24515()).method_26204() instanceof class_2420) {
            return;
        }
        if (sLevel.method_8311(ePos)) {
            return;
        }
        if (!MoveEntityEvent.isGoodMushroomTemperature((class_1297)le)) {
            return;
        }
        Random mushRand = new Random(MoveEntityEvent.helperLongRandomSeed(le.method_24515()));
        double fertilityDouble = mushRand.nextDouble();
        fertilityDouble = mushRand.nextDouble();
        if (fertilityDouble < 0.75) {
            Utility.debugMsg(1, ePos, key + " Mushroom fertility (" + fertilityDouble + ") non-growing spot.");
            return;
        }
        int smallMushroomCount = MoveEntityEvent.helperCountBlocksBB(class_2420.class, 4, sLevel, ePos, 4, 1);
        if (smallMushroomCount > 3) {
            Utility.debugMsg(1, ePos, key + " smallMushroomCount (" + smallMushroomCount + ") mushroom too crowded.");
            return;
        }
        int myceliumCount = MoveEntityEvent.helperCountBlocksBB(class_2418.class, 4, sLevel, ePos, 4, 1);
        if (myceliumCount > 2) {
            Utility.debugMsg(1, ePos, key + " myceliumCount (" + myceliumCount + ") mycelium too crowded.");
            return;
        }
        if (groundBlock == class_2246.field_10240) {
            sLevel.method_8501(ePos, class_2246.field_10559.method_9564());
            return;
        }
        if (groundBlock == class_2246.field_10580) {
            sLevel.method_8501(ePos, class_2246.field_10251.method_9564());
            return;
        }
        int hugeMushroomCount = MoveEntityEvent.helperCountBlocksBB(class_2420.class, 1, sLevel, ePos, 1, 1);
        if (hugeMushroomCount <= 0 && (huge = MoveEntityEvent.helperCountBlocksBB(class_2420.class, 1, sLevel, ePos, MyConfig.getMushroomDensity(), 1)) > 0) {
            Utility.debugMsg(1, ePos, key + " huge (" + huge + ") mushroom too crowded.");
            return;
        }
        boolean growMushroom = false;
        if (class_3481.field_25806 == null) {
            Utility.warn("BlockTags.BASE_STONE_OVERWORLD missing.");
            if (groundBlock == class_2246.field_10340 || groundBlock == class_2246.field_10508 || groundBlock == class_2246.field_10115 || groundBlock == class_2246.field_10474) {
                growMushroom = true;
            }
        } else {
            if (!groundBlockState.method_26164(class_3481.field_25806)) {
                return;
            }
            growMushroom = true;
        }
        if (sLevel.method_18458((double)ePos.method_10263(), (double)ePos.method_10264(), (double)ePos.method_10260(), 12.0)) {
            growMushroom = false;
        }
        if (growMushroom) {
            double vx = le.method_19538().method_10216() - ((double)ePos.method_10263() + 0.5);
            double vz = le.method_19538().method_10215() - ((double)ePos.method_10260() + 0.5);
            class_243 vM = new class_243(vx, 0.0, vz).method_1029().method_1021(1.0).method_1031(0.0, 0.5, 0.0);
            le.method_18799(le.method_18798().method_1019(vM));
            if (fertilityDouble > 0.9) {
                sLevel.method_8501(ePos.method_10074(), class_2246.field_10402.method_9564());
            }
            class_2248 theBlock = null;
            class_2248 theCapBlock = null;
            if (sLevel.field_9229.method_43058() * 100.0 > 75.0) {
                theBlock = class_2246.field_10559;
                theCapBlock = class_2246.field_10240;
            } else {
                theBlock = class_2246.field_10251;
                theCapBlock = class_2246.field_10580;
            }
            if (fertilityDouble > 0.9) {
                sLevel.method_8501(ePos.method_10074(), class_2246.field_10402.method_9564());
            }
            sLevel.method_8501(ePos, theBlock.method_9564());
            class_2420 mb = (class_2420)theBlock;
            if (mushRand.nextDouble() < 0.03) {
                MoveEntityEvent.mobGrowSmallMushroom(sLevel, ePos, theCapBlock);
            } else {
                try {
                    mb.method_10349(sLevel, ePos, theBlock.method_9564(), sLevel.field_9229);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (theBlock == class_2246.field_10559) {
                    for (int y = 9; y > 3; --y) {
                        class_2248 b = sLevel.method_8320(ePos.method_10086(y)).method_26204();
                        if (b != class_2246.field_10556) continue;
                        sLevel.method_8501(ePos.method_10086(y), class_2246.field_22122.method_9564());
                        break;
                    }
                }
            }
            Utility.debugMsg(1, le, key + " grow mushroom.");
        }
    }

    private static boolean mobGrowPlantsAction(class_1309 le, String key) {
        if (footBlockState.method_26215()) {
            if (!(groundBlock instanceof class_2256)) {
                return false;
            }
            class_2338 bpos = le.method_24515();
            if (bpos == null) {
                Utility.debugMsg(1, "ERROR:" + key + "grow plant null position.");
                return false;
            }
            class_2256 ib = (class_2256)groundBlock;
            Utility.debugMsg(1, le, key + " growable plant found.");
            try {
                class_3218 serverLevel = (class_3218)le.method_37908();
                class_2680 bs = le.method_37908().method_8320(bpos);
                ib.method_9652(serverLevel, serverLevel.method_8409(), bpos, bs);
            }
            catch (Exception e) {
                Utility.debugMsg(1, le, key + " caught grow attempt exception.");
            }
        }
        return true;
    }

    private static void mobGrowSmallMushroom(class_3218 serverLevel, class_2338 ePos, class_2248 theCapBlock) {
        if (serverLevel.method_8409().method_43048(6) < 3) {
            serverLevel.method_8501(ePos, class_2246.field_10556.method_9564());
            serverLevel.method_8501(ePos.method_10086(1), class_2246.field_10556.method_9564());
            serverLevel.method_8501(ePos.method_10086(2), class_2246.field_10556.method_9564());
            serverLevel.method_8501(ePos.method_10086(2).method_10078(), theCapBlock.method_9564());
            serverLevel.method_8501(ePos.method_10086(2).method_10067(), theCapBlock.method_9564());
            serverLevel.method_8501(ePos.method_10086(2).method_10095(), theCapBlock.method_9564());
            serverLevel.method_8501(ePos.method_10086(2).method_10072(), theCapBlock.method_9564());
            serverLevel.method_8501(ePos.method_10086(3), theCapBlock.method_9564());
        } else {
            serverLevel.method_8501(ePos, class_2246.field_10556.method_9564());
            serverLevel.method_8501(ePos.method_10086(1), class_2246.field_10556.method_9564());
            serverLevel.method_8501(ePos.method_10086(2), class_2246.field_10556.method_9564());
            serverLevel.method_8501(ePos.method_10086(2).method_10078(), theCapBlock.method_9564());
            serverLevel.method_8501(ePos.method_10086(2).method_10067(), theCapBlock.method_9564());
            serverLevel.method_8501(ePos.method_10086(2).method_10095(), theCapBlock.method_9564());
            serverLevel.method_8501(ePos.method_10086(2).method_10072(), theCapBlock.method_9564());
            serverLevel.method_8501(ePos.method_10086(2).method_10095().method_10078(), theCapBlock.method_9564());
            serverLevel.method_8501(ePos.method_10086(2).method_10095().method_10067(), theCapBlock.method_9564());
            serverLevel.method_8501(ePos.method_10086(2).method_10072().method_10078(), theCapBlock.method_9564());
            serverLevel.method_8501(ePos.method_10086(2).method_10072().method_10067(), theCapBlock.method_9564());
            serverLevel.method_8501(ePos.method_10086(3), theCapBlock.method_9564());
        }
    }

    private static boolean mobGrowTallAction(class_1297 ent, String key) {
        if (footBlock instanceof class_2526 && footBlock instanceof class_2256) {
            class_2338 ePos = MoveEntityEvent.getAdjustedBlockPos(ent);
            if (!Utility.getResourceLocationString(footBlock).contains("byg")) {
                try {
                    class_2256 ib = (class_2256)footBlock;
                    ib.method_9652((class_3218)ent.method_37908(), ent.method_37908().field_9229, ePos, ent.method_37908().method_8320(ePos));
                    Utility.debugMsg(2, ePos, key + " grew and hid in tall plant.");
                    return true;
                }
                catch (Exception e) {
                    Utility.debugMsg(1, ePos, key + " caught grow attempt exception.");
                    return false;
                }
            }
        }
        return false;
    }

    private static void mobHandleOverCrowding(class_1309 le, String key) {
        class_2338 ePos = class_2338.method_49637((double)le.method_23317(), (double)le.method_23318(), (double)le.method_23321());
        if (le instanceof class_1429) {
            class_1429 a = (class_1429)le;
            class_1937 class_19372 = le.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                class_238 box = new class_238(ePos.method_10089(3).method_10086(2).method_10076(3), ePos.method_10088(3).method_10087(2).method_10077(3));
                int excess = serverLevel.method_18023((class_5575)le.method_5864(), box, entity -> true).size() - 16;
                if (excess > 0) {
                    if (excess > 16) {
                        le.method_37908().method_8486(le.method_23317(), le.method_23318(), le.method_23321(), class_3417.field_14857, class_3419.field_15254, 1.1f, 0.54f, true);
                        le.method_5814(le.method_23317(), -66.0, le.method_23321());
                    } else {
                        float hurt = (float)excess + serverLevel.method_8409().method_43057() / 6.0f;
                        le.method_5643(le.method_37908().method_48963().method_48822(), hurt);
                    }
                }
            }
        }
    }

    private static void mobReforestAction(class_1297 entity, String key) {
        if (footBlock != class_2246.field_10124) {
            return;
        }
        if (!MoveEntityEvent.isBlockGrassOrDirt(groundBlockState)) {
            return;
        }
        class_2338 ePos = MoveEntityEvent.getAdjustedBlockPos(entity);
        double sinY = Math.sin((double)((ePos.method_10264() + 64) % 256) / 256.0);
        class_3218 serverLevel = (class_3218)entity.method_37908();
        if (serverLevel.field_9229.method_43058() > Math.abs(sinY)) {
            return;
        }
        class_2680 sapling = null;
        sapling = MoveEntityEvent.helperSaplingState(serverLevel, ePos, localBiome, sapling);
        int hval = 5;
        int yval = 0;
        int yrange = 0;
        if (MoveEntityEvent.helperCountBlocksBB(class_2473.class, 1, serverLevel, ePos, hval, yrange) > 0) {
            return;
        }
        int leafCount = 0;
        yval = 4;
        yrange = 0;
        hval = 4;
        if (sapling == class_2246.field_10385.method_9564()) {
            yval = 5;
            hval = 7;
        }
        if ((leafCount = MoveEntityEvent.helperCountBlocksBB(class_2397.class, 1, serverLevel, ePos.method_10086(yval), hval, yrange)) > 0) {
            return;
        }
        entity.method_37908().method_8501(ePos, sapling);
        Utility.debugMsg(1, ePos, key + " planted sapling.");
    }

    private static void mobStumbleAction(class_1297 entity, String key) {
        entity.method_37908().method_22352(MoveEntityEvent.getAdjustedBlockPos(entity), true);
        Utility.debugMsg(1, MoveEntityEvent.getAdjustedBlockPos(entity), key + " stumbled over torch.");
    }

    private static void mobTrodGrassBlock(class_1297 e) {
        class_2338 ePos = class_2338.method_49637((double)e.method_23317(), (double)e.method_23318(), (double)e.method_23321());
        class_1937 class_19372 = e.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverlevel = (class_3218)class_19372;
            class_238 box = new class_238(ePos.method_10089(2).method_10086(2).method_10076(2), ePos.method_10088(2).method_10087(2).method_10077(2));
            List entityList = serverlevel.method_18023((class_5575)e.method_5864(), box, entity -> true);
            if (entityList.size() >= 9) {
                serverlevel.method_8501(ePos.method_10074(), class_2246.field_10194.method_9564());
                e.method_5643(e.method_37908().method_48963().method_48822(), 0.25f);
            }
        }
    }

    private static void vBeeKeeperFlowers(class_1646 ve) {
        if (!ve.method_7231().method_16924().comp_818().contains("beekeeper")) {
            return;
        }
        Utility.debugMsg(1, ve.method_24515(), "Beekeeper checking on flowers here.");
        if (ve.method_23317() % 6.0 == 0.0 && ve.method_23321() % 7.0 == 0.0 && MoveEntityEvent.isBlockGrassOrDirt(groundBlockState) && MoveEntityEvent.helperCountBlocksOrthogonalBB(class_2246.field_10194, 1, ve.method_37908(), ve.method_24515().method_10074(), 0) == 1) {
            class_2680 flowerBlockState = class_2246.field_10573.method_9564();
            ve.method_37908().method_8501(adjustedPos, flowerBlockState);
        }
    }

    private static void vClericalHealing(class_1646 ve) {
        if (ve.method_7231().method_16924() != class_3852.field_17055) {
            return;
        }
        long daytime = ve.method_37908().method_8532() % 24000L;
        if (daytime < 9000L || daytime > 11000L) {
            return;
        }
        class_1937 class_19372 = ve.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 varW = (class_3218)class_19372;
            int clericalLevel = ve.method_7231().method_16925();
            class_2338 vePos = class_2338.method_49637((double)ve.method_23317(), (double)(ve.method_23318() + 0.99), (double)ve.method_23321());
            class_238 aabb = new class_238(vePos.method_10089(4).method_10086(2).method_10076(4), vePos.method_10088(4).method_10087(2).method_10077(4));
            List l = varW.method_8333((class_1297)null, aabb, entity -> entity instanceof class_1646 || entity instanceof class_1657);
            for (class_1297 e : l) {
                class_1657 pe;
                int rep;
                boolean heal = true;
                class_1309 le = (class_1309)e;
                if (le.method_6032() >= le.method_6063()) {
                    heal = false;
                }
                if (le.method_6112(class_1294.field_5924) != null) {
                    heal = false;
                }
                if (e instanceof class_1657 && (rep = ve.method_20594(pe = (class_1657)e)) < 0) {
                    heal = false;
                }
                if (!heal) continue;
                le.method_37222(new class_1293(class_1294.field_5924, clericalLevel * 51, 0), (class_1297)ve);
                ve.method_37908().method_8396(null, vePos, class_3417.field_26942, class_3419.field_15254, 1.2f, 1.52f);
                return;
            }
        }
    }

    private static boolean vImproveFarm(class_1646 ve, String regrowthType) {
        if (ve.method_7231().method_16924() != class_3852.field_17056) {
            return false;
        }
        class_2338 vePos = MoveEntityEvent.getAdjustedBlockPos((class_1297)ve);
        class_2248 groundBlock = groundBlockState.method_26204();
        class_2248 footBlock = footBlockState.method_26204();
        if (MoveEntityEvent.helperCountBlocksOrthogonalBB(class_2246.field_10362, 1, ve.method_37908(), vePos.method_10087(1), 0) > 0) {
            if (MoveEntityEvent.isNearWater(ve.method_37908(), vePos.method_10087(1)) && groundBlock instanceof class_2372) {
                ve.method_37908().method_8501(vePos.method_10074(), class_2246.field_10362.method_9564());
                return true;
            }
            if (!regrowthType.contains("t") || footBlock != class_2246.field_10124) {
                return false;
            }
            if (ve.method_37908().method_8314(class_1944.field_9282, vePos) > 12) {
                return false;
            }
            int veX = vePos.method_10263();
            int veY = vePos.method_10264();
            int veZ = vePos.method_10260();
            if (lastTorchX == veX && lastTorchY == veY && lastTorchZ == veZ) {
                return false;
            }
            boolean placeTorch = false;
            int waterValue = MoveEntityEvent.helperCountBlocksOrthogonalBB(class_2246.field_10382, 1, ve.method_37908(), vePos.method_10074(), 0);
            if (waterValue > 0 && groundBlockState.method_26164(class_3481.field_15475) || groundBlock == class_2246.field_10467) {
                ve.method_37908().method_8652(vePos, class_2246.field_10336.method_9564(), 3);
                lastTorchX = veX;
                lastTorchY = veY;
                lastTorchZ = veZ;
                return true;
            }
        }
        return false;
    }

    private static void vImproveFences(class_1646 ve, String key, String regrowthType) {
        class_2338 ePos = ve.method_24515();
        class_4095 vb = ve.method_18868();
        Optional vMeetingPlace = vb.method_18904(class_4140.field_18440);
        if (!vMeetingPlace.isPresent()) {
            return;
        }
        if (MoveEntityEvent.isOkayToBuildWallHere(ve)) {
            class_4208 gVMP = (class_4208)vMeetingPlace.get();
            class_2338 villageMeetingPlaceBlockPos = gVMP.method_19446();
            if (!(ve.method_37908().method_8320(villageMeetingPlaceBlockPos.method_10086(1)).method_26204() instanceof class_2544)) {
                return;
            }
            if (regrowthType.contains("p")) {
                Optional villagerHome = vb.method_18904(class_4140.field_18438);
                if (!villagerHome.isPresent()) {
                    return;
                }
                class_4208 gVHP = (class_4208)villagerHome.get();
                class_2338 villagerHomePos = gVHP.method_19446();
                if (!MoveEntityEvent.isOutsideMeetingPlaceWall(ve, vMeetingPlace, ((class_4208)vMeetingPlace.get()).method_19446(), localBiome) || MoveEntityEvent.vImproveHomeFence(ve, villagerHomePos, regrowthType)) {
                    // empty if block
                }
            }
        }
    }

    private static boolean vImproveHomeFence(class_1646 ve, class_2338 vHomePos, String regrowthActions) {
        class_2680 fenceBlockState;
        class_2338 vePos = MoveEntityEvent.getAdjustedBlockPos((class_1297)ve);
        Object key = "minecraft:" + biomeCategory;
        WallBiomeDataManager.WallBiomeDataItem currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem((String)(key = ((String)key).toLowerCase()));
        if (currentWallBiomeDataItem == null && (currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem((String)(key = "minecraft:" + biomeCategory.toLowerCase()))) == null) {
            currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem("minecraft:plains");
        }
        int homeFenceDiameter = currentWallBiomeDataItem.getWallDiameter();
        int wallTorchSpacing = (homeFenceDiameter /= 4) / 4;
        homeFenceDiameter = homeFenceDiameter / 2 - 1;
        Collection result = ((class_3218)ve.method_37908()).method_19494().method_22383(t -> t == class_7477.field_39291, vePos, 17, class_4153.class_4155.field_18489).collect(Collectors.toCollection(ArrayList::new));
        boolean buildFence = true;
        if (!result.isEmpty()) {
            for (class_4156 P : result) {
                if (vHomePos.method_10263() == P.method_19141().method_10263() && vHomePos.method_10264() == P.method_19141().method_10264() && vHomePos.method_10260() == P.method_19141().method_10260()) continue;
                int disX = Math.abs(vePos.method_10263() - P.method_19141().method_10263());
                int disZ = Math.abs(vePos.method_10260() - P.method_19141().method_10260());
                Utility.debugMsg(1, P.method_19141(), "extra Point of Interest Found.");
                if (disX >= homeFenceDiameter || disZ >= homeFenceDiameter) continue;
                buildFence = false;
                break;
            }
        } else if (result.isEmpty()) {
            buildFence = true;
        }
        if (buildFence && MoveEntityEvent.helperPlaceOneWallPiece((class_1309)ve, homeFenceDiameter, wallTorchSpacing, fenceBlockState = currentWallBiomeDataItem.getFenceBlockState(), vHomePos)) {
            if (regrowthActions.contains("t") && MoveEntityEvent.isValidTorchLocation(homeFenceDiameter, wallTorchSpacing, MoveEntityEvent.getAbsVX((class_1297)ve, vHomePos), MoveEntityEvent.getAbsVZ((class_1297)ve, vHomePos), ve.method_37908().method_8320(vePos).method_26204())) {
                ve.method_37908().method_8501(vePos.method_10084(), class_2246.field_10336.method_9564());
            }
            MoveEntityEvent.helperJumpAway((class_1297)ve);
            return true;
        }
        return false;
    }

    private static void vImproveLeaves(class_1646 ve, String key) {
        float veYaw = ve.method_5705(1.0f) / 45.0f;
        class_2338 vePos = MoveEntityEvent.getAdjustedBlockPos((class_1297)ve);
        int facingNdx = Math.round(veYaw);
        if (facingNdx < 0) {
            facingNdx = Math.abs(facingNdx);
        }
        int dx = facingArray[facingNdx %= 8][0];
        int dz = facingArray[facingNdx][1];
        class_2338 tmpBP = null;
        class_2680 tempBS = null;
        class_2248 tempBlock = null;
        boolean destroyBlock = false;
        for (int iY = 0; iY < 2; ++iY) {
            boolean persistantLeaves;
            tmpBP = new class_2338(vePos.method_10263() + dx, vePos.method_10264() + iY, vePos.method_10260() + dz);
            tempBS = ve.method_37908().method_8320(tmpBP);
            tempBlock = tempBS.method_26204();
            if (tempBlock instanceof class_2397 && !(persistantLeaves = ((Boolean)tempBS.method_11654((class_2769)class_2397.field_11200)).booleanValue())) {
                destroyBlock = true;
            }
            if (tempBlock instanceof class_2266) {
                destroyBlock = true;
            }
            if (!destroyBlock) continue;
            ve.method_37908().method_22352(tmpBP, false);
            destroyBlock = false;
            Utility.debugMsg(1, (class_1309)ve, key + " cleared " + tempBlock.method_9539().toString());
        }
    }

    private static boolean vImproveLighting(class_1646 ve) {
        class_2338 vePos = MoveEntityEvent.getAdjustedBlockPos((class_1297)ve);
        int blockLightValue = ve.method_37908().method_8314(class_1944.field_9282, vePos);
        int skyLightValue = ve.method_37908().method_8314(class_1944.field_9284, vePos);
        if (blockLightValue > MyConfig.getTorchLightLevel()) {
            return false;
        }
        if (skyLightValue > 11) {
            return false;
        }
        if (ve.method_6113()) {
            return false;
        }
        if (footBlockState.method_26204() instanceof class_2244) {
            return false;
        }
        if (MoveEntityEvent.isValidGroundBlockToPlaceTorchOn(ve) && footBlockState.method_26215() || MoveEntityEvent.isNatProgPebbleOrStick((class_3218)ve.method_37908())) {
            ve.method_37908().method_8652(vePos, class_2246.field_10336.method_9564(), 3);
        }
        return true;
    }

    private static void vImproveRoads(class_1646 ve, String debugkey) {
        if (MoveEntityEvent.vImproveRoadsClearSnow((class_1297)ve)) {
            Utility.debugMsg(1, (class_1309)ve, debugkey + " clear snow on road.");
        }
        if (MoveEntityEvent.vImproveRoadsFixPatches((class_1297)ve)) {
            Utility.debugMsg(1, (class_1309)ve, debugkey + " fix patches on road.");
        }
        if (MoveEntityEvent.vImproveRoadsFixPotholes((class_1297)ve)) {
            Utility.debugMsg(1, (class_1309)ve, debugkey + " fix potholes in road.");
        }
        if (MoveEntityEvent.vImproveRoadsSmoothHeight(ve)) {
            Utility.debugMsg(1, (class_1309)ve, debugkey + " Smooth road slope.");
        }
    }

    private static boolean vImproveRoadsClearSnow(class_1297 e) {
        class_2248 biomeRoadBlock = MoveEntityEvent.helperBiomeRoadBlockType(Utility.GetBiomeName(localBiome)).method_26204();
        if (groundBlock != biomeRoadBlock) {
            return false;
        }
        if (footBlock instanceof class_2488) {
            e.method_37908().method_22352(adjustedPos, false);
            footBlockState = class_2246.field_10124.method_9564();
            footBlock = footBlockState.method_26204();
            return true;
        }
        return false;
    }

    private static boolean vImproveRoadsFixPatches(class_1297 e) {
        if (!e.method_37908().method_8311(e.method_24515())) {
            return false;
        }
        class_2248 biomeRoadBlock = MoveEntityEvent.helperBiomeRoadBlockType(Utility.GetBiomeName(localBiome)).method_26204();
        if (groundBlock == biomeRoadBlock) {
            return false;
        }
        int roadY = 0;
        int roadBlocks = 0;
        class_2338 vePos = MoveEntityEvent.getAdjustedBlockPos(e);
        for (int i = 0; i < 4; ++i) {
            roadY = e.method_37908().method_8624(class_2902.class_2903.field_13203, vePos.method_10263() + dx[i], vePos.method_10260() + dz[i]) - 1;
            class_2248 tempBlock = e.method_37908().method_8320(new class_2338(vePos.method_10263() + dx[i], roadY, vePos.method_10260() + dz[i])).method_26204();
            if (tempBlock != biomeRoadBlock || ++roadBlocks < 3) continue;
            if (footBlock instanceof class_2488) {
                e.method_37908().method_22352(adjustedPos, false);
                footBlockState = class_2246.field_10124.method_9564();
                footBlock = footBlockState.method_26204();
            }
            e.method_37908().method_8501(adjustedPos.method_10074(), biomeRoadBlock.method_9564());
            return true;
        }
        return false;
    }

    private static boolean vImproveRoadsFixPotholes(class_1297 e) {
        if (!e.method_37908().method_8311(e.method_24515())) {
            return false;
        }
        class_2248 biomeRoadBlock = MoveEntityEvent.helperBiomeRoadBlockType(Utility.GetBiomeName(localBiome)).method_26204();
        if (groundBlock == biomeRoadBlock && footBlock instanceof class_2488) {
            e.method_37908().method_22352(MoveEntityEvent.getAdjustedBlockPos(e), false);
        }
        class_2338 vePos = e.method_24515();
        int veX = vePos.method_10263();
        int veY = vePos.method_10264();
        int veZ = vePos.method_10260();
        int roadY = 0;
        int higherRoadBlocks = 0;
        for (int i = 0; i < 4; ++i) {
            roadY = e.method_37908().method_8624(class_2902.class_2903.field_13203, veX + dx[i], veZ + dz[i]) - 1;
            class_2248 tempBlock = e.method_37908().method_8320(new class_2338(veX + dx[i], roadY, veZ + dz[i])).method_26204();
            if (tempBlock != biomeRoadBlock || roadY <= veY) continue;
            ++higherRoadBlocks;
        }
        if (higherRoadBlocks == 4) {
            e.method_37908().method_8501(adjustedPos, biomeRoadBlock.method_9564());
            return true;
        }
        return false;
    }

    private static boolean vImproveRoadsSmoothHeight(class_1646 ve) {
        if (!ve.method_24828()) {
            return false;
        }
        if (ve.method_6109()) {
            return false;
        }
        class_2338 vePos = MoveEntityEvent.getAdjustedBlockPos((class_1297)ve);
        if (!ve.method_37908().method_8311(ve.method_24515())) {
            return false;
        }
        class_2248 biomeRoadBlock = MoveEntityEvent.helperBiomeRoadBlockType(Utility.GetBiomeName(localBiome)).method_26204();
        if (biomeRoadBlock == class_2246.field_10467 && !isRoadPiece) {
            return false;
        }
        if (groundBlockState.method_26204() != biomeRoadBlock && footBlockState.method_26204() != biomeRoadBlock) {
            return false;
        }
        class_2680 biomeRoadBlockState = biomeRoadBlock.method_9564();
        int poiDistance = 3;
        if (biomeCategory == Utility.DESERT) {
            poiDistance = 7;
        }
        if (MoveEntityEvent.isNearbyPoi(ve, localBiome, vePos, poiDistance)) {
            return false;
        }
        int veX = vePos.method_10263();
        int veY = vePos.method_10264();
        int veZ = vePos.method_10260();
        int roadY = 0;
        for (int i = 0; i < 4; ++i) {
            class_2248 tempBlock;
            roadY = ve.method_37908().method_8624(class_2902.class_2903.field_13203, veX + dx[i], veZ + dz[i]) - 1;
            if (roadY <= veY || (tempBlock = ve.method_37908().method_8320(new class_2338(veX + dx[i], roadY, veZ + dz[i])).method_26204()) != biomeRoadBlock) continue;
            ve.method_37908().method_8501(new class_2338(veX, veY, veZ), biomeRoadBlockState);
            if (ve.method_37908().method_8320(vePos.method_10086(2)).method_26204() == biomeRoadBlockState.method_26204()) {
                ve.method_37908().method_22352(vePos.method_10086(2), true);
            } else if (ve.method_37908().method_8320(vePos.method_10086(3)).method_26204() == biomeRoadBlockState.method_26204()) {
                ve.method_37908().method_22352(vePos.method_10086(3), true);
            }
            ve.method_18800(0.0, 0.4, 0.0);
            return true;
        }
        return false;
    }

    private static boolean vImproveVillageWall(class_1646 ve, String regrowthActions) {
        if (!ve.method_18868().method_18904(class_4140.field_18440).isPresent()) {
            return false;
        }
        if (!MoveEntityEvent.isOkayToBuildWallHere(ve)) {
            return false;
        }
        class_2338 gVMPPos = ((class_4208)ve.method_18868().method_18904(class_4140.field_18440).get()).method_19446();
        if (MyConfig.getPlayerWallControlBlock() != class_2246.field_10124) {
            if (ve.method_37908().method_8500(gVMPPos).method_12033() < 200L) {
                ve.method_37908().method_8652(gVMPPos.method_10086(1), MyConfig.getPlayerWallControlBlock().method_9564(), 3);
            }
            if (ve.method_37908().method_8320(gVMPPos.method_10086(1)).method_26204() != MyConfig.playerWallControlBlock) {
                return false;
            }
        }
        class_2338 vePos = MoveEntityEvent.getAdjustedBlockPos((class_1297)ve);
        Object key = "minecraft:" + biomeCategory.toString();
        key = ((String)key).toLowerCase();
        WallBiomeDataManager.WallBiomeDataItem currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem((String)key);
        int wallRadius = currentWallBiomeDataItem.getWallDiameter();
        if (MoveEntityEvent.isOnWallRadius((class_1297)ve, wallRadius = wallRadius / 2 - 1, gVMPPos)) {
            class_2680 wallTypeBlockState;
            class_2680 wallBlock;
            int wallTorchSpacing;
            Collection result = ((class_3218)ve.method_37908()).method_19494().method_22383(t -> t == class_7477.field_39292, ve.method_24515(), 41, class_4153.class_4155.field_18489).collect(Collectors.toCollection(ArrayList::new));
            boolean buildWall = true;
            if (!result.isEmpty()) {
                for (class_4156 P : result) {
                    if (gVMPPos.method_10263() == P.method_19141().method_10263() && gVMPPos.method_10264() == P.method_19141().method_10264() && gVMPPos.method_10260() == P.method_19141().method_10260()) continue;
                    int disX = Math.abs(ve.method_24515().method_10263() - P.method_19141().method_10263());
                    int disZ = Math.abs(ve.method_24515().method_10260() - P.method_19141().method_10260());
                    if (disX >= wallRadius || disZ >= wallRadius) continue;
                    buildWall = false;
                    break;
                }
            }
            if (buildWall && MoveEntityEvent.helperPlaceOneWallPiece((class_1309)ve, wallRadius, wallTorchSpacing = (wallRadius + 1) / 4, wallBlock = (wallTypeBlockState = currentWallBiomeDataItem.getWallBlockState()), gVMPPos)) {
                if (regrowthActions.contains("t") && MoveEntityEvent.isValidTorchLocation(wallRadius, wallTorchSpacing, MoveEntityEvent.getAbsVX((class_1297)ve, gVMPPos), MoveEntityEvent.getAbsVZ((class_1297)ve, gVMPPos), ve.method_37908().method_8320(vePos).method_26204())) {
                    ve.method_37908().method_8501(vePos.method_10084(), class_2246.field_10336.method_9564());
                }
                MoveEntityEvent.helperJumpAway((class_1297)ve);
                return true;
            }
        }
        return false;
    }

    private static void vImproveWalls(class_1646 ve, String key, String regrowthType) {
        if (groundBlockState.method_26215()) {
            return;
        }
        class_2338 vePos = MoveEntityEvent.getAdjustedBlockPos((class_1297)ve);
        if (!ve.method_18868().method_18904(class_4140.field_18440).isPresent()) {
            return;
        }
        if (MoveEntityEvent.vImproveVillageWall(ve, regrowthType)) {
            Utility.debugMsg(1, (class_1309)ve, "Town Wall Improved.");
        }
    }

    private static void vToolMasterHealing(class_1646 ve) {
        if (ve.method_7231().method_16924() != class_3852.field_17064) {
            return;
        }
        long daytime = ve.method_37908().method_8532() % 24000L;
        if (daytime < 9000L || daytime > 11000L) {
            return;
        }
        class_1937 class_19372 = ve.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 varW = (class_3218)class_19372;
            int villagerLevel = ve.method_7231().method_16925();
            if (villagerLevel < 1) {
                return;
            }
            class_2338 vePos = class_2338.method_49637((double)ve.method_23317(), (double)(ve.method_23318() + 0.99), (double)ve.method_23321());
            class_238 box = new class_238(vePos.method_10089(6).method_10086(3).method_10076(6), vePos.method_10088(6).method_10087(2).method_10077(6));
            List l = varW.method_18023((class_5575)class_1299.field_6147, box, e -> true);
            for (class_1439 e2 : l) {
                boolean heal = true;
                if (e2.method_6032() >= e2.method_6063()) {
                    heal = false;
                }
                if (e2.method_6112(class_1294.field_5924) != null) {
                    heal = false;
                }
                if (!heal) continue;
                e2.method_37222(new class_1293(class_1294.field_5924, villagerLevel * 51, 0), (class_1297)ve);
                ve.method_37222(new class_1293(class_1294.field_5924, villagerLevel * 11, 0), (class_1297)ve);
                ve.method_37908().method_8396(null, vePos, class_3417.field_20680, class_3419.field_15254, 0.5f, 0.5f);
                return;
            }
        }
    }

    static {
        isRoadPiece = false;
    }
}

