/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.blocks;

import com.Fishmod.mod_LavaCow.client.Modconfig;
import com.Fishmod.mod_LavaCow.core.SpawnUtil;
import com.Fishmod.mod_LavaCow.init.Modblocks;
import com.Fishmod.mod_LavaCow.mod_LavaCow;
import com.Fishmod.mod_LavaCow.worldgen.WorldGenLargeGlowShroom;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="mod_lavacow")
public class BlockGlowShroom
extends BlockMushroom {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)1);
    private boolean isGlowshroom;

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    protected int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
    }

    public IBlockState withAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public IBlockState func_176203_a(int meta) {
        return this.withAge(meta);
    }

    public int func_176201_c(IBlockState state) {
        return this.getAge(state);
    }

    public BlockGlowShroom(boolean isGlowshroom) {
        this.field_149762_H = SoundType.field_185850_c;
        this.isGlowshroom = isGlowshroom;
        this.func_149715_a(isGlowshroom ? 1.0f : 0.0f);
        this.func_149647_a(mod_LavaCow.TAB_ITEMS);
    }

    protected PropertyInteger getAgeProperty() {
        return AGE;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (rand.nextInt(100) < Modconfig.pSpreadRate_Glowshroom) {
            super.func_180650_b(worldIn, pos, state, rand);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.isGlowshroom && rand.nextInt(16) == 0) {
            BlockGlowShroom.spawnParticles(worldIn, pos);
        }
        super.func_180655_c(stateIn, worldIn, pos, rand);
    }

    public static void spawnParticles(World worldIn, BlockPos pos) {
        Random random = worldIn.field_73012_v;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            if (worldIn.func_180495_p(blockpos).func_185914_p() || !worldIn.field_72995_K) continue;
            EnumFacing.Axis enumfacing$axis = enumfacing.func_176740_k();
            double d1 = enumfacing$axis == EnumFacing.Axis.X ? 0.5 + 0.5625 * (double)enumfacing.func_82601_c() : (double)random.nextFloat();
            double d2 = enumfacing$axis == EnumFacing.Axis.Y ? 0.5 + 0.5625 * (double)enumfacing.func_96559_d() : (double)random.nextFloat();
            double d3 = enumfacing$axis == EnumFacing.Axis.Z ? 0.5 + 0.5625 * (double)enumfacing.func_82599_e() : (double)random.nextFloat();
            mod_LavaCow.PROXY.spawnCustomParticle("spore", worldIn, (double)pos.func_177958_n() + d1, (double)pos.func_177956_o() + d2, (double)pos.func_177952_p() + d3, 0.0, 0.0, 0.0, 0.0f, 0.98f, 0.93f);
        }
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
            if (iblockstate.func_177230_c() == Blocks.field_150391_bh) {
                return true;
            }
            if (iblockstate.func_177230_c() == Blocks.field_150346_d && iblockstate.func_177229_b((IProperty)BlockDirt.field_176386_a) == BlockDirt.DirtType.PODZOL) {
                return true;
            }
            return (SpawnUtil.isDay(worldIn) && this.isGlowshroom || worldIn.func_175699_k(pos) < 13) && iblockstate.func_177230_c().canSustainPlant(iblockstate, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return false;
    }

    public boolean func_176485_d(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        worldIn.func_175698_g(pos);
        WorldGenLargeGlowShroom worldgenerator = null;
        if (this.isGlowshroom) {
            worldgenerator = new WorldGenLargeGlowShroom((Block)Modblocks.GLOWSHROOM_BLOCK_CAP, (Block)Modblocks.GLOWSHROOM_BLOCK_STEM);
        }
        if (worldgenerator != null && worldgenerator.func_180709_b(worldIn, rand, pos)) {
            return true;
        }
        worldIn.func_180501_a(pos, state, 3);
        return false;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Cave;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return this.isGlowshroom;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return this.isGlowshroom && (double)rand.nextFloat() < 0.4;
    }
}

