/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.entities;

import com.Fishmod.mod_LavaCow.client.Modconfig;
import com.Fishmod.mod_LavaCow.entities.IAggressive;
import com.Fishmod.mod_LavaCow.entities.projectiles.EntityDeathCoil;
import com.Fishmod.mod_LavaCow.entities.projectiles.EntitySandBurst;
import com.Fishmod.mod_LavaCow.init.FishItems;
import com.Fishmod.mod_LavaCow.util.LootTableHandler;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySkeletonKing
extends EntityMob
implements IAggressive {
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.WHITE, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    private static final DataParameter<BlockPos> SPAWN_ORIGIN = EntityDataManager.func_187226_a(EntitySkeletonKing.class, (DataSerializer)DataSerializers.field_187200_j);
    private int attackTimer;
    protected int[] spellTicks = new int[]{0, 0};

    public EntitySkeletonKing(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.25f, 3.1f);
        this.field_70178_ae = true;
        this.field_70728_aV = 50;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AICastingApell());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AITeleportSpell());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AITossSpell());
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AISummoningSpell());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AISkeletonKingAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Modconfig.SkeletonKing_Health);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Modconfig.SkeletonKing_Attack);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPAWN_ORIGIN, (Object)new BlockPos(0, 0, 0));
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean isSpellcasting() {
        for (int i = 0; i < 2; ++i) {
            if (this.spellTicks[i] <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isSpellcasting(int i) {
        return this.spellTicks[i] > 0;
    }

    public int getSpellTicks(int i) {
        return this.spellTicks[i];
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            this.field_70125_A = this.field_70127_C;
            this.field_70177_z = this.field_70126_B;
            if (this.attackTimer == 10) {
                this.func_184185_a(FishItems.ENTITY_SKELETONKING_ATTACK, 1.0f, 1.0f);
            }
        }
        for (int i = 0; i < 2; ++i) {
            if (this.spellTicks[i] <= 0) continue;
            int n = i;
            this.spellTicks[n] = this.spellTicks[n] - 1;
            if (!this.field_70170_p.field_72995_K) continue;
            for (int j = 0; j < 4; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, this.field_70146_Z.nextDouble() * 0.5, 0.0, new int[0]);
            }
        }
        EntityLivingBase target = this.func_70638_az();
        if (target != null && this.func_70068_e((Entity)target) < 4.0 && this.getAttackTimer() == 5 && this.field_70725_aQ <= 0 && this.func_70685_l((Entity)target)) {
            IBlockState state = this.field_70170_p.func_180495_p(target.func_180425_c().func_177977_b());
            int blockId = Block.func_176210_f((IBlockState)state);
            this.func_184185_a(SoundEvents.field_187747_eB, 1.0f, 0.5f);
            if (state.func_185914_p() && this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, target.field_70165_t + (double)(this.field_70146_Z.nextFloat() * target.field_70130_N * 2.0f) - (double)this.field_70130_N, target.field_70163_u + (double)(this.field_70146_Z.nextFloat() * target.field_70130_N * 2.0f) - (double)target.field_70130_N, target.field_70161_v + (double)(this.field_70146_Z.nextFloat() * target.field_70130_N * 2.0f) - (double)target.field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[]{blockId});
                }
            }
            for (EntityLivingBase entitylivingbase : this.field_70170_p.func_72872_a(EntityLivingBase.class, target.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0))) {
                if (this.func_70028_i((Entity)entitylivingbase) || this.func_184191_r((Entity)entitylivingbase)) continue;
                entitylivingbase.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                entitylivingbase.func_70653_a((Entity)this, 0.4f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            }
        }
    }

    public int func_82143_as() {
        return 128;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.attackTimer == 0) {
            this.attackTimer = 20;
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        }
        return false;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public boolean isAggressive() {
        return false;
    }

    @Override
    public int getAttackTimer() {
        return this.attackTimer;
    }

    @Override
    public void setAttackTimer(int i) {
        this.attackTimer = i;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76355_l().equals(DamageSource.field_76368_d.field_76373_n)) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)(3.0 + this.field_70146_Z.nextDouble() * 1.5), true);
        }
        return super.func_70097_a(source, amount);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 20;
        } else if (id == 10) {
            this.spellTicks[0] = 30;
        } else if (id == 11) {
            this.spellTicks[1] = 15;
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.spellTicks[0] = compound.func_74762_e("SpellTicks0");
        this.spellTicks[1] = compound.func_74762_e("SpellTicks1");
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("SpellTicks0", this.spellTicks[0]);
        compound.func_74768_a("SpellTicks1", this.spellTicks[1]);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        return FishItems.ENTITY_SKELETONKING_DEATH;
    }

    protected SoundEvent getSpellSound() {
        return SoundEvents.field_191244_bn;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.field_187868_fj;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void func_70645_a(DamageSource cause) {
        TileEntity tileentity;
        BlockPos position = new BlockPos((Vec3i)this.func_180425_c());
        super.func_70645_a(cause);
        while (this.field_70170_p.func_180495_p(position.func_177977_b()).func_177230_c() == Blocks.field_150350_a) {
            position = position.func_177977_b();
        }
        while (this.field_70170_p.func_180495_p(position).func_177230_c() != Blocks.field_150350_a) {
            position = position.func_177984_a();
        }
        this.field_70170_p.func_180501_a(position, Blocks.field_150486_ae.func_176223_P(), 15);
        if (this.field_70170_p.func_180495_p(position).func_177230_c() instanceof BlockChest && (tileentity = this.field_70170_p.func_175625_s(position)) instanceof TileEntityChest && !tileentity.func_145837_r()) {
            ((TileEntityChest)tileentity).func_189404_a(LootTableHandler.SKELETON_KING, this.field_70146_Z.nextLong());
        }
    }

    static class AISkeletonKingAttackMelee
    extends EntityAIAttackMelee {
        public AISkeletonKingAttackMelee(EntityCreature creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
        }

        protected void func_190102_a(EntityLivingBase p_190102_1_, double p_190102_2_) {
            double d0 = this.func_179512_a(p_190102_1_);
            if (p_190102_2_ <= d0 && this.field_75439_d <= 0) {
                this.field_75439_d = 60;
                this.field_75441_b.func_184609_a(EnumHand.MAIN_HAND);
                this.field_75441_b.func_70652_k((Entity)p_190102_1_);
            }
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return this.field_75441_b.field_70130_N * 3.0f * this.field_75441_b.field_70130_N * 3.0f + attackTarget.field_70130_N;
        }
    }

    public class AITossSpell
    extends EntityAIBase {
        protected int spellWarmup;
        protected int spellCooldown;

        public boolean func_75250_a() {
            if (EntitySkeletonKing.this.func_70638_az() == null || EntitySkeletonKing.this.func_110143_aJ() > EntitySkeletonKing.this.func_110138_aP() * 0.5f || EntitySkeletonKing.this.getAttackTimer() > 0) {
                return false;
            }
            if ((EntitySkeletonKing.this.isSpellcasting() || !EntitySkeletonKing.this.func_70685_l((Entity)EntitySkeletonKing.this.func_70638_az())) && (double)EntitySkeletonKing.this.func_70032_d((Entity)EntitySkeletonKing.this.func_70638_az()) > 16.0) {
                return false;
            }
            return EntitySkeletonKing.this.field_70173_aa >= this.spellCooldown;
        }

        public boolean func_75253_b() {
            return EntitySkeletonKing.this.func_70638_az() != null && this.spellWarmup > 0;
        }

        public void func_75249_e() {
            this.spellWarmup = this.getCastWarmupTime();
            EntitySkeletonKing.this.spellTicks[1] = this.getCastingTime();
            this.spellCooldown = EntitySkeletonKing.this.field_70173_aa + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            EntitySkeletonKing.this.field_70170_p.func_72960_a((Entity)EntitySkeletonKing.this, (byte)11);
            if (soundevent != null) {
                EntitySkeletonKing.this.func_184185_a(soundevent, 1.0f, 1.0f);
            }
        }

        public void func_75246_d() {
            --this.spellWarmup;
            if (this.spellWarmup == 0) {
                this.castSpell();
            }
        }

        protected void castSpell() {
            if (EntitySkeletonKing.this.func_70638_az() == null) {
                return;
            }
            for (int i = -1; i < 2; ++i) {
                EntityDeathCoil entitysnowball = new EntityDeathCoil(EntitySkeletonKing.this.field_70170_p, (EntityLivingBase)EntitySkeletonKing.this);
                entitysnowball.func_184538_a((Entity)EntitySkeletonKing.this, EntitySkeletonKing.this.field_70125_A, EntitySkeletonKing.this.field_70177_z + (float)i * 30.0f, 0.0f, 0.75f, 1.0f);
                EntitySkeletonKing.this.field_70170_p.func_72838_d((Entity)entitysnowball);
            }
        }

        protected int getCastWarmupTime() {
            return 15;
        }

        protected int getCastingTime() {
            return 15;
        }

        protected int getCastingInterval() {
            return 120;
        }

        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return FishItems.ENTITY_SKELETONKING_SPELL_TOSS;
        }
    }

    public class AITeleportSpell
    extends EntityAIBase {
        protected int spellWarmup;
        protected int spellCooldown;

        public boolean func_75250_a() {
            if (EntitySkeletonKing.this.func_70638_az() == null || EntitySkeletonKing.this.getAttackTimer() > 0) {
                return false;
            }
            if (EntitySkeletonKing.this.isSpellcasting() || (double)EntitySkeletonKing.this.func_70032_d((Entity)EntitySkeletonKing.this.func_70638_az()) > 16.0 || (double)EntitySkeletonKing.this.func_70032_d((Entity)EntitySkeletonKing.this.func_70638_az()) < 4.0) {
                return false;
            }
            return EntitySkeletonKing.this.field_70173_aa >= this.spellCooldown;
        }

        public boolean func_75253_b() {
            return EntitySkeletonKing.this.func_70638_az() != null && this.spellWarmup > 0;
        }

        public void func_75249_e() {
            this.spellWarmup = this.getCastWarmupTime();
            this.spellCooldown = EntitySkeletonKing.this.field_70173_aa + this.getCastingInterval();
        }

        public void func_75246_d() {
            --this.spellWarmup;
            if (this.spellWarmup == 0) {
                this.castSpell();
            }
        }

        protected void castSpell() {
            EntitySkeletonKing.this.func_184595_k(EntitySkeletonKing.this.func_70638_az().field_70165_t, EntitySkeletonKing.this.func_70638_az().field_70163_u, EntitySkeletonKing.this.func_70638_az().field_70161_v);
            EntitySkeletonKing.this.func_184185_a(this.getSpellPrepareSound(), 1.0f, 1.0f);
        }

        protected int getCastWarmupTime() {
            return 20;
        }

        protected int getCastingTime() {
            return 30;
        }

        protected int getCastingInterval() {
            return EntitySkeletonKing.this.func_110143_aJ() > EntitySkeletonKing.this.func_110138_aP() * 0.5f ? 320 : 160;
        }

        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return FishItems.ENTITY_SKELETONKING_SPELL_TELEPORT;
        }
    }

    public class AISummoningSpell
    extends EntityAIBase {
        protected int spellWarmup;
        protected int spellCooldown;

        public boolean func_75250_a() {
            if (EntitySkeletonKing.this.func_70638_az() == null || EntitySkeletonKing.this.getAttackTimer() > 0) {
                return false;
            }
            if ((EntitySkeletonKing.this.isSpellcasting() || !EntitySkeletonKing.this.func_70685_l((Entity)EntitySkeletonKing.this.func_70638_az())) && (double)EntitySkeletonKing.this.func_70032_d((Entity)EntitySkeletonKing.this.func_70638_az()) > 16.0) {
                return false;
            }
            return EntitySkeletonKing.this.field_70173_aa >= this.spellCooldown;
        }

        public boolean func_75253_b() {
            return EntitySkeletonKing.this.func_70638_az() != null && this.spellWarmup > 0;
        }

        public void func_75249_e() {
            this.spellWarmup = this.getCastWarmupTime();
            EntitySkeletonKing.this.spellTicks[0] = this.getCastingTime();
            this.spellCooldown = EntitySkeletonKing.this.field_70173_aa + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            EntitySkeletonKing.this.field_70170_p.func_72960_a((Entity)EntitySkeletonKing.this, (byte)10);
            if (soundevent != null) {
                EntitySkeletonKing.this.func_184185_a(soundevent, 1.0f, 1.0f);
            }
        }

        public void func_75246_d() {
            --this.spellWarmup;
            if (this.spellWarmup == 0) {
                this.castSpell();
            }
        }

        protected void castSpell() {
            for (int i = 0; i < 11; ++i) {
                BlockPos blockpos = new BlockPos((Entity)EntitySkeletonKing.this).func_177982_a(-12 + EntitySkeletonKing.this.field_70146_Z.nextInt(24), 0, -12 + EntitySkeletonKing.this.field_70146_Z.nextInt(24));
                EntitySandBurst entityevokerfangs = new EntitySandBurst(EntitySkeletonKing.this.field_70170_p, blockpos.func_177958_n(), EntitySkeletonKing.this.field_70170_p.func_175645_m(blockpos).func_177956_o(), blockpos.func_177952_p(), 0.0f, 20, (EntityLivingBase)EntitySkeletonKing.this);
                EntitySkeletonKing.this.field_70170_p.func_72838_d((Entity)entityevokerfangs);
            }
            EntitySandBurst entityevokerfangs = new EntitySandBurst(EntitySkeletonKing.this.field_70170_p, EntitySkeletonKing.this.func_70638_az().field_70165_t, EntitySkeletonKing.this.func_70638_az().field_70163_u, EntitySkeletonKing.this.func_70638_az().field_70161_v, 0.0f, 10, (EntityLivingBase)EntitySkeletonKing.this);
            EntitySkeletonKing.this.field_70170_p.func_72838_d((Entity)entityevokerfangs);
        }

        protected int getCastWarmupTime() {
            return 30;
        }

        protected int getCastingTime() {
            return 30;
        }

        protected int getCastingInterval() {
            return 200;
        }

        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return FishItems.ENTITY_SKELETONKING_SPELL_SUMMON;
        }
    }

    public class AICastingApell
    extends EntityAIBase {
        public AICastingApell() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            return EntitySkeletonKing.this.isSpellcasting();
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntitySkeletonKing.this.field_70699_by.func_75499_g();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        public void func_75246_d() {
            if (EntitySkeletonKing.this.func_70638_az() != null) {
                EntitySkeletonKing.this.func_70671_ap().func_75651_a((Entity)EntitySkeletonKing.this.func_70638_az(), (float)EntitySkeletonKing.this.func_184649_cE(), (float)EntitySkeletonKing.this.func_70646_bf());
            }
        }
    }
}

