/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.worldgen;

import com.Fishmod.mod_LavaCow.client.Modconfig;
import com.Fishmod.mod_LavaCow.core.SpawnUtil;
import com.Fishmod.mod_LavaCow.structure.StructureUtil;
import com.Fishmod.mod_LavaCow.util.LootTableHandler;
import com.Fishmod.mod_LavaCow.worldgen.WorldGenAquaMob;
import com.Fishmod.mod_LavaCow.worldgen.WorldGenCemeterySmall;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class StructureGenerator
implements IWorldGenerator {
    public static final WorldGenCemeterySmall CEMETERY_SMALL = new WorldGenCemeterySmall();
    public static final WorldGenAquaMob AQUA_MOB = new WorldGenAquaMob();
    private static final ResourceLocation DESERT_TOMB = new ResourceLocation("mod_lavacow", "desert_tomb");

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        BlockPos pos = world.func_175645_m(new BlockPos(x, 0, z));
        Biome biome = world.getBiomeForCoordsBody(pos);
        if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS) && SpawnUtil.isAllowedDimensionCemetery(world.field_73011_w.getDimension()) && rand.nextInt(Modconfig.SpawnRate_Cemetery + 1) == 0 && world.func_180495_p(pos.func_177977_b()).func_185914_p() && StructureGenerator.isSolidGround(pos.func_177977_b(), world)) {
            CEMETERY_SMALL.func_180709_b(world, rand, pos);
        }
        if (SpawnUtil.isAllowedDimension(world.field_73011_w.getDimension())) {
            AQUA_MOB.func_180709_b(world, rand, pos);
        }
        if (SpawnUtil.isAllowedDimension(world.field_73011_w.getDimension()) && rand.nextInt(Modconfig.SpawnRate_Desert_Tomb + 1) == 0 && world.field_73011_w.func_191066_m() && !world.field_73011_w.func_177495_o() && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) && StructureUtil.CanStructureGenonBlock(world, pos.func_177977_b())) {
            StructureUtil.GenDesertTomb(DESERT_TOMB, LootTableHandler.DESERT_TOMB_CHEST, world, pos.func_177979_c(10));
        }
    }

    private static boolean isSolidGround(BlockPos pos, World world) {
        IBlockState state = world.func_180495_p(pos);
        return !(state.func_177230_c() instanceof BlockLog) && !(state.func_177230_c() instanceof BlockLeaves) && !(state.func_177230_c() instanceof BlockLiquid);
    }
}

