/*
 * Decompiled with CFR 0.152.
 */
package love.marblegate.flowingagony.eventhandler.enchantment;

import java.util.HashSet;
import java.util.Map;
import love.marblegate.flowingagony.capibility.cooldown.CoolDown;
import love.marblegate.flowingagony.capibility.cooldown.CoolDownType;
import love.marblegate.flowingagony.registry.EnchantmentRegistry;
import love.marblegate.flowingagony.util.EnchantmentUtil;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DiceOfFraudEnchantmentEventHandler {
    @SubscribeEvent
    public static void doTricksterEnchantmentEvent(AttackEntityEvent event) {
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getTarget() instanceof LivingEntity) {
            int enchantLvl = EnchantmentUtil.isPlayerItemEnchanted(event.getPlayer(), (Enchantment)EnchantmentRegistry.TRICKSTER.get(), EquipmentSlotType.MAINHAND, EnchantmentUtil.ItemEncCalOp.TOTAL_LEVEL);
            if (enchantLvl == 1) {
                DiceOfFraudEnchantmentEventHandler.appendixEffectForTrickster((LivingEntity)event.getTarget(), ((LivingEntity)event.getTarget()).func_70681_au().nextInt(5) + 1);
            } else if (enchantLvl == 2) {
                int aEffect = ((LivingEntity)event.getTarget()).func_70681_au().nextInt(5) + 1;
                int bEffect = ((LivingEntity)event.getTarget()).func_70681_au().nextInt(5) + 1;
                while (aEffect == bEffect) {
                    bEffect = ((LivingEntity)event.getTarget()).func_70681_au().nextInt(5) + 1;
                }
                DiceOfFraudEnchantmentEventHandler.appendixEffectForTrickster((LivingEntity)event.getTarget(), aEffect);
                DiceOfFraudEnchantmentEventHandler.appendixEffectForTrickster((LivingEntity)event.getTarget(), bEffect);
            }
        }
    }

    static void appendixEffectForTrickster(LivingEntity entity, int diceNum) {
        switch (diceNum) {
            case 1: {
                entity.func_195064_c(new EffectInstance(Effects.field_76436_u, 100));
                break;
            }
            case 2: {
                entity.func_195064_c(new EffectInstance(Effects.field_82731_v, 100));
                break;
            }
            case 3: {
                entity.func_195064_c(new EffectInstance(Effects.field_76437_t, 100));
                break;
            }
            case 4: {
                entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 100));
                break;
            }
            case 5: {
                entity.func_70015_d(5);
            }
        }
    }

    @SubscribeEvent
    public static void doAnEnchantedGoldenAppleADayEnchantmentEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        int enchantNum;
        if (!event.getPlayer().field_70170_p.func_201670_d() && (enchantNum = EnchantmentUtil.isPlayerArmorEnchanted(event.getPlayer(), (Enchantment)EnchantmentRegistry.AN_ENCHANTED_GOLDEN_APPLE_A_DAY.get(), EnchantmentUtil.ArmorEncCalOp.TOTAL_PIECE)) != 0) {
            LazyOptional coolDownCap = event.getEntityLiving().getCapability(CoolDown.COOL_DOWN_CAPABILITY);
            coolDownCap.ifPresent(cap -> {
                if (cap.isReady(CoolDownType.AN_ENCHANTED_GOLDEN_APPLE_A_DAY)) {
                    if (enchantNum == 1) {
                        int tempInt = event.getPlayer().func_70681_au().nextInt(4);
                        switch (tempInt) {
                            case 0: {
                                event.getPlayer().func_195064_c(new EffectInstance(Effects.field_76444_x, 2400, 3));
                                break;
                            }
                            case 1: {
                                event.getPlayer().func_195064_c(new EffectInstance(Effects.field_76428_l, 400, 1));
                                break;
                            }
                            case 2: {
                                event.getPlayer().func_195064_c(new EffectInstance(Effects.field_76426_n, 6000));
                                break;
                            }
                            case 3: {
                                event.getPlayer().func_195064_c(new EffectInstance(Effects.field_76429_m, 6000));
                            }
                        }
                    } else if (enchantNum == 4) {
                        event.getPlayer().func_195064_c(new EffectInstance(Effects.field_76444_x, 2400, 3));
                        event.getPlayer().func_195064_c(new EffectInstance(Effects.field_76428_l, 400, 1));
                        event.getPlayer().func_195064_c(new EffectInstance(Effects.field_76426_n, 6000));
                        event.getPlayer().func_195064_c(new EffectInstance(Effects.field_76429_m, 6000));
                    } else if (enchantNum < 4) {
                        HashSet<Integer> temp = new HashSet<Integer>();
                        int tempCount = enchantNum;
                        while (tempCount > 0) {
                            int tempInt = event.getPlayer().func_70681_au().nextInt(4);
                            if (temp.contains(tempInt)) continue;
                            switch (tempInt) {
                                case 0: {
                                    event.getPlayer().func_195064_c(new EffectInstance(Effects.field_76444_x, 2400, 3));
                                    break;
                                }
                                case 1: {
                                    event.getPlayer().func_195064_c(new EffectInstance(Effects.field_76428_l, 400, 1));
                                    break;
                                }
                                case 2: {
                                    event.getPlayer().func_195064_c(new EffectInstance(Effects.field_76426_n, 6000));
                                    break;
                                }
                                case 3: {
                                    event.getPlayer().func_195064_c(new EffectInstance(Effects.field_76429_m, 6000));
                                }
                            }
                            temp.add(tempInt);
                            --tempCount;
                        }
                    }
                    cap.set(CoolDownType.AN_ENCHANTED_GOLDEN_APPLE_A_DAY, 18000);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void doDeathpunkEnchantmentEvent(LivingDamageEvent event) {
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && !event.isCanceled() && event.getEntityLiving() instanceof PlayerEntity && event.getAmount() >= event.getEntityLiving().func_110143_aJ() && !event.getSource().func_76355_l().equals("outOfWorld") && EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getEntityLiving(), (Enchantment)EnchantmentRegistry.DEATHPUNK.get(), EquipmentSlotType.CHEST, EnchantmentUtil.ItemEncCalOp.GENERAL) == 1) {
            int solution = event.getEntityLiving().func_70681_au().nextInt(4);
            int health = MathHelper.func_76141_d((float)((PlayerEntity)event.getEntityLiving()).func_110143_aJ());
            int maxHealth = MathHelper.func_76141_d((float)((PlayerEntity)event.getEntityLiving()).func_110138_aP());
            boolean damageEnchantment = false;
            switch (solution) {
                case 0: {
                    int foodLevel = ((PlayerEntity)event.getEntityLiving()).func_71024_bL().func_75116_a() + MathHelper.func_76141_d((float)((PlayerEntity)event.getEntityLiving()).func_71024_bL().func_75115_e());
                    if (foodLevel <= health) {
                        damageEnchantment = true;
                        break;
                    }
                    if (foodLevel > maxHealth) {
                        foodLevel = maxHealth;
                    }
                    ((PlayerEntity)event.getEntityLiving()).func_70606_j((float)foodLevel);
                    ((PlayerEntity)event.getEntityLiving()).func_71024_bL().func_75114_a(health);
                    ((PlayerEntity)event.getEntityLiving()).func_71024_bL().func_75113_a(((PlayerEntity)event.getEntityLiving()).func_71024_bL().func_75115_e() * 4.0f);
                    break;
                }
                case 1: {
                    int oxygenLevel = MathHelper.func_76141_d((float)((float)((PlayerEntity)event.getEntityLiving()).func_70086_ai() / ((float)((PlayerEntity)event.getEntityLiving()).func_205010_bg() / (float)maxHealth)));
                    if (oxygenLevel <= health) {
                        damageEnchantment = true;
                        break;
                    }
                    if (oxygenLevel > maxHealth) {
                        oxygenLevel = maxHealth;
                    }
                    event.getEntityLiving().func_70606_j((float)oxygenLevel);
                    event.getEntityLiving().func_70050_g(health * (event.getEntityLiving().func_205010_bg() / maxHealth));
                    break;
                }
                case 2: {
                    int expPoint = ((PlayerEntity)event.getEntityLiving()).field_71067_cb;
                    int exchangeCost = (MathHelper.func_76141_d((float)((PlayerEntity)event.getEntityLiving()).func_110138_aP()) - health) * 30;
                    if (expPoint <= exchangeCost) {
                        damageEnchantment = true;
                        break;
                    }
                    event.getEntityLiving().func_70606_j(event.getEntityLiving().func_110138_aP());
                    ((PlayerEntity)event.getEntityLiving()).func_195068_e(-exchangeCost);
                    break;
                }
                case 3: {
                    damageEnchantment = true;
                }
            }
            if (damageEnchantment) {
                event.getEntityLiving().func_70606_j(((PlayerEntity)event.getEntityLiving()).func_110138_aP());
                Map enchantmentList = EnchantmentHelper.func_82781_a((ItemStack)event.getEntityLiving().func_184582_a(EquipmentSlotType.CHEST));
                enchantmentList.remove(EnchantmentRegistry.DEATHPUNK.get());
                EnchantmentHelper.func_82782_a((Map)enchantmentList, (ItemStack)((PlayerEntity)event.getEntityLiving()).func_184582_a(EquipmentSlotType.CHEST));
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void doSavorTheTastedEnchantmentEvent(LivingDamageEvent event) {
        CompoundNBT weaponNBT;
        int enchantLvl;
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getSource().func_76346_g() instanceof PlayerEntity && (enchantLvl = EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getSource().func_76346_g(), (Enchantment)EnchantmentRegistry.SAVOR_THE_TASTED.get(), EquipmentSlotType.MAINHAND, EnchantmentUtil.ItemEncCalOp.TOTAL_LEVEL)) != 0 && (weaponNBT = ((PlayerEntity)event.getSource().func_76346_g()).func_184614_ca().func_77978_p()) != null && event.getEntityLiving().func_70022_Q() != null) {
            if (!weaponNBT.func_74764_b("savor_the_tasted_target")) {
                weaponNBT.func_74778_a("savor_the_tasted_target", event.getEntityLiving().func_70022_Q());
            } else {
                String recordedTarget = weaponNBT.func_74779_i("savor_the_tasted_target");
                if (recordedTarget.equals(event.getEntityLiving().func_70022_Q())) {
                    float modifiedDamage = event.getAmount() + (float)event.getEntityLiving().func_70681_au().nextInt(5) + (float)(enchantLvl * 4) - 1.0f;
                    event.setAmount(modifiedDamage);
                } else {
                    weaponNBT.func_74778_a("savor_the_tasted_target", event.getEntityLiving().func_70022_Q());
                }
            }
            ((PlayerEntity)event.getSource().func_76346_g()).func_184614_ca().func_77982_d(weaponNBT);
        }
    }

    @SubscribeEvent
    public static void doExoticHealerEnchantmentEvent(LivingHealEvent event) {
        int enchantmentLvl;
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getEntityLiving() instanceof PlayerEntity && (enchantmentLvl = EnchantmentUtil.isPlayerArmorEnchanted((PlayerEntity)event.getEntityLiving(), (Enchantment)EnchantmentRegistry.EXOTIC_HEALER.get(), EnchantmentUtil.ArmorEncCalOp.TOTAL_LEVEL)) != 0) {
            int dice = event.getEntityLiving().func_70681_au().nextInt(100);
            float modifier = 1.0f + (float)(enchantmentLvl - 1) * 0.1f;
            if (dice < 33) {
                event.setCanceled(true);
            } else if (dice < 66) {
                event.setAmount(event.getAmount() * 2.0f * modifier);
            } else if (dice < 90) {
                event.setAmount(event.getAmount() * 3.0f * modifier);
            } else if (dice < 91) {
                event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76420_g, (int)(600.0f * modifier)));
            } else if (dice < 92) {
                event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76424_c, (int)(600.0f * modifier)));
            } else if (dice < 93) {
                event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76428_l, (int)(600.0f * modifier)));
            } else if (dice < 94) {
                event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76441_p, (int)(600.0f * modifier)));
            } else if (dice < 95) {
                event.getEntityLiving().func_70097_a(new DamageSource("flowingagony.exotic_healer"), event.getAmount() * modifier);
                event.setCanceled(true);
            }
        }
    }
}

