/*
 * Decompiled with CFR 0.152.
 */
package love.marblegate.flowingagony.eventhandler.enchantment;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import love.marblegate.flowingagony.config.Configuration;
import love.marblegate.flowingagony.registry.EnchantmentRegistry;
import love.marblegate.flowingagony.util.EnchantmentUtil;
import love.marblegate.flowingagony.util.EntityUtil;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.GossipType;
import net.minecraft.world.World;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class GloomyEraEnchantmentEventHandler {
    @SubscribeEvent
    public static void doRegularCustomerProgramEnchantmentEvent(LivingDeathEvent event) {
        List<LivingEntity> targets;
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getSource().func_76346_g() instanceof PlayerEntity && (event.getEntityLiving() instanceof ZombieVillagerEntity || event.getEntityLiving() instanceof WitchEntity) && EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getSource().func_76346_g(), (Enchantment)EnchantmentRegistry.REGULAR_CUSTOMER_PROGRAM.get(), EquipmentSlotType.MAINHAND, EnchantmentUtil.ItemEncCalOp.GENERAL) == 1 && !(targets = EntityUtil.getTargetsExceptOneself(event.getEntityLiving(), 12.0f, 2.0f, livingEntity -> livingEntity instanceof VillagerEntity)).isEmpty()) {
            for (LivingEntity target : targets) {
                ((VillagerEntity)target).func_223722_es().func_220916_a(((PlayerEntity)event.getSource().func_76346_g()).func_110124_au(), GossipType.MINOR_POSITIVE, 1);
            }
        }
    }

    @SubscribeEvent
    public static void doCleansingBeforeUsingEnchantmentEvent(LivingDeathEvent event) {
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getSource().func_76346_g() instanceof PlayerEntity && event.getEntityLiving() instanceof VillagerEntity && EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getSource().func_76346_g(), (Enchantment)EnchantmentRegistry.CLEANSING_BEFORE_USING.get(), EquipmentSlotType.MAINHAND, EnchantmentUtil.ItemEncCalOp.GENERAL) == 1) {
            event.getEntityLiving().func_184586_b(Hand.MAIN_HAND).func_82841_c(0);
            if (event.getEntityLiving().func_184586_b(Hand.MAIN_HAND).func_77984_f()) {
                event.getEntityLiving().func_184586_b(Hand.MAIN_HAND).func_196085_b(event.getEntityLiving().func_184586_b(Hand.MAIN_HAND).func_77952_i() - 10);
            }
        }
    }

    @SubscribeEvent
    public static void doComeBackAtDuskEnchantmentEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.player.field_70170_p.func_201670_d() && EnchantmentUtil.isPlayerArmorEnchanted(event.player, (Enchantment)EnchantmentRegistry.DIRTY_MONEY.get(), EnchantmentUtil.ArmorEncCalOp.GENERAL) == 0 && event.player.field_70170_p.func_72820_D() % 24000L > 10999L && event.player.field_70170_p.func_72820_D() % 24000L < 13501L && EnchantmentUtil.isPlayerArmorEnchanted(event.player, (Enchantment)EnchantmentRegistry.COME_BACK_AT_DUSK.get(), EnchantmentUtil.ArmorEncCalOp.GENERAL) == 1 && !event.player.func_70644_a(Effects.field_220310_F)) {
            double temp = Math.random();
            int amplifier = temp < 0.9 ? 0 : (temp < 0.95 ? 1 : (temp < 0.98 ? 2 : (temp < 0.99 ? 3 : 4)));
            event.player.func_195064_c(new EffectInstance(Effects.field_220310_F, 300, amplifier));
        }
    }

    @SubscribeEvent
    public static void doDirtyMoneyEnchantmentEvent_preventHOTVEffect(PotionEvent.PotionApplicableEvent event) {
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getEntityLiving() instanceof PlayerEntity && event.getPotionEffect().func_188419_a().equals(Effects.field_220310_F) && EnchantmentUtil.isPlayerArmorEnchanted((PlayerEntity)event.getEntityLiving(), (Enchantment)EnchantmentRegistry.DIRTY_MONEY.get(), EnchantmentUtil.ArmorEncCalOp.GENERAL) == 1) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void doDirtyMoneyEnchantmentEvent_dropGoods(LivingDeathEvent event) {
        int enchantLvl;
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getEntityLiving() instanceof VillagerEntity && event.getSource().func_76346_g() instanceof PlayerEntity && (enchantLvl = EnchantmentUtil.isPlayerArmorEnchanted((PlayerEntity)event.getSource().func_76346_g(), (Enchantment)EnchantmentRegistry.DIRTY_MONEY.get(), EnchantmentUtil.ArmorEncCalOp.HIGHEST_LEVEL)) != 0) {
            if (Math.random() < 0.1 * (double)enchantLvl) {
                InventoryHelper.func_180173_a((World)event.getEntityLiving().field_70170_p, (double)event.getEntityLiving().func_226277_ct_(), (double)(event.getEntityLiving().func_226278_cu_() + 2.0), (double)event.getEntityLiving().func_226281_cx_(), (ItemStack)Items.field_151166_bC.func_190903_i());
            }
            if (Math.random() < 0.02 * (double)enchantLvl) {
                InventoryHelper.func_180173_a((World)event.getEntityLiving().field_70170_p, (double)event.getEntityLiving().func_226277_ct_(), (double)(event.getEntityLiving().func_226278_cu_() + 2.0), (double)event.getEntityLiving().func_226281_cx_(), (ItemStack)Items.field_151043_k.func_190903_i());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void doPilferageCreedEnchantmentEvent(LivingFallEvent event) {
        List<LivingEntity> targets;
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getEntityLiving() instanceof PlayerEntity && EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getEntityLiving(), (Enchantment)EnchantmentRegistry.PILFERAGE_CREED.get(), EquipmentSlotType.FEET, EnchantmentUtil.ItemEncCalOp.GENERAL) == 1 && event.getDistance() >= 5.0f && !(targets = EntityUtil.getTargetsExceptOneself((PlayerEntity)event.getEntityLiving(), 5.0f, 1.0f, LivingEntity2 -> LivingEntity2 instanceof VillagerEntity)).isEmpty()) {
            targets.forEach(LivingEntity2 -> {
                MerchantOffers offers = ((VillagerEntity)LivingEntity2).func_213706_dY();
                if (!offers.isEmpty()) {
                    List<ItemStack> outcome = GloomyEraEnchantmentEventHandler.rollDiceForPilferage(event.getEntityLiving().func_184582_a(EquipmentSlotType.FEET), (VillagerEntity)LivingEntity2, (List<MerchantOffer>)offers, event.getEntityLiving().func_70681_au(), event.getDistance());
                    outcome.forEach(ItemStack2 -> LivingEntity2.field_70170_p.func_217376_c((Entity)new ItemEntity(LivingEntity2.field_70170_p, LivingEntity2.func_226277_ct_(), LivingEntity2.func_226278_cu_(), LivingEntity2.func_226281_cx_(), ItemStack2)));
                }
            });
        }
    }

    static List<ItemStack> rollDiceForPilferage(ItemStack armorFeet, VillagerEntity villagerEntity, List<MerchantOffer> offers, Random random, double fallingHeight) {
        int temp;
        int extraluck = MathHelper.func_76128_c((double)fallingHeight);
        extraluck = Math.min(extraluck, 15);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        boolean success = false;
        if (random.nextInt(100) < 30 + 5 * (extraluck -= 5)) {
            temp = random.nextInt(offers.size());
            itemStacks.add(offers.get(temp).func_222200_d().func_77946_l());
            success = true;
        }
        if ((float)random.nextInt(100) < 15.0f + 2.5f * (float)extraluck && offers.size() > 3) {
            temp = random.nextInt(offers.size());
            itemStacks.add(offers.get(temp).func_222200_d().func_77946_l());
            success = true;
        }
        if ((float)random.nextInt(100) < 5.0f + 1.5f * (float)extraluck && offers.size() > 5) {
            temp = random.nextInt(offers.size());
            itemStacks.add(offers.get(temp).func_222200_d().func_77946_l());
            success = true;
        }
        if (random.nextInt(100) < 30 + 5 * extraluck && !((Boolean)Configuration.GeneralSetting.VILLAGER_SAFE_MODE.get()).booleanValue()) {
            villagerEntity.func_70097_a(DamageSource.field_76377_j, 1.0f + (float)extraluck * 0.5f);
        }
        if (success && !armorFeet.equals(ItemStack.field_190927_a)) {
            armorFeet.func_222118_a(30, (LivingEntity)villagerEntity, x -> {});
        }
        return itemStacks;
    }

    @SubscribeEvent
    public static void doCarefullyIdentifiedEnchantmentEvent(BlockEvent.BreakEvent event) {
        if (!event.getWorld().func_201670_d() && !event.isCanceled() && event.getState().func_177230_c() == Blocks.field_150348_b) {
            int enchantmentLvl = EnchantmentUtil.isPlayerItemEnchanted(event.getPlayer(), (Enchantment)EnchantmentRegistry.CAREFULLY_IDENTIFIED.get(), EquipmentSlotType.MAINHAND, EnchantmentUtil.ItemEncCalOp.TOTAL_LEVEL);
            int silkTouchEnchantmentLvl = EnchantmentUtil.isPlayerItemEnchanted(event.getPlayer(), Enchantments.field_185306_r, EquipmentSlotType.MAINHAND, EnchantmentUtil.ItemEncCalOp.GENERAL);
            int fortuneEnchantmentLvl = EnchantmentUtil.isPlayerItemEnchanted(event.getPlayer(), Enchantments.field_185308_t, EquipmentSlotType.MAINHAND, EnchantmentUtil.ItemEncCalOp.GENERAL);
            if (enchantmentLvl != 0) {
                if (enchantmentLvl < 2 && Math.random() < 0.01) {
                    ItemStack coal;
                    ItemStack itemStack = coal = silkTouchEnchantmentLvl == 1 ? Items.field_221553_F.func_190903_i() : Items.field_151044_h.func_190903_i();
                    if (fortuneEnchantmentLvl == 1 && Math.random() < 0.5) {
                        coal.func_190917_f(1);
                    }
                    InventoryHelper.func_180173_a((World)((World)event.getWorld()), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), (ItemStack)coal);
                }
                if (enchantmentLvl < 3 && Math.random() < 0.005) {
                    ItemStack iron = Items.field_221552_E.func_190903_i();
                    if (fortuneEnchantmentLvl == 1 && Math.random() < 0.5) {
                        iron.func_190917_f(1);
                    }
                    InventoryHelper.func_180173_a((World)((World)event.getWorld()), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), (ItemStack)iron);
                }
                if (enchantmentLvl < 4) {
                    if (Math.random() < 0.001) {
                        ItemStack gold = Items.field_221551_D.func_190903_i();
                        if (fortuneEnchantmentLvl == 1 && Math.random() < 0.5) {
                            gold.func_190917_f(1);
                        }
                        InventoryHelper.func_180173_a((World)((World)event.getWorld()), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), (ItemStack)gold);
                    }
                    if (Math.random() < 0.002) {
                        ItemStack redstone;
                        ItemStack itemStack = redstone = silkTouchEnchantmentLvl == 1 ? Items.field_221762_cq.func_190903_i() : Items.field_151137_ax.func_190903_i();
                        if (fortuneEnchantmentLvl == 1 && Math.random() < 0.5) {
                            redstone.func_190917_f(1);
                        }
                        InventoryHelper.func_180173_a((World)((World)event.getWorld()), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), (ItemStack)redstone);
                    }
                }
                if (enchantmentLvl < 5 && Math.random() < 0.001) {
                    ItemStack lapis;
                    ItemStack itemStack = lapis = silkTouchEnchantmentLvl == 1 ? Items.field_221652_an.func_190903_i() : Items.field_196128_bn.func_190903_i();
                    if (fortuneEnchantmentLvl == 1 && Math.random() < 0.5) {
                        lapis.func_190917_f(1);
                    }
                    InventoryHelper.func_180173_a((World)((World)event.getWorld()), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), (ItemStack)lapis);
                }
                if (enchantmentLvl < 6) {
                    if (Math.random() < 0.001) {
                        ItemStack emerald;
                        ItemStack itemStack = emerald = silkTouchEnchantmentLvl == 1 ? Items.field_221733_dC.func_190903_i() : Items.field_151166_bC.func_190903_i();
                        if (fortuneEnchantmentLvl == 1 && Math.random() < 0.5) {
                            emerald.func_190917_f(1);
                        }
                        InventoryHelper.func_180173_a((World)((World)event.getWorld()), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), (ItemStack)emerald);
                    }
                    if (Math.random() < 0.001) {
                        ItemStack diamond;
                        ItemStack itemStack = diamond = silkTouchEnchantmentLvl == 1 ? Items.field_221730_ca.func_190903_i() : Items.field_151045_i.func_190903_i();
                        if (fortuneEnchantmentLvl == 1 && Math.random() < 0.5) {
                            diamond.func_190917_f(1);
                        }
                        InventoryHelper.func_180173_a((World)((World)event.getWorld()), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), (ItemStack)diamond);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void doNimbleFingerEnchantmentEvent(AnvilUpdateEvent event) {
        if (!((Boolean)Configuration.CompatibilitySetting.HYBRID_SERVER_USER.get()).booleanValue() && !event.getPlayer().field_70170_p.func_201670_d() && EnchantmentUtil.isItemEnchanted(event.getLeft(), (Enchantment)EnchantmentRegistry.NIMBLE_FINGER.get()) == 1 && event.getLeft().func_77952_i() == 0 && GloomyEraEnchantmentEventHandler.isSameCategory(event.getLeft().func_77973_b(), event.getRight().func_77973_b())) {
            ItemStack result = event.getLeft().func_77946_l();
            Map left = EnchantmentHelper.func_82781_a((ItemStack)result);
            Map right = EnchantmentHelper.func_82781_a((ItemStack)event.getRight());
            LinkedHashMap output = Maps.newLinkedHashMap();
            for (Enchantment lEnchantment : left.keySet()) {
                if (lEnchantment == EnchantmentRegistry.NIMBLE_FINGER.get()) continue;
                output.put(lEnchantment, left.get(lEnchantment));
            }
            for (Enchantment rEnchantment : right.keySet()) {
                boolean compatible = true;
                for (Enchantment lEnchantment : left.keySet()) {
                    if (!rEnchantment.func_191560_c(lEnchantment)) {
                        compatible = false;
                    }
                    if (rEnchantment != lEnchantment || (Integer)right.get(rEnchantment) <= (Integer)left.get(lEnchantment)) continue;
                    output.replace(rEnchantment, right.get(rEnchantment));
                }
                if (!compatible) continue;
                output.put(rEnchantment, right.get(rEnchantment));
            }
            EnchantmentHelper.func_82782_a((Map)output, (ItemStack)result);
            event.setCost(event.getLeft().func_82838_A() + event.getRight().func_82838_A() + 1);
            event.setOutput(result);
        }
    }

    static boolean isSameCategory(Item lItem, Item rItem) {
        if (lItem instanceof SwordItem) {
            return rItem instanceof SwordItem;
        }
        if (lItem instanceof AxeItem) {
            return rItem instanceof AxeItem;
        }
        if (lItem instanceof HoeItem) {
            return rItem instanceof HoeItem;
        }
        if (lItem instanceof PickaxeItem) {
            return rItem instanceof PickaxeItem;
        }
        if (lItem instanceof ShovelItem) {
            return rItem instanceof ShovelItem;
        }
        if (lItem instanceof ArmorItem) {
            if (rItem instanceof ArmorItem) {
                return ((ArmorItem)lItem).func_185083_B_() == ((ArmorItem)rItem).func_185083_B_();
            }
            return false;
        }
        return false;
    }
}

