/*
 * Decompiled with CFR 0.152.
 */
package love.marblegate.flowingagony.eventhandler.enchantment;

import java.util.List;
import love.marblegate.flowingagony.config.Configuration;
import love.marblegate.flowingagony.damagesource.CustomDamageSource;
import love.marblegate.flowingagony.registry.EffectRegistry;
import love.marblegate.flowingagony.registry.EnchantmentRegistry;
import love.marblegate.flowingagony.util.EnchantmentUtil;
import love.marblegate.flowingagony.util.EntityUtil;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ToolItem;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MadeOfMadnessEnchantmentEventHandler {
    @SubscribeEvent
    public static void onAgonyScreamerEnchantmentEven(LivingDamageEvent event) {
        int enchantmentLvl;
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getSource().func_76346_g() instanceof PlayerEntity && (enchantmentLvl = EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getSource().func_76346_g(), (Enchantment)EnchantmentRegistry.AGONY_SCREAMER.get(), EquipmentSlotType.MAINHAND, EnchantmentUtil.ItemEncCalOp.TOTAL_LEVEL)) != 0) {
            event.getEntityLiving().func_195064_c(new EffectInstance((Effect)EffectRegistry.AGONY_RESONANCE.get(), 140 + 20 * enchantmentLvl, enchantmentLvl));
        }
    }

    @SubscribeEvent
    public static void onInsanePoetEnchantmentEven(LivingDamageEvent event) {
        int enchantmentLvl;
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getSource().func_76346_g() instanceof PlayerEntity && (enchantmentLvl = EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getSource().func_76346_g(), (Enchantment)EnchantmentRegistry.INSANE_POET.get(), EquipmentSlotType.MAINHAND, EnchantmentUtil.ItemEncCalOp.TOTAL_LEVEL)) != 0) {
            event.getEntityLiving().func_195064_c(new EffectInstance((Effect)EffectRegistry.LISTEN_TO_ME_SINGING.get(), enchantmentLvl * 40, enchantmentLvl - 1));
            ((PlayerEntity)event.getSource().func_76346_g()).func_195064_c(new EffectInstance((Effect)EffectRegistry.INSANE_POET_ENCHANTMENT_ACTIVE.get(), enchantmentLvl * 40));
            event.setAmount((float)((double)event.getAmount() * (1.0 - (Double)Configuration.GeneralSetting.INSANE_POET_DAMAGE_REDUCTION.get())));
        }
    }

    @SubscribeEvent
    public static void onPaperBrainEnchantmentEven(LivingDamageEvent event) {
        int enchantLvl;
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getSource().func_76346_g() instanceof PlayerEntity && (enchantLvl = EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getSource().func_76346_g(), (Enchantment)EnchantmentRegistry.PAPER_BRAIN.get(), EquipmentSlotType.MAINHAND, EnchantmentUtil.ItemEncCalOp.TOTAL_LEVEL)) != 0) {
            event.getEntityLiving().func_195064_c(new EffectInstance((Effect)EffectRegistry.PAPER_BRAIN_ENCHANTMENT_ACTIVE.get(), 20 + 40 * enchantLvl, enchantLvl - 1));
            event.setAmount((float)((double)event.getAmount() * (1.0 - (Double)Configuration.GeneralSetting.PAPER_BRAIN_DAMAGE_REDUCTION.get())));
        }
    }

    @SubscribeEvent
    public static void onShockTherapyEnchantmentEven(LivingDamageEvent event) {
        int enchantLvl;
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getSource().func_76346_g() instanceof PlayerEntity && (enchantLvl = EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getSource().func_76346_g(), (Enchantment)EnchantmentRegistry.SHOCK_THERAPY.get(), EquipmentSlotType.MAINHAND, EnchantmentUtil.ItemEncCalOp.TOTAL_LEVEL)) != 0) {
            event.getEntityLiving().func_195064_c(new EffectInstance((Effect)EffectRegistry.SHOCK_THERAPY_ENCHANTMENT_ACTIVE.get(), 20 + 40 * enchantLvl, enchantLvl - 1));
            event.setAmount((float)((double)event.getAmount() * (1.0 - (Double)Configuration.GeneralSetting.SHOCK_THERAPY_DAMAGE_REDUCTION.get())));
        }
    }

    @SubscribeEvent
    public static void onCuttingWatermelonDreamEnchantmentEvent_dealDamage(BlockEvent.BreakEvent event) {
        List<LivingEntity> targets;
        if (!event.getPlayer().field_70170_p.func_201670_d() && event.getState().func_177230_c().equals(Blocks.field_150440_ba) && EnchantmentUtil.isPlayerItemEnchanted(event.getPlayer(), (Enchantment)EnchantmentRegistry.CUTTING_WATERMELON_DREAM.get(), EquipmentSlotType.MAINHAND, EnchantmentUtil.ItemEncCalOp.GENERAL) == 1 && !(targets = EntityUtil.getTargetsExceptOneself(event.getPlayer(), 12.0f, 2.0f, livingEntity -> EntityUtil.isHostile(livingEntity, false))).isEmpty()) {
            int silkTouchEnchantmentLvl = EnchantmentUtil.isPlayerItemEnchanted(event.getPlayer(), Enchantments.field_185306_r, EquipmentSlotType.MAINHAND, EnchantmentUtil.ItemEncCalOp.GENERAL);
            int unbreakingEnchantmentLvl = EnchantmentUtil.isPlayerItemEnchanted(event.getPlayer(), Enchantments.field_185307_s, EquipmentSlotType.MAINHAND, EnchantmentUtil.ItemEncCalOp.TOTAL_LEVEL);
            float damage = 0.0f;
            if (event.getPlayer().func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b() instanceof ToolItem) {
                damage += ((ToolItem)event.getPlayer().func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b()).func_234675_d_();
            }
            if (silkTouchEnchantmentLvl == 1) {
                damage = (float)((double)damage * 0.5);
            }
            damage = event.getPlayer().field_70170_p.func_72820_D() % 24000L > 13000L ? (float)((double)damage * (4.0 + event.getPlayer().func_70681_au().nextDouble() * 2.0)) : (float)((double)damage * (2.0 + event.getPlayer().func_70681_au().nextDouble()));
            for (LivingEntity target : targets) {
                target.func_70097_a(CustomDamageSource.causeCuttingWaterMelonDream((LivingEntity)event.getPlayer()), damage);
            }
            int damageAppliedToItem = 5;
            if (unbreakingEnchantmentLvl != 0) {
                damageAppliedToItem = unbreakingEnchantmentLvl == 3 ? 3 : 4;
            }
            event.getPlayer().func_184582_a(EquipmentSlotType.MAINHAND).func_222118_a(damageAppliedToItem, (LivingEntity)event.getPlayer(), x -> {});
        }
    }

    @SubscribeEvent
    public static void onCuttingWatermelonDreamEnchantmentEvent_dropHeadAndExtraLoot(LivingDeathEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && !event.isCanceled() && event.getSource().func_76355_l().equals("flowingagony.cutting_watermelon_dream") && event.getSource().func_76346_g() instanceof PlayerEntity && EntityUtil.supportHeadDrop(event.getEntityLiving()) && EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getSource().func_76346_g(), (Enchantment)EnchantmentRegistry.CUTTING_WATERMELON_DREAM.get(), EquipmentSlotType.MAINHAND, EnchantmentUtil.ItemEncCalOp.GENERAL) == 1) {
            int silkTouchEnchantmentLvl = EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getSource().func_76346_g(), Enchantments.field_185306_r, EquipmentSlotType.MAINHAND, EnchantmentUtil.ItemEncCalOp.GENERAL);
            int fortuneEnchantmentLvl = EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getSource().func_76346_g(), Enchantments.field_185308_t, EquipmentSlotType.MAINHAND, EnchantmentUtil.ItemEncCalOp.TOTAL_LEVEL);
            if (silkTouchEnchantmentLvl > 0) {
                double dropHeadRate = 0.025 + 0.01 * (double)fortuneEnchantmentLvl;
                if (Math.random() < dropHeadRate) {
                    if (event.getEntityLiving() instanceof ZombieEntity) {
                        InventoryHelper.func_180173_a((World)event.getEntityLiving().field_70170_p, (double)event.getEntityLiving().func_226277_ct_(), (double)event.getEntityLiving().func_226278_cu_(), (double)event.getEntityLiving().func_226281_cx_(), (ItemStack)Items.field_196186_dz.func_190903_i());
                    } else if (event.getEntityLiving() instanceof SkeletonEntity) {
                        InventoryHelper.func_180173_a((World)event.getEntityLiving().field_70170_p, (double)event.getEntityLiving().func_226277_ct_(), (double)event.getEntityLiving().func_226278_cu_(), (double)event.getEntityLiving().func_226281_cx_(), (ItemStack)Items.field_196182_dv.func_190903_i());
                    } else if (event.getEntityLiving() instanceof CreeperEntity) {
                        InventoryHelper.func_180173_a((World)event.getEntityLiving().field_70170_p, (double)event.getEntityLiving().func_226277_ct_(), (double)event.getEntityLiving().func_226278_cu_(), (double)event.getEntityLiving().func_226281_cx_(), (ItemStack)Items.field_196185_dy.func_190903_i());
                    } else if (event.getEntityLiving() instanceof WitherSkeletonEntity) {
                        InventoryHelper.func_180173_a((World)event.getEntityLiving().field_70170_p, (double)event.getEntityLiving().func_226277_ct_(), (double)event.getEntityLiving().func_226278_cu_(), (double)event.getEntityLiving().func_226281_cx_(), (ItemStack)Items.field_196183_dw.func_190903_i());
                    } else if (event.getEntityLiving() instanceof EnderDragonEntity) {
                        InventoryHelper.func_180173_a((World)event.getEntityLiving().field_70170_p, (double)event.getEntityLiving().func_226277_ct_(), (double)event.getEntityLiving().func_226278_cu_(), (double)event.getEntityLiving().func_226281_cx_(), (ItemStack)Items.field_196151_dA.func_190903_i());
                    }
                }
            }
            if (fortuneEnchantmentLvl > 0) {
                MadeOfMadnessEnchantmentEventHandler.dropLoot(event.getEntityLiving(), (PlayerEntity)event.getSource().func_76346_g(), DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)event.getSource().func_76346_g())), fortuneEnchantmentLvl);
            }
        }
    }

    protected static void dropLoot(LivingEntity livingEntity, PlayerEntity playerEntity, DamageSource damageSourceIn, int lootLevel) {
        ResourceLocation resourcelocation = livingEntity.func_213346_cF();
        LootTable loottable = livingEntity.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(resourcelocation);
        LootContext.Builder lootcontext$builder = MadeOfMadnessEnchantmentEventHandler.getLootContextBuilder(livingEntity, playerEntity, damageSourceIn);
        LootContext ctx = lootcontext$builder.func_216022_a(LootParameterSets.field_216263_d);
        loottable.func_216113_a(ctx).forEach(itemStack -> {
            itemStack = MadeOfMadnessEnchantmentEventHandler.recalculateLootByLootingLevel(itemStack, ctx, lootLevel);
            livingEntity.func_199701_a_(itemStack);
        });
    }

    public static ItemStack recalculateLootByLootingLevel(ItemStack stack, LootContext context, int lootLevel) {
        float f = (float)lootLevel * RandomValueRange.func_215837_a((float)0.0f, (float)1.0f).func_186507_b(context.func_216032_b());
        stack.func_190917_f(Math.round(f));
        return stack;
    }

    protected static LootContext.Builder getLootContextBuilder(LivingEntity livingEntity, PlayerEntity playerEntity, DamageSource damageSourceIn) {
        LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)livingEntity.field_70170_p).func_216023_a(livingEntity.func_70681_au()).func_216015_a(LootParameters.field_216281_a, (Object)livingEntity).func_216015_a(LootParameters.field_237457_g_, (Object)livingEntity.func_213303_ch()).func_216015_a(LootParameters.field_216283_c, (Object)damageSourceIn).func_216021_b(LootParameters.field_216284_d, (Object)damageSourceIn.func_76346_g()).func_216021_b(LootParameters.field_216285_e, (Object)damageSourceIn.func_76364_f());
        lootcontext$builder = lootcontext$builder.func_216015_a(LootParameters.field_216282_b, (Object)playerEntity).func_186469_a(playerEntity.func_184817_da());
        return lootcontext$builder;
    }
}

