/*
 * Decompiled with CFR 0.152.
 */
package love.marblegate.flowingagony.eventhandler.enchantment;

import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import love.marblegate.flowingagony.config.Config;
import love.marblegate.flowingagony.damagesource.CustomDamageSource;
import love.marblegate.flowingagony.network.Networking;
import love.marblegate.flowingagony.network.packet.RemoveEffectSyncToClientPacket;
import love.marblegate.flowingagony.registry.EffectRegistry;
import love.marblegate.flowingagony.registry.EnchantmentRegistry;
import love.marblegate.flowingagony.util.EffectUtil;
import love.marblegate.flowingagony.util.EnchantmentUtil;
import love.marblegate.flowingagony.util.EntityUtil;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber
public class TheMistakensEnchantmentEventHandler {
    @SubscribeEvent
    public static void doShadowbornEnchantmentEvent_applyAndRemoveEffect(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.player.field_70170_p.func_201670_d()) {
            if (event.player.func_70644_a(Effects.field_76440_q) && event.player.field_70170_p.func_201696_r(new BlockPos((Vec3i)event.player.func_180425_c())) >= 5 && EnchantmentUtil.isPlayerItemEnchanted(event.player, (Enchantment)EnchantmentRegistry.SHADOWBORN.get(), EquipmentSlotType.HEAD, EnchantmentUtil.ItemEncCalOp.GENERAL) == 1) {
                event.player.func_184596_c(Effects.field_76440_q);
                Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.player), (Object)new RemoveEffectSyncToClientPacket(Effects.field_76440_q));
            }
            if (event.player.field_70170_p.func_201696_r(new BlockPos((Vec3i)event.player.func_180425_c())) <= 5 && EnchantmentUtil.isPlayerItemEnchanted(event.player, (Enchantment)EnchantmentRegistry.SHADOWBORN.get(), EquipmentSlotType.HEAD, EnchantmentUtil.ItemEncCalOp.GENERAL) == 1 && !event.player.func_70644_a(Effects.field_76439_r)) {
                event.player.func_195064_c(new EffectInstance(Effects.field_76439_r, 1200));
            }
        }
    }

    @SubscribeEvent
    public static void doShadowBornEnchantmentEvent_addImmunity(PotionEvent.PotionApplicableEvent event) {
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getResult() != Event.Result.DENY && event.getEntityLiving() instanceof PlayerEntity && EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getEntityLiving(), (Enchantment)EnchantmentRegistry.SHADOWBORN.get(), EquipmentSlotType.HEAD, EnchantmentUtil.ItemEncCalOp.GENERAL) == 1 && event.getEntityLiving().field_70170_p.func_201696_r(new BlockPos((Vec3i)event.getEntityLiving().func_180425_c())) >= 5 && event.getPotionEffect().func_188419_a() == Effects.field_76440_q) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void doPrototypeChaoticEnchantmentEvent(PotionEvent.PotionAddedEvent event) {
        int enchantLvl;
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getEntityLiving() instanceof PlayerEntity && (enchantLvl = EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getEntityLiving(), (Enchantment)EnchantmentRegistry.PROTOTYPE_CHAOTIC.get(), EquipmentSlotType.CHEST, EnchantmentUtil.ItemEncCalOp.TOTAL_LEVEL)) != 0 && EffectUtil.isEffectShown(event.getPotionEffect())) {
            if (((PlayerEntity)event.getEntityLiving()).func_70644_a((Effect)EffectRegistry.PROTOTYPE_CHAOTIC_ENCHANTMENT_ACTIVE.get())) {
                int newEffectAmplifier = Math.min(((PlayerEntity)event.getEntityLiving()).func_70660_b((Effect)EffectRegistry.PROTOTYPE_CHAOTIC_ENCHANTMENT_ACTIVE.get()).func_76458_c() + enchantLvl, 29);
                ((PlayerEntity)event.getEntityLiving()).func_195064_c(new EffectInstance((Effect)EffectRegistry.PROTOTYPE_CHAOTIC_ENCHANTMENT_ACTIVE.get(), 1200, newEffectAmplifier));
            } else {
                ((PlayerEntity)event.getEntityLiving()).func_195064_c(new EffectInstance((Effect)EffectRegistry.PROTOTYPE_CHAOTIC_ENCHANTMENT_ACTIVE.get(), 1200, enchantLvl - 1));
            }
            ((PlayerEntity)event.getEntityLiving()).func_70691_i((float)enchantLvl);
        }
    }

    @SubscribeEvent
    public static void doPrototypeChaoticTypeBetaEnchantmentEvent(PotionEvent.PotionAddedEvent event) {
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getEntityLiving() instanceof PlayerEntity && EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getEntityLiving(), (Enchantment)EnchantmentRegistry.PROTOTYPE_CHAOTIC_TYPE_BETA.get(), EquipmentSlotType.CHEST, EnchantmentUtil.ItemEncCalOp.GENERAL) == 1 && EffectUtil.isEffectShown(event.getPotionEffect()) && event.getPotionEffect().func_188419_a().func_220303_e() == EffectType.BENEFICIAL && !event.getPotionEffect().func_188419_a().func_76403_b()) {
            if (EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getEntityLiving(), (Enchantment)EnchantmentRegistry.PROTOTYPE_CHAOTIC.get(), EquipmentSlotType.CHEST, EnchantmentUtil.ItemEncCalOp.GENERAL) == 1) {
                event.getPotionEffect().func_199308_a(new EffectInstance(event.getPotionEffect().func_188419_a(), event.getPotionEffect().func_76459_b() * 3));
                List negativeEffects = ((PlayerEntity)event.getEntityLiving()).func_70651_bq().stream().filter(effectInstance -> effectInstance.func_188419_a().func_220303_e() == EffectType.HARMFUL).filter(effectInstance -> effectInstance.isCurativeItem(new ItemStack((IItemProvider)Items.field_151117_aB))).filter(EffectUtil::isEffectShown).collect(Collectors.toList());
                if (!negativeEffects.isEmpty()) {
                    for (EffectInstance effect : negativeEffects) {
                        ((PlayerEntity)event.getEntityLiving()).func_195063_d(effect.func_188419_a());
                        Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getEntityLiving()), (Object)new RemoveEffectSyncToClientPacket(effect.func_188419_a()));
                    }
                }
            } else {
                event.getPotionEffect().func_199308_a(new EffectInstance(event.getPotionEffect().func_188419_a(), event.getPotionEffect().func_76459_b() * 2));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void doCorruptedKindredEnchantmentEvent(LivingDamageEvent event) {
        int enchantLvl;
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getEntityLiving() instanceof PlayerEntity && event.getSource().func_76346_g() instanceof LivingEntity && !event.isCanceled() && (enchantLvl = EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getEntityLiving(), (Enchantment)EnchantmentRegistry.CORRUPTED_KINDRED.get(), EquipmentSlotType.CHEST, EnchantmentUtil.ItemEncCalOp.TOTAL_LEVEL)) != 0 && EntityUtil.isAggresiveUndead((LivingEntity)event.getSource().func_76346_g())) {
            Random temp = event.getEntityLiving().func_70681_au();
            if (temp.nextInt(100) < 6 - enchantLvl) {
                ((PlayerEntity)event.getEntityLiving()).func_195064_c(new EffectInstance((Effect)EffectRegistry.CURSE_OF_UNDEAD.get(), 144000));
            }
            if (EntityUtil.isCommonUndead((LivingEntity)event.getSource().func_76346_g())) {
                if (enchantLvl == 5) {
                    event.setCanceled(true);
                } else {
                    event.setAmount(event.getAmount() * (1.0f - (0.5f + 0.1f * (float)enchantLvl)));
                }
            } else if (EntityUtil.isRareUndead((LivingEntity)event.getSource().func_76346_g())) {
                event.setAmount(event.getAmount() * (1.0f - 0.1f * (float)enchantLvl));
            } else if (event.getSource().func_76346_g() instanceof WitherEntity && enchantLvl > 1) {
                event.setAmount(event.getAmount() * (1.0f - 0.05f * (float)(enchantLvl - 1)));
            }
        }
    }

    @SubscribeEvent
    public static void doLightburnFungalParasiticEnchantmentEvent_applyProtectionAndSpreadFungalEffect(LivingDamageEvent event) {
        int enchantmentLvl;
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getEntityLiving() instanceof PlayerEntity && (enchantmentLvl = EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getEntityLiving(), (Enchantment)EnchantmentRegistry.LIGHTBURN_FUNGAL_PARASITIC.get(), EquipmentSlotType.CHEST, EnchantmentUtil.ItemEncCalOp.TOTAL_LEVEL)) != 0) {
            List<LivingEntity> targets;
            if (event.getSource().func_76346_g() instanceof LivingEntity && !(targets = EntityUtil.getTargetsExceptOneself((PlayerEntity)event.getEntityLiving(), 8.0f, 2.0f, (Boolean)Config.VILLAGER_SAFE_MODE.get() != false ? livingEntity -> !(livingEntity instanceof VillagerEntity) : x -> true)).isEmpty()) {
                Random rand = event.getEntityLiving().func_70681_au();
                for (LivingEntity target : targets) {
                    if (!(rand.nextDouble() < 0.125 * (double)(enchantmentLvl + 1))) continue;
                    target.func_195064_c(new EffectInstance((Effect)EffectRegistry.LIGHTBURN_FUNGAL_INFECTION.get(), 120));
                }
            }
            if (!event.isCanceled() && (event.getSource().func_76355_l().equals("fall") || event.getSource().func_76355_l().equals("explosion") || event.getSource().func_76347_k())) {
                event.setAmount(event.getAmount() * (1.0f - 0.05f * (float)(enchantmentLvl + 1)));
            }
        }
    }

    @SubscribeEvent
    public static void doLightburnFungalParasiticEnchantmentEvent_removeCurrentImmuneEffect(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.func_201670_d() && EnchantmentUtil.isPlayerItemEnchanted(event.player, (Enchantment)EnchantmentRegistry.LIGHTBURN_FUNGAL_PARASITIC.get(), EquipmentSlotType.CHEST, EnchantmentUtil.ItemEncCalOp.GENERAL) == 1) {
            if (event.player.func_70644_a(Effects.field_76436_u)) {
                event.player.func_184596_c(Effects.field_76436_u);
                Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.player), (Object)new RemoveEffectSyncToClientPacket(Effects.field_76436_u));
            }
            if (event.player.func_70644_a((Effect)EffectRegistry.LIGHTBURN_FUNGAL_INFECTION.get())) {
                event.player.func_184596_c((Effect)EffectRegistry.LIGHTBURN_FUNGAL_INFECTION.get());
                Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.player), (Object)new RemoveEffectSyncToClientPacket((Effect)EffectRegistry.LIGHTBURN_FUNGAL_INFECTION.get()));
            }
        }
    }

    @SubscribeEvent
    public static void doLightburnFungalParasiticEnchantmentEvent_addImmunity(PotionEvent.PotionApplicableEvent event) {
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getEntityLiving() instanceof PlayerEntity && EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getEntityLiving(), (Enchantment)EnchantmentRegistry.LIGHTBURN_FUNGAL_PARASITIC.get(), EquipmentSlotType.CHEST, EnchantmentUtil.ItemEncCalOp.GENERAL) == 1) {
            if (event.getPotionEffect().func_188419_a().equals(Effects.field_76436_u)) {
                event.setResult(Event.Result.DENY);
            }
            if (event.getPotionEffect().func_188419_a().equals(EffectRegistry.LIGHTBURN_FUNGAL_INFECTION.get())) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void doScholarOfOriginalSinEnchantmentEvent_addWeakness(LivingDamageEvent event) {
        int enchantmentLvl;
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getEntityLiving() instanceof PlayerEntity && !event.isCanceled() && event.getSource() != DamageSource.field_76380_i && (enchantmentLvl = EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getEntityLiving(), (Enchantment)EnchantmentRegistry.SCHOLAR_OF_ORIGINAL_SIN.get(), EquipmentSlotType.CHEST, EnchantmentUtil.ItemEncCalOp.TOTAL_LEVEL)) != 0) {
            float extraDamage = Math.min(event.getAmount() * (1.1f - 0.1f * (float)enchantmentLvl), 10.0f);
            event.setAmount(event.getAmount() + extraDamage);
        }
    }

    @SubscribeEvent
    public static void doScholarOfOriginalSinEnchantmentEvent_extendHarmfulEffect(PotionEvent.PotionAddedEvent event) {
        int enchantmentLvl;
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getEntityLiving() instanceof PlayerEntity && (enchantmentLvl = EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getEntityLiving(), (Enchantment)EnchantmentRegistry.SCHOLAR_OF_ORIGINAL_SIN.get(), EquipmentSlotType.CHEST, EnchantmentUtil.ItemEncCalOp.TOTAL_LEVEL)) != 0 && event.getPotionEffect().func_188419_a().func_220303_e() == EffectType.HARMFUL && EffectUtil.isEffectShown(event.getPotionEffect())) {
            event.getPotionEffect().func_199308_a(new EffectInstance(event.getPotionEffect().func_188419_a(), (int)((double)event.getPotionEffect().func_76459_b() * (2.1 - 0.1 * (double)enchantmentLvl))));
        }
    }

    @SubscribeEvent
    public static void doScholarOfOriginalSinEnchantmentEvent_extraEXP(PlayerXpEvent.PickupXp event) {
        int enchantmentLvl;
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getEntityLiving() instanceof PlayerEntity && (enchantmentLvl = EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getEntityLiving(), (Enchantment)EnchantmentRegistry.SCHOLAR_OF_ORIGINAL_SIN.get(), EquipmentSlotType.CHEST, EnchantmentUtil.ItemEncCalOp.TOTAL_LEVEL)) != 0) {
            event.getOrb().field_70530_e = (int)((double)event.getOrb().field_70530_e * (1.35 + 0.15 * (double)enchantmentLvl));
        }
    }

    @SubscribeEvent
    public static void doOriginalSinErosionEnchantmentEvent_decreaseAttack(LivingDamageEvent event) {
        int enchantmentLvl;
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getSource().func_76346_g() instanceof PlayerEntity && (enchantmentLvl = EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getSource().func_76346_g(), (Enchantment)EnchantmentRegistry.ORIGINAL_SIN_EROSION.get(), EquipmentSlotType.CHEST, EnchantmentUtil.ItemEncCalOp.TOTAL_LEVEL)) != 0) {
            float damageModified = Math.max(event.getAmount() - 5.0f + (float)enchantmentLvl, 0.0f);
            event.setAmount(damageModified);
        }
    }

    @SubscribeEvent
    public static void doOriginalSinErosionEnchantmentEvent_extraEXP(PlayerXpEvent.PickupXp event) {
        int enchantmentLvl;
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getEntityLiving() instanceof PlayerEntity && (enchantmentLvl = EnchantmentUtil.isPlayerItemEnchanted((PlayerEntity)event.getEntityLiving(), (Enchantment)EnchantmentRegistry.ORIGINAL_SIN_EROSION.get(), EquipmentSlotType.CHEST, EnchantmentUtil.ItemEncCalOp.TOTAL_LEVEL)) != 0) {
            event.getOrb().field_70530_e = (int)((double)event.getOrb().field_70530_e * (1.05 + 0.05 * (double)enchantmentLvl));
        }
    }

    @SubscribeEvent
    public static void doBurialObjectCurseEvent(LivingDeathEvent event) {
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getEntityLiving() instanceof PlayerEntity) {
            BlockPos originalDeathPos = event.getEntityLiving().func_180425_c();
            AxisAlignedBB scanningArea = new AxisAlignedBB((double)(originalDeathPos.func_177958_n() - 16), (double)(originalDeathPos.func_177956_o() - 1), (double)(originalDeathPos.func_177952_p() - 16), (double)(originalDeathPos.func_177958_n() + 16), (double)(originalDeathPos.func_177956_o() + 1), (double)(originalDeathPos.func_177952_p() + 16));
            List players = event.getEntityLiving().field_70170_p.func_217357_a(PlayerEntity.class, scanningArea);
            for (PlayerEntity player : players) {
                if (EnchantmentUtil.isPlayerArmorEnchanted(player, (Enchantment)EnchantmentRegistry.BURIAL_OBJECT.get(), EnchantmentUtil.ArmorEncCalOp.GENERAL) != 1) continue;
                player.func_70097_a(CustomDamageSource.causeBurialObjectDamage((LivingEntity)((PlayerEntity)event.getEntityLiving())), 120.0f);
            }
        }
    }
}

