/*
 * Decompiled with CFR 0.152.
 */
package love.marblegate.flowingagony.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;

public class EnchantmentUtil {
    public static int isItemEnchanted(ItemStack itemStack, Enchantment enchantment) {
        Map enchantList = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        return enchantList.containsKey(enchantment) ? 1 : 0;
    }

    public static int isPlayerArmorEnchanted(PlayerEntity player, Enchantment enchantment, ArmorEncCalOp mode) {
        if (mode == ArmorEncCalOp.GENERAL) {
            return EnchantmentUtil.isPlayerArmorEnchanted_general(player, enchantment);
        }
        if (mode == ArmorEncCalOp.TOTAL_PIECE) {
            return EnchantmentUtil.isPlayerArmorEnchanted_totalPiece(player, enchantment);
        }
        if (mode == ArmorEncCalOp.TOTAL_LEVEL) {
            return EnchantmentUtil.isPlayerArmorEnchanted_totalLevel(player, enchantment);
        }
        return EnchantmentUtil.isPlayerArmorEnchanted_highestLevel(player, enchantment);
    }

    public static int isPlayerItemEnchanted(PlayerEntity player, Enchantment enchantment, EquipmentSlotType slotIn, ItemEncCalOp mode) {
        Map enchantList = EnchantmentHelper.func_82781_a((ItemStack)player.func_184582_a(slotIn));
        if (mode == ItemEncCalOp.GENERAL) {
            return enchantList.containsKey(enchantment) ? 1 : 0;
        }
        return enchantList.getOrDefault(enchantment, 0);
    }

    public static List<ItemStack> getItemStackWithEnchantment(PlayerEntity player, Enchantment enchantment) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (EquipmentSlotType type : EquipmentSlotType.values()) {
            if (EnchantmentUtil.isPlayerItemEnchanted(player, enchantment, type, ItemEncCalOp.GENERAL) != 1) continue;
            items.add(player.func_184582_a(type));
        }
        return items;
    }

    static int isPlayerArmorEnchanted_general(PlayerEntity player, Enchantment enchantment) {
        for (ItemStack itemStack : player.func_184193_aE()) {
            Map enchantList = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
            if (!enchantList.containsKey(enchantment)) continue;
            return 1;
        }
        return 0;
    }

    static int isPlayerArmorEnchanted_totalPiece(PlayerEntity player, Enchantment enchantment) {
        Iterator armor = player.func_184193_aE().iterator();
        int count = 0;
        while (armor.hasNext()) {
            Map enchantList = EnchantmentHelper.func_82781_a((ItemStack)((ItemStack)armor.next()));
            if (!enchantList.containsKey(enchantment)) continue;
            ++count;
        }
        return count;
    }

    static int isPlayerArmorEnchanted_totalLevel(PlayerEntity player, Enchantment enchantment) {
        Iterator armor = player.func_184193_aE().iterator();
        int count = 0;
        while (armor.hasNext()) {
            Map enchantList = EnchantmentHelper.func_82781_a((ItemStack)((ItemStack)armor.next()));
            if (!enchantList.containsKey(enchantment)) continue;
            count += ((Integer)enchantList.get(enchantment)).intValue();
        }
        return count;
    }

    static int isPlayerArmorEnchanted_highestLevel(PlayerEntity player, Enchantment enchantment) {
        Iterator armor = player.func_184193_aE().iterator();
        int count = 0;
        while (armor.hasNext()) {
            Map enchantList = EnchantmentHelper.func_82781_a((ItemStack)((ItemStack)armor.next()));
            if (!enchantList.containsKey(enchantment) || (Integer)enchantList.get(enchantment) <= count) continue;
            count = (Integer)enchantList.get(enchantment);
        }
        return count;
    }

    public static enum ItemEncCalOp {
        GENERAL,
        TOTAL_LEVEL;

    }

    public static enum ArmorEncCalOp {
        GENERAL,
        TOTAL_PIECE,
        TOTAL_LEVEL,
        HIGHEST_LEVEL;

    }
}

