/*
 * Decompiled with CFR 0.152.
 */
package love.marblegate.flowingagony.util;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.StrayEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.passive.horse.ZombieHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class EntityUtil {
    public static List<LivingEntity> getTargetsExceptOneself(LivingEntity center, float radius, float height, Predicate<LivingEntity> predicate) {
        AxisAlignedBB aabb = new AxisAlignedBB((double)((float)center.func_180425_c().func_177958_n() - radius), (double)((float)center.func_180425_c().func_177956_o() - height), (double)((float)center.func_180425_c().func_177952_p() - radius), (double)((float)center.func_180425_c().func_177958_n() + radius), (double)((float)center.func_180425_c().func_177956_o() + height), (double)((float)center.func_180425_c().func_177952_p() + radius));
        List entities = center.field_70170_p.func_175647_a(LivingEntity.class, aabb, predicate);
        entities.remove(center);
        return entities;
    }

    public static List<LivingEntity> getTargetsExceptOneself(PlayerEntity center, float radius, float height, Predicate<LivingEntity> predicate) {
        return EntityUtil.getTargetsExceptOneself((LivingEntity)center, radius, height, predicate);
    }

    public static List<LivingEntity> getTargetsOfSameType(LivingEntity center, float radius, float height, LivingEntity sourceEntity, boolean excludeOneself) {
        AxisAlignedBB aabb = new AxisAlignedBB((double)((float)center.func_180425_c().func_177958_n() - radius), (double)((float)center.func_180425_c().func_177956_o() - height), (double)((float)center.func_180425_c().func_177952_p() - radius), (double)((float)center.func_180425_c().func_177958_n() + radius), (double)((float)center.func_180425_c().func_177956_o() + height), (double)((float)center.func_180425_c().func_177952_p() + radius));
        List entities = center.field_70170_p.func_175647_a(LivingEntity.class, aabb, livingEntity -> livingEntity.getClass() == sourceEntity.getClass());
        if (excludeOneself) {
            entities.remove(center);
        }
        return entities;
    }

    public static boolean isHostile(LivingEntity livingEntity, boolean restrictMode) {
        if (restrictMode) {
            return livingEntity instanceof MonsterEntity && !(livingEntity instanceof ZombiePigmanEntity) && !(livingEntity instanceof SpiderEntity) && !(livingEntity instanceof EndermanEntity) || livingEntity instanceof SlimeEntity || livingEntity instanceof FlyingEntity || livingEntity instanceof EnderDragonEntity;
        }
        return livingEntity instanceof MonsterEntity || livingEntity instanceof SlimeEntity || livingEntity instanceof FlyingEntity || livingEntity instanceof EnderDragonEntity;
    }

    public static boolean isNeutral(LivingEntity livingEntity, boolean restrictMode) {
        if (restrictMode) {
            return EntityUtil.isNeutral(livingEntity, false) || livingEntity instanceof EndermanEntity || livingEntity instanceof ZombiePigmanEntity || livingEntity instanceof SpiderEntity;
        }
        return livingEntity instanceof BeeEntity || livingEntity instanceof DolphinEntity || livingEntity instanceof IronGolemEntity || livingEntity instanceof WolfEntity || livingEntity instanceof PandaEntity || livingEntity instanceof PolarBearEntity || livingEntity instanceof LlamaEntity;
    }

    public static boolean isAggresiveUndead(LivingEntity livingEntity) {
        return EntityUtil.isCommonUndead(livingEntity) || EntityUtil.isRareUndead(livingEntity) || livingEntity instanceof WitherEntity;
    }

    public static boolean isCommonUndead(LivingEntity livingEntity) {
        return livingEntity instanceof ZombieEntity || livingEntity instanceof SkeletonEntity;
    }

    public static boolean isRareUndead(LivingEntity livingEntity) {
        return livingEntity instanceof PhantomEntity || livingEntity instanceof WitherSkeletonEntity || livingEntity instanceof StrayEntity || livingEntity instanceof GhastEntity || livingEntity instanceof ZombiePigmanEntity;
    }

    public static boolean isPassiveUndead(LivingEntity livingEntity) {
        return livingEntity instanceof ZombieHorseEntity || livingEntity instanceof SkeletonHorseEntity;
    }

    public static boolean supportHeadDrop(LivingEntity livingEntity) {
        return livingEntity instanceof ZombieEntity && !(livingEntity instanceof ZombieVillagerEntity) && !(livingEntity instanceof DrownedEntity) && !(livingEntity instanceof HuskEntity) || livingEntity instanceof SkeletonEntity || livingEntity instanceof CreeperEntity || livingEntity instanceof EnderDragonEntity || livingEntity instanceof WitherSkeletonEntity;
    }
}

