/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks;

import com.google.common.base.Preconditions;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xfacthd.framedblocks.client.util.ClientConfig;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.compat.buildinggadgets.BuildingGadgetsCompat;
import xfacthd.framedblocks.common.item.FramedToolItem;
import xfacthd.framedblocks.common.net.OpenSignScreenPacket;
import xfacthd.framedblocks.common.net.SignUpdatePacket;
import xfacthd.framedblocks.common.util.CommonConfig;

@Mod(value="framedblocks")
@Mod.EventBusSubscriber(modid="framedblocks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FramedBlocks {
    public static final String MODID = "framedblocks";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("framedblocks", "main"), () -> "1", "1"::equals, "1"::equals);
    public static final ItemGroup FRAMED_GROUP = new ItemGroup("framed_blocks"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)FBContent.blockFramedCube.get());
        }

        public void func_78018_a(NonNullList<ItemStack> items) {
            super.func_78018_a(items);
            items.sort((s1, s2) -> {
                Item itemOne = s1.func_77973_b();
                Item itemTwo = s2.func_77973_b();
                if (itemOne instanceof FramedToolItem && itemTwo instanceof FramedToolItem) {
                    return ((FramedToolItem)itemOne).getType().compareTo(((FramedToolItem)itemTwo).getType());
                }
                if (itemOne instanceof FramedToolItem) {
                    return 1;
                }
                if (itemTwo instanceof FramedToolItem) {
                    return -1;
                }
                Preconditions.checkArgument((itemOne instanceof BlockItem && ((BlockItem)itemOne).func_179223_d() instanceof IFramedBlock ? 1 : 0) != 0, (Object)String.format("Invalid item in FramedBlocks creative tab: %s", itemOne.getRegistryName()));
                Preconditions.checkArgument((itemTwo instanceof BlockItem && ((BlockItem)itemTwo).func_179223_d() instanceof IFramedBlock ? 1 : 0) != 0, (Object)String.format("Invalid item in FramedBlocks creative tab: %s", itemOne.getRegistryName()));
                Block b1 = ((BlockItem)itemOne).func_179223_d();
                Block b2 = ((BlockItem)itemTwo).func_179223_d();
                return ((IFramedBlock)b1).getBlockType().compareTo(((IFramedBlock)b2).getBlockType());
            });
        }
    };

    public FramedBlocks() {
        FBContent.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ClientConfig.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CommonConfig.SPEC);
        if (ModList.get().isLoaded("buildinggadgets")) {
            BuildingGadgetsCompat.init();
        }
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        CHANNEL.messageBuilder(SignUpdatePacket.class, 0, NetworkDirection.PLAY_TO_SERVER).encoder(SignUpdatePacket::encode).decoder(SignUpdatePacket::new).consumer(SignUpdatePacket::handle).add();
        CHANNEL.messageBuilder(OpenSignScreenPacket.class, 1, NetworkDirection.PLAY_TO_CLIENT).encoder(OpenSignScreenPacket::encode).decoder(OpenSignScreenPacket::new).consumer(OpenSignScreenPacket::handle).add();
    }
}

