/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fml.loading.FMLEnvironment;
import xfacthd.framedblocks.client.model.BakedModelProxy;
import xfacthd.framedblocks.client.model.FluidDummyModel;
import xfacthd.framedblocks.client.util.FramedBlockData;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;

public abstract class FramedBlockModel
extends BakedModelProxy {
    private static final boolean FORCE_NODATA = true;
    private final Table<BlockState, RenderType, Map<Direction, List<BakedQuad>>> quadCacheTable = HashBasedTable.create();
    private final Map<BlockState, IBakedModel> modelCache = new HashMap<BlockState, IBakedModel>();
    private final BlockState state;
    private final BlockType type;
    private final Map<BlockState, FluidDummyModel> fluidModels = new HashMap<BlockState, FluidDummyModel>();

    public FramedBlockModel(BlockState state, IBakedModel baseModel) {
        super(baseModel);
        this.state = state;
        this.type = ((IFramedBlock)state.func_177230_c()).getBlockType();
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        RenderType layer = MinecraftForgeClient.getRenderLayer();
        BlockState camoState = Blocks.field_150350_a.func_176223_P();
        if (extraData instanceof FramedBlockData && layer != null) {
            boolean canRender;
            FramedBlockData data = (FramedBlockData)extraData;
            if (side != null && ((IFramedBlock)state.func_177230_c()).isSideHidden((IBlockReader)data.getWorld(), data.getPos(), state, side)) {
                return Collections.emptyList();
            }
            camoState = data.getCamoState();
            boolean bl = camoState != null && camoState.func_177230_c() instanceof FlowingFluidBlock ? RenderTypeLookup.canRenderInLayer((FluidState)camoState.func_204520_s(), (RenderType)layer) : (canRender = camoState != null && RenderTypeLookup.canRenderInLayer((BlockState)camoState, (RenderType)layer));
            if (camoState != null && !camoState.func_196958_f() && canRender) {
                return this.getCamoQuads(state, camoState, side, rand, extraData, layer);
            }
        }
        if (layer == null) {
            layer = RenderType.func_228643_e_();
        }
        if ((camoState == null || camoState.func_196958_f()) && layer == RenderType.func_228643_e_()) {
            return this.getCamoQuads(state, ((Block)FBContent.blockFramedCube.get()).func_176223_P(), side, rand, extraData, layer);
        }
        return Collections.emptyList();
    }

    @Override
    public List<BakedQuad> func_200117_a(BlockState state, Direction side, Random rand) {
        if (state == null) {
            state = this.state;
        }
        return this.getCamoQuads(state, ((Block)FBContent.blockFramedCube.get()).func_176223_P(), side, rand, (IModelData)EmptyModelData.INSTANCE, RenderType.func_228643_e_());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BakedQuad> getCamoQuads(BlockState state, BlockState camoState, Direction side, Random rand, IModelData extraData, RenderType layer) {
        if (this.type.getCtmPredicate().test(state, side)) {
            Map<BlockState, IBakedModel> map = this.modelCache;
            synchronized (map) {
                if (!this.modelCache.containsKey(camoState)) {
                    this.modelCache.put(camoState, this.getCamoModel(camoState));
                }
                IBakedModel model = this.modelCache.get(camoState);
                IModelData data = FramedBlockModel.getCamoData(model, camoState, extraData);
                return model.getQuads(camoState, side, rand, data);
            }
        }
        Table<BlockState, RenderType, Map<Direction, List<BakedQuad>>> table = this.quadCacheTable;
        synchronized (table) {
            if (!this.quadCacheTable.contains((Object)camoState, (Object)layer)) {
                this.quadCacheTable.put((Object)camoState, (Object)layer, this.makeQuads(state, camoState, rand, extraData));
            }
            return (List)((Map)this.quadCacheTable.get((Object)camoState, (Object)layer)).get(side);
        }
    }

    private Map<Direction, List<BakedQuad>> makeQuads(BlockState state, BlockState camoState, Random rand, IModelData data) {
        Object2ObjectArrayMap quadMap = new Object2ObjectArrayMap(7);
        quadMap.put(null, new ArrayList());
        for (Direction dir : Direction.values()) {
            quadMap.put(dir, new ArrayList());
        }
        IBakedModel camoModel = this.getCamoModel(camoState);
        List quads = FramedBlockModel.getAllQuads(camoModel, camoState, rand, FramedBlockModel.getCamoData(camoModel, camoState, data)).stream().filter(q -> !this.type.getCtmPredicate().test(state, q.func_178210_d())).collect(Collectors.toList());
        for (BakedQuad quad : quads) {
            this.transformQuad((Map<Direction, List<BakedQuad>>)quadMap, quad);
        }
        this.postProcessQuads((Map<Direction, List<BakedQuad>>)quadMap);
        this.getAdditionalQuads((Map<Direction, List<BakedQuad>>)quadMap, state, rand, data);
        return quadMap;
    }

    protected abstract void transformQuad(Map<Direction, List<BakedQuad>> var1, BakedQuad var2);

    protected void postProcessQuads(Map<Direction, List<BakedQuad>> quadMap) {
    }

    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, Random rand, IModelData data) {
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedTileEntity) {
            return te.getModelData();
        }
        return tileData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureAtlasSprite getParticleTexture(IModelData data) {
        BlockState camoState;
        if (data instanceof FramedBlockData && (camoState = (BlockState)data.getData(FramedBlockData.CAMO)) != null && !camoState.func_196958_f()) {
            Map<BlockState, IBakedModel> map = this.modelCache;
            synchronized (map) {
                return this.modelCache.computeIfAbsent(camoState, state -> this.getCamoModel(camoState)).func_177554_e();
            }
        }
        return this.baseModel.func_177554_e();
    }

    protected IBakedModel getCamoModel(BlockState camoState) {
        if (camoState.func_177230_c() instanceof FlowingFluidBlock) {
            return this.fluidModels.computeIfAbsent(camoState, state -> new FluidDummyModel((Fluid)((FlowingFluidBlock)state.func_177230_c()).getFluid()));
        }
        return Minecraft.func_71410_x().func_175602_ab().func_184389_a(camoState);
    }

    private static IModelData getCamoData(IBakedModel model, BlockState state, IModelData data) {
        World world = (World)data.getData(FramedBlockData.WORLD);
        BlockPos pos = (BlockPos)data.getData(FramedBlockData.POS);
        if (world == null || pos == null || pos.equals((Object)BlockPos.field_177992_a)) {
            return data;
        }
        return model.getModelData((IBlockDisplayReader)world, pos, state, data);
    }

    protected static List<BakedQuad> getAllQuads(IBakedModel model, BlockState state, Random rand, IModelData data) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Direction dir : Direction.values()) {
            if (!FMLEnvironment.production) {
                // empty if block
            }
            quads.addAll(model.getQuads(state, dir, rand, (IModelData)EmptyModelData.INSTANCE));
        }
        return quads;
    }
}

