/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.ChestState;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedChestModel
extends FramedBlockModel {
    private static final ResourceLocation TEXTURE = new ResourceLocation("framedblocks", "block/framed_chest_lock");
    private final boolean closed;

    public FramedChestModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.closed = state.func_177229_b(PropertyHolder.CHEST_STATE) == ChestState.CLOSED;
    }

    public FramedChestModel(IBakedModel baseModel) {
        this(((Block)FBContent.blockFramedChest.get()).func_176223_P(), baseModel);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (quad.func_178210_d().func_176740_k() == Direction.Axis.Y) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, 0.0625f, 0.0625f, 0.9375f, 0.9375f)) {
                if (topBotQuad.func_178210_d() == Direction.UP) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, this.closed ? 0.875f : 0.625f);
                    quadMap.get(null).add(topBotQuad);
                } else {
                    quadMap.get(quad.func_178210_d()).add(topBotQuad);
                }
            }
        } else {
            BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(sideQuad, 0.0625f, 0.0f, 0.9375f, this.closed ? 0.875f : 0.625f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.9375f);
                quadMap.get(null).add(sideQuad);
            }
        }
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, Random rand, IModelData data) {
        if (!this.closed) {
            return;
        }
        List quads = this.baseModel.getQuads(state, null, rand, data);
        for (BakedQuad quad : quads) {
            if (!quad.func_187508_a().func_195668_m().equals((Object)TEXTURE)) continue;
            quadMap.get(null).add(quad);
        }
    }
}

