/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.client.model.BakedModelProxy;
import xfacthd.framedblocks.client.util.FramedBlockData;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.tileentity.FramedDoubleTileEntity;

public abstract class FramedDoubleBlockModel
extends BakedModelProxy {
    private final boolean specialItemModel;
    private Tuple<BlockState, BlockState> dummyStates = null;
    private Tuple<IBakedModel, IBakedModel> models = null;

    protected FramedDoubleBlockModel(IBakedModel baseModel, boolean specialItemModel) {
        super(baseModel);
        this.specialItemModel = specialItemModel;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (this.dummyStates == null) {
            this.dummyStates = this.getDummyStates();
        }
        if (this.models == null) {
            this.models = this.getModels();
        }
        IModelData dataLeft = (IModelData)extraData.getData(FramedDoubleTileEntity.DATA_LEFT);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(((IBakedModel)this.models.func_76341_a()).getQuads((BlockState)this.dummyStates.func_76341_a(), side, rand, (IModelData)(dataLeft != null ? dataLeft : EmptyModelData.INSTANCE)));
        IModelData dataRight = (IModelData)extraData.getData(FramedDoubleTileEntity.DATA_RIGHT);
        quads.addAll(this.invertTintIndizes(((IBakedModel)this.models.func_76340_b()).getQuads((BlockState)this.dummyStates.func_76340_b(), side, rand, (IModelData)(dataRight != null ? dataRight : EmptyModelData.INSTANCE))));
        return quads;
    }

    @Override
    @Deprecated
    public List<BakedQuad> func_200117_a(BlockState state, Direction side, Random rand) {
        if (this.specialItemModel) {
            if (this.dummyStates == null) {
                this.dummyStates = this.getDummyStates();
            }
            if (this.models == null) {
                this.models = this.getModels();
            }
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(((IBakedModel)this.models.func_76341_a()).func_200117_a(state, side, rand));
            quads.addAll(((IBakedModel)this.models.func_76340_b()).func_200117_a(state, side, rand));
            return quads;
        }
        return super.func_200117_a(state, side, rand);
    }

    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
        IModelData innerData = (IModelData)data.getData(FramedDoubleTileEntity.DATA_LEFT);
        if (innerData != null && !((BlockState)innerData.getData(FramedBlockData.CAMO)).func_196958_f()) {
            return ((IBakedModel)this.models.func_76341_a()).getParticleTexture(innerData);
        }
        innerData = (IModelData)data.getData(FramedDoubleTileEntity.DATA_RIGHT);
        if (innerData != null && !((BlockState)innerData.getData(FramedBlockData.CAMO)).func_196958_f()) {
            return ((IBakedModel)this.models.func_76340_b()).getParticleTexture(innerData);
        }
        return this.baseModel.func_177554_e();
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedDoubleTileEntity) {
            return te.getModelData();
        }
        return tileData;
    }

    protected abstract Tuple<BlockState, BlockState> getDummyStates();

    private Tuple<IBakedModel, IBakedModel> getModels() {
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        return new Tuple((Object)dispatcher.func_184389_a((BlockState)this.dummyStates.func_76341_a()), (Object)dispatcher.func_184389_a((BlockState)this.dummyStates.func_76340_b()));
    }

    private List<BakedQuad> invertTintIndizes(List<BakedQuad> quads) {
        return quads.stream().map(ModelUtils::invertTintIndex).collect(Collectors.toList());
    }
}

