/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;

public class FramedLeverModel
extends FramedBlockModel {
    private static final ResourceLocation TEXTURE = new ResourceLocation("framedblocks", "block/framed_block");
    private final Direction dir;
    private final AttachFace face;

    public FramedLeverModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        this.face = (AttachFace)state.func_177229_b((Property)BlockStateProperties.field_208158_K);
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, Random rand, IModelData data) {
        List quads = this.baseModel.getQuads(state, null, rand, data);
        for (BakedQuad quad : quads) {
            if (quad.func_187508_a().func_195668_m().equals((Object)TEXTURE)) continue;
            quadMap.get(null).add(quad);
        }
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction facing = this.dir;
        if (this.face == AttachFace.CEILING) {
            facing = Direction.DOWN;
        } else if (this.face == AttachFace.FLOOR) {
            facing = Direction.UP;
        }
        if (facing.func_176740_k() == Direction.Axis.Y) {
            float maxZ;
            boolean rotX = this.dir.func_176740_k() == Direction.Axis.X;
            float minX = rotX ? 0.25f : 0.3125f;
            float minZ = rotX ? 0.3125f : 0.25f;
            float maxX = rotX ? 0.75f : 0.6875f;
            float f = maxZ = rotX ? 0.6875f : 0.75f;
            if (quad.func_178210_d() == facing || quad.func_178210_d() == facing.func_176734_d()) {
                BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, minX, minZ, maxX, maxZ)) {
                    if (quad.func_178210_d() == facing) {
                        BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.1875f);
                        quadMap.get(null).add(topBotQuad);
                    } else {
                        quadMap.get(quad.func_178210_d()).add(topBotQuad);
                    }
                }
            } else {
                boolean smallSide = rotX == (quad.func_178210_d().func_176740_k() == Direction.Axis.X);
                float minXZ = smallSide ? 0.3125f : 0.25f;
                float maxXZ = smallSide ? 0.6875f : 0.75f;
                float minY = facing == Direction.DOWN ? 0.8125f : 0.0f;
                float maxY = facing == Direction.DOWN ? 1.0f : 0.1875f;
                BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createSideQuad(sideQuad, minXZ, minY, maxXZ, maxY)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, smallSide ? 0.75f : 0.6875f);
                    quadMap.get(null).add(sideQuad);
                }
            }
        } else if (quad.func_178210_d() == facing || quad.func_178210_d() == facing.func_176734_d()) {
            BakedQuad faceQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(faceQuad, 0.3125f, 0.25f, 0.6875f, 0.75f)) {
                if (quad.func_178210_d() == facing) {
                    BakedQuadTransformer.setQuadPosInFacingDir(faceQuad, 0.1875f);
                    quadMap.get(null).add(faceQuad);
                } else {
                    quadMap.get(quad.func_178210_d()).add(faceQuad);
                }
            }
        } else {
            float maxZ;
            float minZ;
            float maxX;
            float minX;
            boolean negative;
            boolean xAxis = facing.func_176740_k() == Direction.Axis.X;
            boolean bl = negative = facing.func_176743_c() == Direction.AxisDirection.NEGATIVE;
            float f = xAxis ? (negative ? 0.8125f : 0.0f) : (minX = 0.3125f);
            float f2 = xAxis ? (negative ? 1.0f : 0.1875f) : (maxX = 0.6875f);
            float f3 = xAxis ? 0.3125f : (minZ = negative ? 0.8125f : 0.0f);
            float f4 = xAxis ? 0.6875f : (maxZ = negative ? 1.0f : 0.1875f);
            if (quad.func_178210_d().func_176740_k() == Direction.Axis.Y) {
                BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, minX, minZ, maxX, maxZ)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.75f);
                    quadMap.get(null).add(topBotQuad);
                }
            } else {
                float minXZ = xAxis ? minX : minZ;
                float maxXZ = xAxis ? maxX : maxZ;
                BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createSideQuad(sideQuad, minXZ, 0.25f, maxXZ, 0.75f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.6875f);
                    quadMap.get(null).add(sideQuad);
                }
            }
        }
    }
}

