/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.client.model.FramedChestLidModel;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.ChestState;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.tileentity.FramedChestTileEntity;

public class FramedChestRenderer
extends TileEntityRenderer<FramedChestTileEntity> {
    private static final RenderType[] RENDER_TYPES = new RenderType[]{RenderType.func_228639_c_(), RenderType.func_228643_e_(), RenderType.func_228641_d_(), RenderType.func_228645_f_()};
    private static final Map<Direction, IBakedModel> LID_MODELS = new EnumMap<Direction, IBakedModel>(Direction.class);

    public FramedChestRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(FramedChestTileEntity te, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay) {
        float xOff;
        BlockState state = te.func_195044_w();
        ChestState chestState = (ChestState)((Object)state.func_177229_b(PropertyHolder.CHEST_STATE));
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        long lastChange = te.getLastChangeTime(chestState);
        if (chestState == ChestState.CLOSED) {
            return;
        }
        IBakedModel model = LID_MODELS.get(dir);
        IModelData data = model.getModelData((IBlockDisplayReader)te.func_145831_w(), te.func_174877_v(), state, (IModelData)EmptyModelData.INSTANCE);
        float angle = this.calculateAngle(te, chestState, dir, lastChange, partialTicks);
        float f = dir.func_176740_k() == Direction.Axis.X ? (dir.func_176743_c() == Direction.AxisDirection.POSITIVE ? 0.0625f : 0.9375f) : (xOff = 0.0f);
        float zOff = dir.func_176740_k() == Direction.Axis.Z ? (dir.func_176743_c() == Direction.AxisDirection.POSITIVE ? 0.0625f : 0.9375f) : 0.0f;
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)xOff, 0.5625, (double)zOff);
        matrix.func_227863_a_(dir.func_176740_k() == Direction.Axis.X ? Vector3f.field_229183_f_.func_229187_a_(angle) : Vector3f.field_229178_a_.func_229187_a_(angle));
        matrix.func_227861_a_((double)(-xOff), -0.5625, (double)(-zOff));
        this.renderLidModel(te, state, matrix, buffer, model, data);
        matrix.func_227865_b_();
    }

    private void renderLidModel(FramedChestTileEntity te, BlockState state, MatrixStack matrix, IRenderTypeBuffer buffer, IBakedModel model, IModelData data) {
        BlockModelRenderer renderer = Minecraft.func_71410_x().func_175602_ab().func_175019_b();
        for (RenderType type : RENDER_TYPES) {
            ForgeHooksClient.setRenderLayer((RenderType)type);
            renderer.renderModelSmooth((IBlockDisplayReader)te.func_145831_w(), model, state, te.func_174877_v(), matrix, buffer.getBuffer(type), false, te.func_145831_w().func_201674_k(), te.func_174877_v().func_218275_a(), OverlayTexture.field_229196_a_, data);
        }
        ForgeHooksClient.setRenderLayer(null);
    }

    private float calculateAngle(FramedChestTileEntity te, ChestState chestState, Direction dir, long lastChange, float partialTicks) {
        float diff = (float)(te.func_145831_w().func_82737_E() - lastChange) + partialTicks;
        float factor = MathHelper.func_219799_g((float)(diff / 10.0f), (float)0.0f, (float)1.0f);
        if (chestState == ChestState.CLOSING) {
            factor = 1.0f - factor;
        }
        factor = 1.0f - factor;
        factor = 1.0f - factor * factor * factor;
        float angle = MathHelper.func_76131_a((float)(factor * 90.0f), (float)0.0f, (float)90.0f);
        if (dir.func_176743_c() == Direction.AxisDirection.NEGATIVE) {
            angle *= -1.0f;
        }
        return angle;
    }

    public static void onModelsLoaded(Map<ResourceLocation, IBakedModel> registry) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockState state = (BlockState)((Block)FBContent.blockFramedChest.get()).func_176223_P().func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)dir);
            ModelResourceLocation location = BlockModelShapes.func_209554_c((BlockState)state);
            LID_MODELS.put(dir, new FramedChestLidModel(state, registry.get(location)));
        }
    }
}

