/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.client.util.ClientConfig;
import xfacthd.framedblocks.client.util.FramedBlockData;
import xfacthd.framedblocks.client.util.GhostVertexBuilder;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.item.FramedBlueprintItem;
import xfacthd.framedblocks.common.tileentity.FramedDoubleTileEntity;

@Mod.EventBusSubscriber(modid="framedblocks", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class GhostBlockRenderer {
    private static final FramedBlockData GHOST_MODEL_DATA = new FramedBlockData();
    private static final FramedBlockData GHOST_MODEL_DATA_LEFT = new FramedBlockData();
    private static final FramedBlockData GHOST_MODEL_DATA_RIGHT = new FramedBlockData();
    private static final Method BLOCKITEM_GETPLACESTATE = ObfuscationReflectionHelper.findMethod(BlockItem.class, (String)"func_195945_b", (Class[])new Class[]{BlockItemUseContext.class});

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        GHOST_MODEL_DATA.setCamoState(((Block)FBContent.blockFramedCube.get()).func_176223_P());
        GHOST_MODEL_DATA.setData(FramedDoubleTileEntity.DATA_LEFT, GHOST_MODEL_DATA_LEFT);
        GHOST_MODEL_DATA.setData(FramedDoubleTileEntity.DATA_RIGHT, GHOST_MODEL_DATA_RIGHT);
    }

    public static void drawGhostBlock(IRenderTypeBuffer buffers, MatrixStack mstack) {
        BlockPos renderPos;
        boolean doRender;
        BlockState renderState;
        Block block;
        if (!ClientConfig.showGhostBlocks) {
            return;
        }
        RayTraceResult mouseOver = GhostBlockRenderer.mc().field_71476_x;
        if (mouseOver == null || mouseOver.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockRayTraceResult target = (BlockRayTraceResult)mouseOver;
        boolean blueprint = false;
        ItemStack stack = GhostBlockRenderer.mc().field_71439_g.func_184614_ca();
        if (stack.func_77973_b() instanceof FramedBlueprintItem) {
            block = ((FramedBlueprintItem)stack.func_77973_b()).getTargetBlock(stack);
            blueprint = true;
        } else if (stack.func_77973_b() instanceof BlockItem) {
            block = ((BlockItem)stack.func_77973_b()).func_179223_d();
        } else {
            return;
        }
        if (!(block instanceof IFramedBlock)) {
            return;
        }
        if (!blueprint && (renderState = GhostBlockRenderer.tryBuildDoublePanel(target, block)) != null) {
            doRender = true;
            renderPos = target.func_216350_a();
        } else if (!blueprint && (renderState = GhostBlockRenderer.tryBuildDoubleSlab(target, block)) != null) {
            doRender = true;
            renderPos = target.func_216350_a();
        } else {
            BlockItemUseContext context = new BlockItemUseContext((PlayerEntity)GhostBlockRenderer.mc().field_71439_g, Hand.MAIN_HAND, stack, target);
            renderPos = context.func_195995_a();
            renderState = GhostBlockRenderer.getStateForPlacement(context, block);
            boolean bl = doRender = renderState != null && GhostBlockRenderer.mc().field_71441_e.func_226663_a_(renderState, renderPos, ISelectionContext.func_216374_a((Entity)GhostBlockRenderer.mc().field_71439_g)) && GhostBlockRenderer.mc().field_71441_e.func_180495_p(renderPos).func_196953_a(context);
        }
        if (doRender) {
            CompoundNBT beTag;
            BlockState camoState = Blocks.field_150350_a.func_176223_P();
            BlockState camoStateTwo = Blocks.field_150350_a.func_176223_P();
            if (blueprint) {
                beTag = stack.func_190925_c("blueprint_data").func_74775_l("camo_data");
                camoState = NBTUtil.func_190008_d((CompoundNBT)beTag.func_74775_l("camo_state"));
                if (renderState.func_177230_c() instanceof AbstractFramedDoubleBlock) {
                    camoStateTwo = NBTUtil.func_190008_d((CompoundNBT)beTag.func_74775_l("camo_state_two"));
                    if (block == FBContent.blockFramedDoublePanel.get() && renderState.func_177229_b((Property)PropertyHolder.FACING_NE) != GhostBlockRenderer.mc().field_71439_g.func_174811_aO()) {
                        BlockState temp = camoState;
                        camoState = camoStateTwo;
                        camoStateTwo = temp;
                    }
                    GHOST_MODEL_DATA_LEFT.setCamoState(camoState);
                    GHOST_MODEL_DATA_RIGHT.setCamoState(camoStateTwo);
                } else {
                    GHOST_MODEL_DATA.setCamoState(camoState);
                }
            }
            GhostBlockRenderer.doRenderGhostBlock(mstack, buffers, renderPos, renderState, camoState, camoStateTwo);
            if (renderState.func_177230_c() == FBContent.blockFramedDoor.get()) {
                if (blueprint) {
                    beTag = stack.func_190925_c("blueprint_data").func_74775_l("camo_data_two");
                    camoState = NBTUtil.func_190008_d((CompoundNBT)beTag.func_74775_l("camo_state"));
                    GHOST_MODEL_DATA.setCamoState(camoState);
                }
                GhostBlockRenderer.doRenderGhostBlock(mstack, buffers, renderPos.func_177984_a(), (BlockState)renderState.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER), camoState, camoStateTwo);
            }
            if (blueprint) {
                GHOST_MODEL_DATA.setCamoState(Blocks.field_150350_a.func_176223_P());
                GHOST_MODEL_DATA_LEFT.setCamoState(Blocks.field_150350_a.func_176223_P());
                GHOST_MODEL_DATA_RIGHT.setCamoState(Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    private static void doRenderGhostBlock(MatrixStack mstack, IRenderTypeBuffer buffers, BlockPos renderPos, BlockState renderState, BlockState camoState, BlockState camoStateTwo) {
        GHOST_MODEL_DATA.setWorld((World)GhostBlockRenderer.mc().field_71441_e);
        GHOST_MODEL_DATA.setPos(renderPos);
        GHOST_MODEL_DATA_LEFT.setWorld((World)GhostBlockRenderer.mc().field_71441_e);
        GHOST_MODEL_DATA_LEFT.setPos(renderPos);
        GHOST_MODEL_DATA_RIGHT.setWorld((World)GhostBlockRenderer.mc().field_71441_e);
        GHOST_MODEL_DATA_RIGHT.setPos(renderPos);
        Vector3d offset = Vector3d.func_237491_b_((Vector3i)renderPos).func_178788_d(GhostBlockRenderer.mc().field_71460_t.func_215316_n().func_216785_c());
        GhostVertexBuilder builder = new GhostVertexBuilder(buffers.getBuffer(RenderType.func_228645_f_()), 170);
        if (camoState.func_196958_f() && camoStateTwo.func_196958_f()) {
            GhostBlockRenderer.doRenderGhostBlockInLayer(mstack, builder, renderPos, renderState, RenderType.func_228643_e_(), offset);
        } else {
            for (RenderType type : RenderType.func_228661_n_()) {
                if (!GhostBlockRenderer.canRenderInLayer(camoState, type) && !GhostBlockRenderer.canRenderInLayer(camoStateTwo, type)) continue;
                GhostBlockRenderer.doRenderGhostBlockInLayer(mstack, builder, renderPos, renderState, type, offset);
            }
        }
        ((IRenderTypeBuffer.Impl)buffers).func_228462_a_(RenderType.func_228645_f_());
        ForgeHooksClient.setRenderLayer(null);
    }

    private static boolean canRenderInLayer(BlockState camoState, RenderType layer) {
        if (camoState.func_196958_f()) {
            return layer == RenderType.func_228643_e_();
        }
        return RenderTypeLookup.canRenderInLayer((BlockState)camoState, (RenderType)layer);
    }

    private static void doRenderGhostBlockInLayer(MatrixStack mstack, IVertexBuilder builder, BlockPos renderPos, BlockState renderState, RenderType layer, Vector3d offset) {
        ForgeHooksClient.setRenderLayer((RenderType)layer);
        mstack.func_227860_a_();
        mstack.func_227861_a_(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
        GhostBlockRenderer.mc().func_175602_ab().renderModel(renderState, renderPos, (IBlockDisplayReader)GhostBlockRenderer.mc().field_71441_e, mstack, builder, false, GhostBlockRenderer.mc().field_71441_e.func_201674_k(), (IModelData)GHOST_MODEL_DATA);
        mstack.func_227865_b_();
    }

    private static BlockState tryBuildDoubleSlab(BlockRayTraceResult trace, Block heldBlock) {
        boolean top;
        if (heldBlock != FBContent.blockFramedSlab.get()) {
            return null;
        }
        BlockState target = GhostBlockRenderer.mc().field_71441_e.func_180495_p(trace.func_216350_a());
        if (target.func_177230_c() == heldBlock && ((top = ((Boolean)target.func_177229_b((Property)PropertyHolder.TOP)).booleanValue()) && trace.func_216354_b() == Direction.DOWN || !top && trace.func_216354_b() == Direction.UP)) {
            return (BlockState)target.func_206870_a((Property)PropertyHolder.TOP, (Comparable)Boolean.valueOf(!top));
        }
        return null;
    }

    private static BlockState tryBuildDoublePanel(BlockRayTraceResult trace, Block heldBlock) {
        Direction dir;
        if (heldBlock != FBContent.blockFramedPanel.get()) {
            return null;
        }
        BlockState target = GhostBlockRenderer.mc().field_71441_e.func_180495_p(trace.func_216350_a());
        if (target.func_177230_c() == heldBlock && (dir = (Direction)target.func_177229_b((Property)PropertyHolder.FACING_HOR)).func_176734_d() == trace.func_216354_b()) {
            return (BlockState)target.func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)dir.func_176734_d());
        }
        return null;
    }

    private static BlockState getStateForPlacement(BlockItemUseContext ctx, Block block) {
        Item item = ctx.func_195996_i().func_77973_b();
        if (item instanceof WallOrFloorItem) {
            try {
                return (BlockState)BLOCKITEM_GETPLACESTATE.invoke((Object)item, ctx);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                FramedBlocks.LOGGER.error("Encountered an error while getting placement state of ", (Throwable)e);
            }
        }
        return block.func_196258_a(ctx);
    }

    private static Minecraft mc() {
        return Minecraft.func_71410_x();
    }
}

