/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.item.FramedBlueprintItem;
import xfacthd.framedblocks.common.tileentity.FramedDoubleTileEntity;

public abstract class AbstractFramedDoubleBlock
extends FramedBlock {
    public AbstractFramedDoubleBlock(BlockType blockType) {
        super(blockType);
    }

    @Override
    @Nonnull
    public BlockState getFacade(@Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nullable Direction side, @Nonnull BlockPos connection) {
        TileEntity te;
        BlockState state = world.func_180495_p(pos);
        if (this.getCtmPredicate().test(state, side) && (te = world.func_175625_s(pos)) instanceof FramedDoubleTileEntity) {
            return ((FramedDoubleTileEntity)te).getCamoState(side);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    @Override
    public SoundType getSound(BlockState state, IWorldReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedDoubleTileEntity) {
            BlockState camoState = ((FramedDoubleTileEntity)te).getCamoStateTwo();
            if (!camoState.func_196958_f()) {
                return camoState.func_215695_r();
            }
            camoState = ((FramedDoubleTileEntity)te).getCamoState();
            if (!camoState.func_196958_f()) {
                return camoState.func_215695_r();
            }
        }
        return this.func_220072_p(state);
    }

    @Override
    public IFormattableTextComponent printCamoBlock(CompoundNBT beTag) {
        BlockState camoState = NBTUtil.func_190008_d((CompoundNBT)beTag.func_74775_l("camo_state"));
        BlockState camoStateTwo = NBTUtil.func_190008_d((CompoundNBT)beTag.func_74775_l("camo_state_two"));
        IFormattableTextComponent component = camoState.func_196958_f() ? FramedBlueprintItem.BLOCK_NONE : camoState.func_177230_c().func_235333_g_().func_240699_a_(TextFormatting.WHITE);
        component = component.func_230532_e_().func_230529_a_((ITextComponent)new StringTextComponent(" | ").func_240699_a_(TextFormatting.GOLD));
        component.func_230529_a_((ITextComponent)(camoStateTwo.func_196958_f() ? FramedBlueprintItem.BLOCK_NONE : camoStateTwo.func_177230_c().func_235333_g_().func_240699_a_(TextFormatting.WHITE)));
        return component;
    }
}

