/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;
import xfacthd.framedblocks.common.util.Utils;

public class FramedBlock
extends Block
implements IFramedBlock,
IWaterLoggable {
    private final BlockType blockType;
    private final Map<BlockState, VoxelShape> shapes;

    public FramedBlock(BlockType blockType) {
        this(blockType, IFramedBlock.createProperties());
    }

    protected FramedBlock(BlockType blockType, AbstractBlock.Properties props) {
        super(props);
        this.blockType = blockType;
        this.shapes = blockType.generateShapes((ImmutableList<BlockState>)this.func_176194_O().func_177619_a());
        if (blockType.supportsWaterLogging()) {
            this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return this.handleBlockActivated(world, pos, player, hand, hit);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(world, pos, placer, stack);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        if (this.isWaterLoggable() && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, pos, facingPos);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return this.getLight(world, pos);
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        return this.getSound(state, world, pos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return this.shapes.get(state);
    }

    public float getSlipperiness(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return this.getCamoSlipperiness(state, world, pos, entity);
    }

    public float func_220080_a(BlockState state, IBlockReader world, BlockPos pos) {
        return 1.0f;
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        return this.getCamoBlastResistance(state, world, pos, explosion);
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.isCamoFlammable(world, pos, face);
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.getCamoFlammability(world, pos, face);
    }

    public FluidState func_204507_t(BlockState state) {
        if (this.isWaterLoggable() && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            return Fluids.field_204546_a.func_207204_a(false);
        }
        return Fluids.field_204541_a.func_207188_f();
    }

    public final boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FramedTileEntity();
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, BlockState state, Fluid fluid) {
        if (!this.isWaterLoggable()) {
            return false;
        }
        return super.func_204510_a(world, pos, state, fluid);
    }

    public Fluid func_204508_a(IWorld world, BlockPos pos, BlockState state) {
        if (!this.isWaterLoggable()) {
            return Fluids.field_204541_a;
        }
        return super.func_204508_a(world, pos, state);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return this.getDrops(super.func_220076_a(state, builder), builder);
    }

    @Override
    public BlockType getBlockType() {
        return this.blockType;
    }

    protected BlockState withSlopeType(BlockState state, Direction side, Direction facing, Vector3d hitVec) {
        state = (BlockState)state.func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)facing);
        Vector3d hitPoint = Utils.fraction(hitVec);
        if (side.func_176740_k() != Direction.Axis.Y) {
            if (hitPoint.func_82617_b() < 0.1875) {
                side = Direction.UP;
            } else if (hitPoint.func_82617_b() > 0.8125) {
                side = Direction.DOWN;
            }
        }
        if (side == Direction.DOWN) {
            state = (BlockState)state.func_206870_a(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.TOP));
        } else if (side == Direction.UP) {
            state = (BlockState)state.func_206870_a(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.BOTTOM));
        } else {
            state = (BlockState)state.func_206870_a(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.HORIZONTAL));
            boolean xAxis = side.func_176740_k() == Direction.Axis.X;
            boolean positive = side.func_176735_f().func_176743_c() == Direction.AxisDirection.POSITIVE;
            double xz = xAxis ? hitPoint.func_82616_c() : hitPoint.func_82615_a();
            state = xz > 0.5 == positive ? (BlockState)state.func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)side.func_176734_d().func_176746_e()) : (BlockState)state.func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)side.func_176734_d());
        }
        return state;
    }

    protected BlockState withTop(BlockState state, Direction side, Vector3d hitVec) {
        if (side == Direction.DOWN) {
            state = (BlockState)state.func_206870_a((Property)PropertyHolder.TOP, (Comparable)Boolean.valueOf(true));
        } else if (side == Direction.UP) {
            state = (BlockState)state.func_206870_a((Property)PropertyHolder.TOP, (Comparable)Boolean.valueOf(false));
        } else {
            double y = hitVec.field_72448_b;
            state = (BlockState)state.func_206870_a((Property)PropertyHolder.TOP, (Comparable)Boolean.valueOf((y -= Math.floor(y)) >= 0.5));
        }
        return state;
    }

    protected BlockState withWater(BlockState state, IWorldReader world, BlockPos pos) {
        FluidState fluidState = world.func_204610_c(pos);
        return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
    }

    protected boolean isWaterLoggable() {
        return this.blockType.supportsWaterLogging();
    }
}

