/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.ChestState;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.tileentity.FramedChestTileEntity;

public class FramedChestBlock
extends FramedBlock {
    public FramedChestBlock() {
        super(BlockType.FRAMED_CHEST);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PropertyHolder.FACING_HOR, PropertyHolder.CHEST_STATE, BlockStateProperties.field_208198_y});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)context.func_195992_f().func_176734_d());
        return this.withWater(state, (IWorldReader)context.func_195991_k(), context.func_195995_a());
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity te;
        ActionResultType result = super.func_225533_a_(state, world, pos, player, hand, hit);
        if (result != ActionResultType.PASS) {
            return result;
        }
        if (!world.func_201670_d() && (te = world.func_175625_s(pos)) instanceof FramedChestTileEntity) {
            FramedChestTileEntity fte = (FramedChestTileEntity)te;
            if (state.func_177229_b(PropertyHolder.CHEST_STATE) != ChestState.OPENING) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a(PropertyHolder.CHEST_STATE, (Comparable)((Object)ChestState.OPENING)));
                world.func_184133_a(null, pos, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            fte.open();
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)fte, (BlockPos)pos);
        }
        return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List<ItemStack> drops = super.func_220076_a(state, builder);
        TileEntity te = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (te instanceof FramedChestTileEntity) {
            ((FramedChestTileEntity)te).addDrops(drops);
        }
        return drops;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FramedChestTileEntity();
    }
}

