/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.util.CtmPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class FramedCornerSlopeBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, dir) -> {
        CornerType type = (CornerType)((Object)((Object)state.func_177229_b(PropertyHolder.CORNER_TYPE)));
        if (type == CornerType.TOP) {
            return dir == Direction.UP;
        }
        if (type == CornerType.BOTTOM) {
            return dir == Direction.DOWN;
        }
        return state.func_177229_b((Property)PropertyHolder.FACING_HOR) == dir;
    };
    public static final CtmPredicate CTM_PREDICATE_INNER = (state, dir) -> {
        CornerType type = (CornerType)((Object)((Object)state.func_177229_b(PropertyHolder.CORNER_TYPE)));
        if ((type == CornerType.TOP || type.isHorizontal() && type.isTop()) && dir == Direction.UP) {
            return true;
        }
        if ((type == CornerType.BOTTOM || type.isHorizontal() && !type.isTop()) && dir == Direction.DOWN) {
            return true;
        }
        Direction facing = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (type.isHorizontal()) {
            return facing == dir || type.isRight() && facing.func_176746_e() == dir || !type.isRight() && facing.func_176735_f() == dir;
        }
        return facing == dir || facing.func_176746_e() == dir;
    };

    public FramedCornerSlopeBlock(BlockType type) {
        super(type);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PropertyHolder.FACING_HOR, PropertyHolder.CORNER_TYPE, BlockStateProperties.field_208198_y});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        Direction side = context.func_196000_l();
        Vector3d hitPoint = Utils.fraction(context.func_221532_j());
        if (side.func_176740_k() != Direction.Axis.Y) {
            if (hitPoint.func_82617_b() < 0.1875) {
                side = Direction.UP;
            } else if (hitPoint.func_82617_b() > 0.8125) {
                side = Direction.DOWN;
            }
        }
        Direction facing = context.func_195992_f();
        if (this.getBlockType() == BlockType.FRAMED_INNER_CORNER_SLOPE && side.func_176740_k() == Direction.Axis.Y) {
            facing = facing.func_176735_f();
        }
        state = (BlockState)state.func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)facing);
        if (side == Direction.DOWN) {
            state = (BlockState)state.func_206870_a(PropertyHolder.CORNER_TYPE, (Comparable)((Object)CornerType.TOP));
        } else if (side == Direction.UP) {
            state = (BlockState)state.func_206870_a(PropertyHolder.CORNER_TYPE, (Comparable)((Object)CornerType.BOTTOM));
        } else {
            boolean xAxis = context.func_196000_l().func_176740_k() == Direction.Axis.X;
            boolean positive = context.func_196000_l().func_176735_f().func_176743_c() == Direction.AxisDirection.POSITIVE;
            double xz = xAxis ? hitPoint.func_82616_c() : hitPoint.func_82615_a();
            double y = hitPoint.func_82617_b();
            CornerType type = xz > 0.5 == positive ? (y > 0.5 ? CornerType.HORIZONTAL_TOP_RIGHT : CornerType.HORIZONTAL_BOTTOM_RIGHT) : (y > 0.5 ? CornerType.HORIZONTAL_TOP_LEFT : CornerType.HORIZONTAL_BOTTOM_LEFT);
            state = (BlockState)state.func_206870_a(PropertyHolder.CORNER_TYPE, (Comparable)((Object)type));
        }
        return this.withWater(state, (IWorldReader)context.func_195991_k(), context.func_195995_a());
    }

    public static ImmutableMap<BlockState, VoxelShape> generateCornerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            CornerType type = (CornerType)((Object)state.func_177229_b(PropertyHolder.CORNER_TYPE));
            Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
            if (type.isHorizontal()) {
                VoxelShape shapeBottomLeft = VoxelShapes.func_216384_a((VoxelShape)FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)4.0, (double)0.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)8.0, (double)0.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)12.0, (double)12.0, (double)0.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)0.0)}).func_197753_c();
                VoxelShape shapeBottomRight = VoxelShapes.func_216384_a((VoxelShape)FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), FramedCornerSlopeBlock.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), FramedCornerSlopeBlock.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0)}).func_197753_c();
                VoxelShape shapeTopLeft = VoxelShapes.func_216384_a((VoxelShape)FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)12.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0)}).func_197753_c();
                VoxelShape shapeTopRight = VoxelShapes.func_216384_a((VoxelShape)FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), FramedCornerSlopeBlock.func_208617_a((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0), FramedCornerSlopeBlock.func_208617_a((double)12.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)}).func_197753_c();
                VoxelShape shape = VoxelShapes.func_197868_b();
                switch (type) {
                    case HORIZONTAL_BOTTOM_LEFT: {
                        shape = shapeBottomLeft;
                        break;
                    }
                    case HORIZONTAL_BOTTOM_RIGHT: {
                        shape = shapeBottomRight;
                        break;
                    }
                    case HORIZONTAL_TOP_LEFT: {
                        shape = shapeTopLeft;
                        break;
                    }
                    case HORIZONTAL_TOP_RIGHT: {
                        shape = shapeTopRight;
                    }
                }
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shape));
                continue;
            }
            if (type.isTop()) {
                VoxelShape shapeTop = VoxelShapes.func_216384_a((VoxelShape)FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)4.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)12.0, (double)12.0, (double)12.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)}).func_197753_c();
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeTop));
                continue;
            }
            VoxelShape shapeBottom = VoxelShapes.func_216384_a((VoxelShape)FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)12.0, (double)8.0, (double)12.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)8.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0)}).func_197753_c();
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeBottom));
        }
        return builder.build();
    }

    public static ImmutableMap<BlockState, VoxelShape> generateInnerCornerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            CornerType type = (CornerType)((Object)state.func_177229_b(PropertyHolder.CORNER_TYPE));
            Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
            if (type.isHorizontal()) {
                VoxelShape shapeBottomLeft = VoxelShapes.func_216384_a((VoxelShape)FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)12.0, (double)8.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)12.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0, (double)16.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)12.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)8.0)}).func_197753_c();
                VoxelShape shapeBottomRight = VoxelShapes.func_216384_a((VoxelShape)FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)12.0, (double)8.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)12.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0, (double)16.0), FramedCornerSlopeBlock.func_208617_a((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)12.0), FramedCornerSlopeBlock.func_208617_a((double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), FramedCornerSlopeBlock.func_208617_a((double)4.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0, (double)8.0)}).func_197753_c();
                VoxelShape shapeTopLeft = VoxelShapes.func_216384_a((VoxelShape)FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)16.0, (double)8.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)12.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)12.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)12.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)8.0)}).func_197753_c();
                VoxelShape shapeTopRight = VoxelShapes.func_216384_a((VoxelShape)FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)16.0, (double)8.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)12.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)12.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), FramedCornerSlopeBlock.func_208617_a((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)12.0), FramedCornerSlopeBlock.func_208617_a((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)12.0, (double)16.0), FramedCornerSlopeBlock.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0, (double)8.0)}).func_197753_c();
                VoxelShape shape = VoxelShapes.func_197868_b();
                switch (type) {
                    case HORIZONTAL_BOTTOM_LEFT: {
                        shape = shapeBottomLeft;
                        break;
                    }
                    case HORIZONTAL_BOTTOM_RIGHT: {
                        shape = shapeBottomRight;
                        break;
                    }
                    case HORIZONTAL_TOP_LEFT: {
                        shape = shapeTopLeft;
                        break;
                    }
                    case HORIZONTAL_TOP_RIGHT: {
                        shape = shapeTopRight;
                    }
                }
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shape));
                continue;
            }
            if (type.isTop()) {
                VoxelShape shapeTop = VoxelShapes.func_216384_a((VoxelShape)FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)4.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.func_208617_a((double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0, (double)16.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), FramedCornerSlopeBlock.func_208617_a((double)8.0, (double)4.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)12.0), FramedCornerSlopeBlock.func_208617_a((double)4.0, (double)8.0, (double)12.0, (double)16.0, (double)12.0, (double)16.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)}).func_197753_c();
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeTop));
                continue;
            }
            VoxelShape shapeBottom = VoxelShapes.func_216384_a((VoxelShape)FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), FramedCornerSlopeBlock.func_208617_a((double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)8.0, (double)16.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), FramedCornerSlopeBlock.func_208617_a((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)12.0, (double)16.0), FramedCornerSlopeBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), FramedCornerSlopeBlock.func_208617_a((double)12.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0)}).func_197753_c();
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeBottom));
        }
        return builder.build();
    }
}

