/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.tileentity.FramedDoubleCornerTileEntity;
import xfacthd.framedblocks.common.tileentity.FramedDoubleTileEntity;
import xfacthd.framedblocks.common.util.CtmPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class FramedDoubleCornerBlock
extends AbstractFramedDoubleBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, side) -> {
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        CornerType type = (CornerType)((Object)((Object)state.func_177229_b(PropertyHolder.CORNER_TYPE)));
        if (type.isHorizontal()) {
            if (side == null) {
                return false;
            }
            return side == dir || side == dir.func_176734_d() || side == dir.func_176735_f() && !type.isRight() || side == dir.func_176746_e() && type.isRight() || side == Direction.DOWN && !type.isTop() || side == Direction.UP && type.isTop();
        }
        return side != null && side.func_176740_k() == Direction.Axis.Y || side == dir || side == dir.func_176735_f();
    };

    public FramedDoubleCornerBlock() {
        super(BlockType.FRAMED_DOUBLE_CORNER);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PropertyHolder.FACING_HOR, PropertyHolder.CORNER_TYPE});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        Direction side = context.func_196000_l();
        Vector3d hitPoint = Utils.fraction(context.func_221532_j());
        if (side.func_176740_k() != Direction.Axis.Y) {
            if (hitPoint.func_82617_b() < 0.1875) {
                side = Direction.UP;
            } else if (hitPoint.func_82617_b() > 0.8125) {
                side = Direction.DOWN;
            }
        }
        Direction facing = context.func_195992_f();
        state = (BlockState)state.func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)facing);
        if (side == Direction.DOWN) {
            state = (BlockState)state.func_206870_a(PropertyHolder.CORNER_TYPE, (Comparable)((Object)CornerType.TOP));
        } else if (side == Direction.UP) {
            state = (BlockState)state.func_206870_a(PropertyHolder.CORNER_TYPE, (Comparable)((Object)CornerType.BOTTOM));
        } else {
            boolean xAxis = context.func_196000_l().func_176740_k() == Direction.Axis.X;
            boolean positive = context.func_196000_l().func_176735_f().func_176743_c() == Direction.AxisDirection.POSITIVE;
            double xz = xAxis ? hitPoint.func_82616_c() : hitPoint.func_82615_a();
            double y = hitPoint.func_82617_b();
            CornerType type = xz > 0.5 == positive ? (y > 0.5 ? CornerType.HORIZONTAL_TOP_RIGHT : CornerType.HORIZONTAL_BOTTOM_RIGHT) : (y > 0.5 ? CornerType.HORIZONTAL_TOP_LEFT : CornerType.HORIZONTAL_BOTTOM_LEFT);
            state = (BlockState)state.func_206870_a(PropertyHolder.CORNER_TYPE, (Comparable)((Object)type));
        }
        return state;
    }

    @Override
    public SoundType getSound(BlockState state, IWorldReader world, BlockPos pos) {
        CornerType type = (CornerType)((Object)state.func_177229_b(PropertyHolder.CORNER_TYPE));
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedDoubleTileEntity) {
            BlockState camoState;
            FramedDoubleTileEntity dte = (FramedDoubleTileEntity)te;
            BlockState blockState = camoState = type.isHorizontal() || type.isTop() ? dte.getCamoState() : dte.getCamoStateTwo();
            if (!camoState.func_196958_f()) {
                return camoState.func_215695_r();
            }
            BlockState blockState2 = camoState = type.isHorizontal() || type.isTop() ? dte.getCamoStateTwo() : dte.getCamoState();
            if (!camoState.func_196958_f()) {
                return camoState.func_215695_r();
            }
        }
        return this.func_220072_p(state);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FramedDoubleCornerTileEntity();
    }
}

