/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;
import xfacthd.framedblocks.common.tileentity.FramedDoubleSlopeTileEntity;
import xfacthd.framedblocks.common.tileentity.FramedDoubleTileEntity;
import xfacthd.framedblocks.common.util.CtmPredicate;

public class FramedDoubleSlopeBlock
extends AbstractFramedDoubleBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, dir) -> {
        if (state.func_177229_b(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return dir != null && dir.func_176740_k() != Direction.Axis.Y;
        }
        Direction facing = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        return dir != null && dir.func_176740_k() == Direction.Axis.Y || dir == facing || dir == facing.func_176734_d();
    };

    public FramedDoubleSlopeBlock() {
        super(BlockType.FRAMED_DOUBLE_SLOPE);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PropertyHolder.FACING_HOR, PropertyHolder.SLOPE_TYPE});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.withSlopeType(this.func_176223_P(), context.func_196000_l(), context.func_195992_f(), context.func_221532_j());
    }

    @Override
    public SoundType getSound(BlockState state, IWorldReader world, BlockPos pos) {
        SlopeType type = (SlopeType)((Object)state.func_177229_b(PropertyHolder.SLOPE_TYPE));
        if (type != SlopeType.HORIZONTAL) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof FramedDoubleTileEntity) {
                BlockState camoState;
                FramedDoubleTileEntity dte = (FramedDoubleTileEntity)te;
                BlockState blockState = camoState = type == SlopeType.TOP ? dte.getCamoState() : dte.getCamoStateTwo();
                if (!camoState.func_196958_f()) {
                    return camoState.func_215695_r();
                }
                BlockState blockState2 = camoState = type == SlopeType.TOP ? dte.getCamoStateTwo() : dte.getCamoState();
                if (!camoState.func_196958_f()) {
                    return camoState.func_215695_r();
                }
            }
            return this.func_220072_p(state);
        }
        return super.getSound(state, world, pos);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FramedDoubleSlopeTileEntity();
    }
}

