/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;
import xfacthd.framedblocks.common.util.Utils;

public class FramedPaneBlock
extends PaneBlock
implements IFramedBlock {
    private final BlockType type;

    public FramedPaneBlock(BlockType type) {
        super(IFramedBlock.createProperties());
        this.type = type;
    }

    public final ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ActionResultType result = this.handleBlockActivated(world, pos, player, hand, hit);
        if (result.func_226246_a_()) {
            return result;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(world, pos, placer, stack);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return this.getLight(world, pos);
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        return this.getSound(state, world, pos);
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        return this.getCamoBlastResistance(state, world, pos, explosion);
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.isCamoFlammable(world, pos, face);
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.getCamoFlammability(world, pos, face);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return this.getDrops(super.func_220076_a(state, builder), builder);
    }

    public float getSlipperiness(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return this.getCamoSlipperiness(state, world, pos, entity);
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentState, Direction side) {
        return this == FBContent.blockFramedBars.get() && super.func_200122_a(state, adjacentState, side);
    }

    public final boolean hasTileEntity(BlockState state) {
        return true;
    }

    public final TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FramedTileEntity();
    }

    @Override
    public BlockType getBlockType() {
        return this.type;
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape center = FramedPaneBlock.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
        VoxelShape wing = FramedPaneBlock.func_208617_a((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)7.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            boolean north = (Boolean)state.func_177229_b((Property)field_196409_a);
            boolean east = (Boolean)state.func_177229_b((Property)field_196411_b);
            boolean south = (Boolean)state.func_177229_b((Property)field_196413_c);
            boolean west = (Boolean)state.func_177229_b((Property)field_196414_y);
            VoxelShape shape = center;
            if (north) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)wing, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (east) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.EAST, wing), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (south) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.SOUTH, wing), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (west) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.WEST, wing), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            builder.put((Object)state, (Object)shape.func_197753_c());
        }
        return builder.build();
    }
}

