/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.tileentity.FramedDoubleTileEntity;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;
import xfacthd.framedblocks.common.util.CtmPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class FramedPanelBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, dir) -> state.func_177229_b((Property)PropertyHolder.FACING_HOR) == dir;

    public FramedPanelBlock() {
        super(BlockType.FRAMED_PANEL);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PropertyHolder.FACING_HOR, BlockStateProperties.field_208198_y});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        Direction face = context.func_196000_l();
        state = face.func_176740_k().func_176722_c() ? (BlockState)state.func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)face.func_176734_d()) : (BlockState)state.func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)context.func_195992_f());
        return this.withWater(state, (IWorldReader)context.func_195991_k(), context.func_195995_a());
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == ((Block)FBContent.blockFramedPanel.get()).func_199767_j()) {
            Direction facing = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
            if (hit.func_216354_b() == facing.func_176734_d()) {
                if (!world.func_201670_d()) {
                    BlockState camoState = Blocks.field_150350_a.func_176223_P();
                    ItemStack camoStack = ItemStack.field_190927_a;
                    boolean glowing = false;
                    TileEntity te = world.func_175625_s(pos);
                    if (te instanceof FramedTileEntity) {
                        camoState = ((FramedTileEntity)te).getCamoState();
                        camoStack = ((FramedTileEntity)te).getCamoStack();
                        glowing = ((FramedTileEntity)te).isGlowing();
                    }
                    Direction newFacing = facing == Direction.NORTH || facing == Direction.EAST ? facing : facing.func_176734_d();
                    BlockState newState = ((Block)FBContent.blockFramedDoublePanel.get()).func_176223_P();
                    world.func_175656_a(pos, (BlockState)newState.func_206870_a((Property)PropertyHolder.FACING_NE, (Comparable)newFacing));
                    SoundType sound = ((Block)FBContent.blockFramedCube.get()).func_220072_p(((Block)FBContent.blockFramedCube.get()).func_176223_P());
                    world.func_184133_a(null, pos, sound.func_185841_e(), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                        player.field_71071_by.func_70296_d();
                    }
                    if ((te = world.func_175625_s(pos)) instanceof FramedDoubleTileEntity) {
                        ((FramedDoubleTileEntity)te).setCamo(camoStack, camoState, facing != newFacing);
                        ((FramedDoubleTileEntity)te).setGlowing(glowing);
                    }
                }
                return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
            }
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shape = FramedPanelBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shape));
        }
        return builder.build();
    }
}

