/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IWorldReader;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;
import xfacthd.framedblocks.common.util.CtmPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class FramedSlopeBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, dir) -> {
        SlopeType type = (SlopeType)((Object)((Object)state.func_177229_b(PropertyHolder.SLOPE_TYPE)));
        if (dir == Direction.UP && type == SlopeType.TOP) {
            return true;
        }
        if (dir == Direction.DOWN && type == SlopeType.BOTTOM) {
            return true;
        }
        if (type == SlopeType.HORIZONTAL) {
            Direction facing = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
            return dir == facing || dir == facing.func_176735_f();
        }
        return state.func_177229_b((Property)PropertyHolder.FACING_HOR) == dir;
    };

    public FramedSlopeBlock() {
        super(BlockType.FRAMED_SLOPE);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PropertyHolder.FACING_HOR, PropertyHolder.SLOPE_TYPE, BlockStateProperties.field_208198_y});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.withSlopeType(this.func_176223_P(), context.func_196000_l(), context.func_195992_f(), context.func_221532_j());
        return this.withWater(state, (IWorldReader)context.func_195991_k(), context.func_195995_a());
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shapeBottom = VoxelShapes.func_216384_a((VoxelShape)FramedSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopeBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), FramedSlopeBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), FramedSlopeBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)}).func_197753_c();
        VoxelShape shapeTop = VoxelShapes.func_216384_a((VoxelShape)FramedSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)4.0), (VoxelShape[])new VoxelShape[]{FramedSlopeBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), FramedSlopeBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)12.0), FramedSlopeBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)}).func_197753_c();
        VoxelShape shapeHorizontal = VoxelShapes.func_216384_a((VoxelShape)FramedSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopeBlock.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)12.0), FramedSlopeBlock.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0), FramedSlopeBlock.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)}).func_197753_c();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            SlopeType type = (SlopeType)((Object)state.func_177229_b(PropertyHolder.SLOPE_TYPE));
            Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
            if (type == SlopeType.BOTTOM) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeBottom));
                continue;
            }
            if (type == SlopeType.TOP) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeTop));
                continue;
            }
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeHorizontal));
        }
        return builder.build();
    }
}

