/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.container;

import com.google.common.base.Preconditions;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.tileentity.FramedChestTileEntity;

public class FramedChestContainer
extends Container {
    private final FramedChestTileEntity chest;

    public FramedChestContainer(int windowId, PlayerInventory inv, TileEntity chest) {
        super((ContainerType)FBContent.containerTypeFramedChest.get(), windowId);
        Preconditions.checkArgument((boolean)(chest instanceof FramedChestTileEntity));
        this.chest = (FramedChestTileEntity)chest;
        this.chest.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 9; ++col) {
                    this.func_75146_a((Slot)new SlotItemHandler(handler, col + row * 9, 8 + col * 18, 18 + row * 18));
                }
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)inv, col + row * 9 + 9, 8 + col * 18, 85 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)inv, col, 8 + col * 18, 143));
        }
    }

    public FramedChestContainer(int windowId, PlayerInventory inv, PacketBuffer extraData) {
        this(windowId, inv, inv.field_70458_d.field_70170_p.func_175625_s(extraData.func_179259_c()));
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.chest.isUsableByPlayer(player);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack remainder = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            remainder = stack.func_77946_l();
            if (index < 36 ? !this.func_75135_a(stack, 36, this.field_75151_b.size(), true) : !this.func_75135_a(stack, 0, 36, false)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return remainder;
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        if (!this.chest.func_145831_w().func_201670_d()) {
            this.chest.close();
        }
    }
}

