/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import xfacthd.framedblocks.common.block.FramedCornerPillarBlock;
import xfacthd.framedblocks.common.block.FramedCornerSlopeBlock;
import xfacthd.framedblocks.common.block.FramedDoorBlock;
import xfacthd.framedblocks.common.block.FramedDoubleCornerBlock;
import xfacthd.framedblocks.common.block.FramedDoublePanelBlock;
import xfacthd.framedblocks.common.block.FramedDoubleSlopeBlock;
import xfacthd.framedblocks.common.block.FramedDoubleThreewayCornerBlock;
import xfacthd.framedblocks.common.block.FramedFenceBlock;
import xfacthd.framedblocks.common.block.FramedFloorBlock;
import xfacthd.framedblocks.common.block.FramedGateBlock;
import xfacthd.framedblocks.common.block.FramedLatticeBlock;
import xfacthd.framedblocks.common.block.FramedPaneBlock;
import xfacthd.framedblocks.common.block.FramedPanelBlock;
import xfacthd.framedblocks.common.block.FramedPrismCornerBlock;
import xfacthd.framedblocks.common.block.FramedSlabBlock;
import xfacthd.framedblocks.common.block.FramedSlabCornerBlock;
import xfacthd.framedblocks.common.block.FramedSlabEdgeBlock;
import xfacthd.framedblocks.common.block.FramedSlopeBlock;
import xfacthd.framedblocks.common.block.FramedStairsBlock;
import xfacthd.framedblocks.common.block.FramedThreewayCornerBlock;
import xfacthd.framedblocks.common.block.FramedTrapDoorBlock;
import xfacthd.framedblocks.common.block.FramedVerticalStairs;
import xfacthd.framedblocks.common.block.FramedWallBlock;
import xfacthd.framedblocks.common.block.FramedWallSignBlock;
import xfacthd.framedblocks.common.data.skippreds.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.CornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.InnerCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.InnerThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.PaneSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.PanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.ThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.VerticalStairsSkipPredicate;
import xfacthd.framedblocks.common.util.CtmPredicate;
import xfacthd.framedblocks.common.util.SideSkipPredicate;
import xfacthd.framedblocks.common.util.VoxelShapeGenerator;

public enum BlockType {
    FRAMED_CUBE(false, false, false, true, CtmPredicate.TRUE, SideSkipPredicate.CTM, VoxelShapes.func_197868_b()),
    FRAMED_SLOPE(true, false, true, true, FramedSlopeBlock.CTM_PREDICATE, (SideSkipPredicate)new SlopeSkipPredicate(), FramedSlopeBlock::generateShapes),
    FRAMED_CORNER_SLOPE(true, false, true, true, FramedCornerSlopeBlock.CTM_PREDICATE, (SideSkipPredicate)new CornerSkipPredicate(), FramedCornerSlopeBlock::generateCornerShapes),
    FRAMED_INNER_CORNER_SLOPE(true, false, true, true, FramedCornerSlopeBlock.CTM_PREDICATE_INNER, (SideSkipPredicate)new InnerCornerSkipPredicate(), FramedCornerSlopeBlock::generateInnerCornerShapes),
    FRAMED_PRISM_CORNER(true, false, true, true, CtmPredicate.FALSE, (SideSkipPredicate)new ThreewayCornerSkipPredicate(), FramedPrismCornerBlock::generatePrismShapes),
    FRAMED_INNER_PRISM_CORNER(true, false, true, true, FramedThreewayCornerBlock.CTM_PREDICATE, (SideSkipPredicate)new InnerThreewayCornerSkipPredicate(), FramedPrismCornerBlock::generateInnerPrismShapes),
    FRAMED_THREEWAY_CORNER(true, false, true, true, CtmPredicate.FALSE, (SideSkipPredicate)new ThreewayCornerSkipPredicate(), FramedThreewayCornerBlock::generateThreewayShapes),
    FRAMED_INNER_THREEWAY_CORNER(true, false, true, true, FramedThreewayCornerBlock.CTM_PREDICATE, (SideSkipPredicate)new InnerThreewayCornerSkipPredicate(), FramedThreewayCornerBlock::generateInnerThreewayShapes),
    FRAMED_SLAB(false, false, true, true, FramedSlabBlock.CTM_PREDICATE, (SideSkipPredicate)new SlabSkipPredicate(), FramedSlabBlock::generateShapes),
    FRAMED_SLAB_EDGE(false, false, true, true, CtmPredicate.FALSE, (SideSkipPredicate)new SlabEdgeSkipPredicate(), FramedSlabEdgeBlock::generateShapes),
    FRAMED_SLAB_CORNER(false, false, true, true, CtmPredicate.FALSE, (SideSkipPredicate)new SlabCornerSkipPredicate(), FramedSlabCornerBlock::generateShapes),
    FRAMED_PANEL(false, false, true, true, FramedPanelBlock.CTM_PREDICATE, (SideSkipPredicate)new PanelSkipPredicate(), FramedPanelBlock::generateShapes),
    FRAMED_CORNER_PILLAR(false, false, true, true, CtmPredicate.FALSE, (SideSkipPredicate)new CornerPillarSkipPredicate(), FramedCornerPillarBlock::generateShapes),
    FRAMED_STAIRS(false, false, true, true, FramedStairsBlock.CTM_PREDICATE, new StairsSkipPredicate()),
    FRAMED_WALL(false, false, true, true, CtmPredicate.FALSE, FramedWallBlock.SKIP_PREDICATE),
    FRAMED_FENCE(false, false, true, true, CtmPredicate.FALSE, FramedFenceBlock.SKIP_PREDICATE),
    FRAMED_GATE(false, false, true, true, CtmPredicate.FALSE, FramedGateBlock.SKIP_PREDICATE),
    FRAMED_DOOR(false, false, false, true, FramedDoorBlock.CTM_PREDICATE, SideSkipPredicate.CTM),
    FRAMED_TRAPDOOR(false, false, true, true, FramedTrapDoorBlock.CTM_PREDICATE, SideSkipPredicate.CTM),
    FRAMED_PRESSURE_PLATE(false, false, false, true),
    FRAMED_LADDER(false, false, true, true),
    FRAMED_BUTTON(false, false, false, true),
    FRAMED_LEVER(false, false, false, true),
    FRAMED_SIGN(false, true, false, true),
    FRAMED_WALL_SIGN(false, true, false, false, CtmPredicate.FALSE, SideSkipPredicate.FALSE, FramedWallSignBlock::generateShapes),
    FRAMED_DOUBLE_SLAB(false, true, false, true, CtmPredicate.Y_AXIS, SideSkipPredicate.FALSE, VoxelShapes.func_197868_b()),
    FRAMED_DOUBLE_PANEL(false, true, false, true, FramedDoublePanelBlock.CTM_PREDICATE, SideSkipPredicate.FALSE, VoxelShapes.func_197868_b()),
    FRAMED_DOUBLE_SLOPE(false, true, false, true, FramedDoubleSlopeBlock.CTM_PREDICATE, SideSkipPredicate.FALSE, VoxelShapes.func_197868_b()),
    FRAMED_DOUBLE_CORNER(false, true, false, true, FramedDoubleCornerBlock.CTM_PREDICATE, SideSkipPredicate.FALSE, VoxelShapes.func_197868_b()),
    FRAMED_DOUBLE_PRISM_CORNER(false, true, false, true, FramedDoubleThreewayCornerBlock.CTM_PREDICATE, SideSkipPredicate.FALSE, VoxelShapes.func_197868_b()),
    FRAMED_DOUBLE_THREEWAY_CORNER(false, true, false, true, FramedDoubleThreewayCornerBlock.CTM_PREDICATE, SideSkipPredicate.FALSE, VoxelShapes.func_197868_b()),
    FRAMED_TORCH(false, false, false, true),
    FRAMED_WALL_TORCH(false, false, false, false),
    FRAMED_SOUL_TORCH(false, false, false, true),
    FRAMED_SOUL_WALL_TORCH(false, false, false, false),
    FRAMED_FLOOR_BOARD(false, false, true, true, FramedFloorBlock.CTM_PREDICATE, FramedFloorBlock.SKIP_PREDICATE, VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0)),
    FRAMED_LATTICE_BLOCK(false, false, true, true, CtmPredicate.FALSE, FramedLatticeBlock.SKIP_PREDICATE, FramedLatticeBlock::generateShapes),
    FRAMED_VERTICAL_STAIRS(false, false, true, true, FramedVerticalStairs.CTM_PREDICATE, (SideSkipPredicate)new VerticalStairsSkipPredicate(), FramedVerticalStairs::generateShapes),
    FRAMED_CHEST(false, true, true, true, CtmPredicate.FALSE, SideSkipPredicate.FALSE, VoxelShapes.func_197873_a((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.875, (double)0.9375)),
    FRAMED_BARS(false, false, true, true, CtmPredicate.FALSE, SideSkipPredicate.FALSE, FramedPaneBlock::generateShapes),
    FRAMED_PANE(false, false, true, true, CtmPredicate.FALSE, (SideSkipPredicate)new PaneSkipPredicate(), FramedPaneBlock::generateShapes),
    FRAMED_COLLAPSIBLE_BLOCK(true, true, false, true);

    private final String name = this.toString().toLowerCase(Locale.ROOT);
    private final boolean specialHitbox;
    private final boolean specialTile;
    private final boolean waterloggable;
    private final boolean blockItem;
    private final CtmPredicate ctmPredicate;
    private final SideSkipPredicate skipPredicate;
    private final VoxelShapeGenerator shapeGen;

    private BlockType(boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem) {
        this(specialHitbox, specialTile, waterloggable, blockItem, CtmPredicate.FALSE, SideSkipPredicate.FALSE, VoxelShapeGenerator.EMTPTY);
    }

    private BlockType(boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, CtmPredicate ctmPredicate, SideSkipPredicate skipPredicate) {
        this(specialHitbox, specialTile, waterloggable, blockItem, ctmPredicate, skipPredicate, VoxelShapeGenerator.EMTPTY);
    }

    private BlockType(boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, CtmPredicate ctmPredicate, SideSkipPredicate skipPredicate, VoxelShape shape) {
        this(specialHitbox, specialTile, waterloggable, blockItem, ctmPredicate, skipPredicate, VoxelShapeGenerator.singleShape(shape));
    }

    private BlockType(boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, CtmPredicate ctmPredicate, SideSkipPredicate skipPredicate, VoxelShapeGenerator shapeGen) {
        this.specialHitbox = specialHitbox;
        this.specialTile = specialTile;
        this.waterloggable = waterloggable;
        this.blockItem = blockItem;
        this.ctmPredicate = ctmPredicate;
        this.skipPredicate = skipPredicate;
        this.shapeGen = shapeGen;
    }

    public boolean hasSpecialHitbox() {
        return this.specialHitbox;
    }

    public CtmPredicate getCtmPredicate() {
        return this.ctmPredicate;
    }

    public SideSkipPredicate getSideSkipPredicate() {
        return this.skipPredicate;
    }

    public ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        return this.shapeGen.generate(states);
    }

    public boolean hasSpecialTile() {
        return this.specialTile;
    }

    public boolean hasBlockItem() {
        return this.blockItem;
    }

    public boolean supportsWaterLogging() {
        return this.waterloggable;
    }

    public String getName() {
        return this.name;
    }
}

