/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class CornerPillarSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (adjState.func_177230_c() == FBContent.blockFramedPanel.get()) {
            return this.testAgainstPanel(world, pos, dir, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedCornerPillar.get()) {
            return this.testAgainstPillar(world, pos, dir, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedSlabCorner.get()) {
            return this.testAgainstCorner(world, pos, dir, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedDoublePanel.get()) {
            return this.testAgainstDoublePanel(world, pos, dir, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedStairs.get() && side.func_176740_k() == Direction.Axis.Y) {
            return this.testAgainstStairs(world, pos, dir, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedVerticalStairs.get()) {
            return this.testAgainstVerticalStairs(world, pos, dir, adjState, side);
        }
        return false;
    }

    private boolean testAgainstPanel(IBlockReader world, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        if (side != dir && side != dir.func_176735_f()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (side == dir && adjDir == dir.func_176735_f() || side == dir.func_176735_f() && dir == adjDir) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstPillar(IBlockReader world, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (side == dir && adjDir == dir.func_176735_f() || side == dir.func_176735_f() && adjDir == dir.func_176746_e()) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstCorner(IBlockReader world, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (adjTop && side == Direction.DOWN || !adjTop && side == Direction.UP) {
            return dir == adjDir && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstDoublePanel(IBlockReader world, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_NE);
        if (side == dir && (adjDir == dir.func_176746_e() || adjDir == dir.func_176735_f())) {
            return SideSkipPredicate.compareState(world, pos, side, dir.func_176735_f());
        }
        if (side == dir.func_176735_f() && (adjDir == dir || adjDir == dir.func_176734_d())) {
            return SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstStairs(IBlockReader world, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.func_177229_b((Property)BlockStateProperties.field_208157_J);
        StairsShape adjShape = (StairsShape)adjState.func_177229_b((Property)BlockStateProperties.field_208146_au);
        boolean bl = adjTop = adjState.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.TOP;
        if (adjTop && side == Direction.UP || !adjTop && side == Direction.DOWN) {
            if (adjShape == StairsShape.OUTER_LEFT) {
                return dir == adjDir && SideSkipPredicate.compareState(world, pos, side);
            }
            if (adjShape == StairsShape.OUTER_RIGHT) {
                return dir.func_176735_f() == adjDir && SideSkipPredicate.compareState(world, pos, side);
            }
        }
        return false;
    }

    private boolean testAgainstVerticalStairs(IBlockReader world, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.func_177229_b(PropertyHolder.STAIRS_TYPE));
        if (adjType == StairsType.VERTICAL ? (side == dir.func_176735_f() || side == dir) && adjDir == dir : side.func_176740_k() == Direction.Axis.Y && side == Direction.DOWN == adjType.isTop() && adjDir == dir) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }
}

