/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class CornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (SideSkipPredicate.CTM.test(world, pos, state, adjState, side)) {
            return true;
        }
        if (!(adjState.func_177230_c() instanceof IFramedBlock)) {
            return false;
        }
        BlockType adjBlock = ((IFramedBlock)adjState.func_177230_c()).getBlockType();
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        CornerType type = (CornerType)((Object)state.func_177229_b(PropertyHolder.CORNER_TYPE));
        if (adjBlock == BlockType.FRAMED_CORNER_SLOPE) {
            return this.testAgainstCorner(world, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_CORNER) {
            return this.testAgainstDoubleCorner(world, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_SLOPE) {
            return this.testAgainstSlope(world, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_SLOPE) {
            return this.testAgainstDoubleSlope(world, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_INNER_CORNER_SLOPE) {
            return this.testAgainstInnerCorner(world, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_PRISM_CORNER || adjBlock == BlockType.FRAMED_THREEWAY_CORNER) {
            return this.testAgainstThreewayCorner(world, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_INNER_PRISM_CORNER || adjBlock == BlockType.FRAMED_INNER_THREEWAY_CORNER) {
            return this.testAgainstInnerThreewayCorner(world, pos, dir, type, adjBlock, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_PRISM_CORNER || adjBlock == BlockType.FRAMED_DOUBLE_THREEWAY_CORNER) {
            return this.testAgainstDoubleThreewayCorner(world, pos, dir, type, adjState, side);
        }
        return false;
    }

    private boolean testAgainstCorner(IBlockReader world, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.func_177229_b(PropertyHolder.CORNER_TYPE));
        if (!type.isHorizontal() && adjType == type && (side == dir && adjDir == dir.func_176735_f() || side == dir.func_176735_f() && adjDir == dir.func_176746_e())) {
            return SideSkipPredicate.compareState(world, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
        }
        if (type.isHorizontal() && type.isHorizontalAdjacent(dir, side, adjType) && adjDir == dir) {
            return SideSkipPredicate.compareState(world, pos, side, dir);
        }
        if (!type.isHorizontal() && adjType.isHorizontal() && adjType.isTop() == type.isTop() && (side == dir && !adjType.isRight() && adjDir == dir.func_176735_f() || side == dir.func_176735_f() && adjType.isRight() && adjDir == dir)) {
            return SideSkipPredicate.compareState(world, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
        }
        if (type.isHorizontal() && !adjType.isHorizontal() && adjType.isTop() == type.isTop() && (!type.isRight() && side == dir.func_176735_f() && adjDir == dir.func_176746_e() || type.isRight() && side == dir.func_176746_e() && adjDir == dir)) {
            return SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstDoubleCorner(IBlockReader world, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.func_177229_b(PropertyHolder.CORNER_TYPE));
        if (!adjType.isHorizontal() && !type.isHorizontal()) {
            if (adjType.isTop() == type.isTop() && adjDir == dir && (side == dir || side == dir.func_176735_f())) {
                return SideSkipPredicate.compareState(world, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
            }
            if (adjType.isTop() != type.isTop() && (side == dir && adjDir == dir.func_176746_e() || side == dir.func_176735_f() && adjDir == dir.func_176735_f())) {
                return SideSkipPredicate.compareState(world, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
            }
        } else if (type.isHorizontal() && !adjType.isHorizontal()) {
            if (adjDir == dir && side == dir.func_176735_f() && !type.isRight() && adjType.isTop() == type.isTop() || adjDir == dir.func_176734_d() && side == dir.func_176746_e() && type.isRight() && adjType.isTop() != type.isTop()) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
            if (adjDir == dir.func_176735_f() && side == dir.func_176735_f() && !type.isRight() && adjType.isTop() != type.isTop() || adjDir == dir.func_176746_e() && side == dir.func_176746_e() && type.isRight() && adjType.isTop() == type.isTop()) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
        } else if (!type.isHorizontal()) {
            if (side == dir.func_176735_f() && adjDir == dir && !adjType.isRight() || side == dir && adjDir == dir.func_176735_f() && adjType.isRight()) {
                return adjType.isTop() == type.isTop() && SideSkipPredicate.compareState(world, pos, side, adjDir);
            }
            if (side == dir.func_176735_f() && adjDir == dir.func_176734_d() && adjType.isRight() || side == dir && adjDir == dir.func_176746_e() && !adjType.isRight()) {
                return adjType.isTop() != type.isTop() && SideSkipPredicate.compareState(world, pos, side, adjDir.func_176734_d());
            }
        } else {
            if (adjDir == dir && type == adjType && (side == dir.func_176746_e() && type.isRight() || side == dir.func_176735_f() && !type.isRight() || side == Direction.UP && type.isTop() || side == Direction.DOWN && !type.isTop())) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
            if (adjDir == dir.func_176734_d() && type.isTop() != adjType.isTop() && type.isRight() != adjType.isRight() && (side == dir.func_176746_e() && type.isRight() || side == dir.func_176735_f() && !type.isRight())) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
            if (adjDir == dir.func_176734_d() && adjType == type && (side == Direction.DOWN && !type.isTop() || side == Direction.UP && type.isTop())) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
        }
        return false;
    }

    private boolean testAgainstSlope(IBlockReader world, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.func_177229_b(PropertyHolder.SLOPE_TYPE));
        if (!type.isHorizontal() && adjType != SlopeType.HORIZONTAL && adjType == SlopeType.TOP == type.isTop()) {
            if (side == dir && adjDir == dir.func_176735_f() || side == dir.func_176735_f() && adjDir == dir) {
                Direction face = type.isTop() ? Direction.UP : Direction.DOWN;
                return SideSkipPredicate.compareState(world, pos, side, face);
            }
        } else if (type.isHorizontal()) {
            if ((side == dir.func_176746_e() && type.isRight() || side == dir.func_176735_f() && !type.isRight()) && adjType == SlopeType.TOP == type.isTop()) {
                return adjDir == dir && SideSkipPredicate.compareState(world, pos, side);
            }
            if (side == Direction.UP && type.isTop() || side == Direction.DOWN && !type.isTop()) {
                return (type.isRight() && adjDir == dir.func_176746_e() || !type.isRight() && adjDir == dir) && SideSkipPredicate.compareState(world, pos, side);
            }
        }
        return false;
    }

    private boolean testAgainstDoubleSlope(IBlockReader world, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.func_177229_b(PropertyHolder.SLOPE_TYPE));
        boolean bl = adjTop = adjType == SlopeType.TOP;
        if (!type.isHorizontal() && adjType != SlopeType.HORIZONTAL && (side == dir && type.isTop() == adjTop && adjDir == dir.func_176735_f() || side == dir && type.isTop() != adjTop && adjDir == dir.func_176746_e() || side == dir.func_176735_f() && type.isTop() == adjTop && adjDir == dir || side == dir.func_176735_f() && type.isTop() != adjTop && adjDir == dir.func_176734_d())) {
            Direction face = type.isTop() ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(world, pos, side, face);
        }
        if (type.isHorizontal() && adjType == SlopeType.HORIZONTAL && (side == Direction.DOWN && !type.isTop() || side == Direction.UP && type.isTop())) {
            if (!type.isRight() && (adjDir == dir || adjDir == dir.func_176734_d()) || type.isRight() && (adjDir == dir.func_176746_e() || adjDir == dir.func_176735_f())) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
        } else if (type.isHorizontal() && adjType != SlopeType.HORIZONTAL && (side == dir.func_176735_f() && !type.isRight() || side == dir.func_176746_e() && type.isRight())) {
            Direction face = type.isTop() == adjTop ? adjDir : adjDir.func_176734_d();
            return (type.isTop() == adjTop && adjDir == dir || type.isTop() != adjTop && adjDir == dir.func_176734_d()) && SideSkipPredicate.compareState(world, pos, side, face);
        }
        return false;
    }

    private boolean testAgainstInnerCorner(IBlockReader world, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.func_177229_b(PropertyHolder.CORNER_TYPE));
        if (!(type.isHorizontal() || adjType != type || adjDir != dir.func_176735_f() || side != dir && side != dir.func_176735_f())) {
            return SideSkipPredicate.compareState(world, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
        }
        if (type.isHorizontal() && adjType == type && (side == Direction.UP && type.isTop() || side == Direction.DOWN && !type.isTop() || side == dir.func_176746_e() && type.isRight() || side == dir.func_176735_f() && !type.isRight())) {
            return SideSkipPredicate.compareState(world, pos, side, dir);
        }
        if (!type.isHorizontal() && adjType.isHorizontal() && adjType.isTop() == type.isTop() && (side == dir && adjType.isRight() && adjDir == dir.func_176735_f() || side == dir.func_176735_f() && !adjType.isRight() && adjDir == dir)) {
            return SideSkipPredicate.compareState(world, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
        }
        if (type.isHorizontal() && !adjType.isHorizontal() && adjType.isTop() == type.isTop() && (!type.isRight() && side == dir.func_176735_f() && adjDir == dir.func_176735_f() || type.isRight() && side == dir.func_176746_e() && adjDir == dir)) {
            return SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstThreewayCorner(IBlockReader world, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (!type.isHorizontal() && type.isTop() == adjTop) {
            if (side == dir && adjDir == dir.func_176735_f() || side == dir.func_176735_f() && adjDir == dir.func_176746_e()) {
                return SideSkipPredicate.compareState(world, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
            }
        } else if (type.isHorizontal()) {
            if (side == dir.func_176746_e() && type.isRight() && adjDir == dir && type.isTop() == adjTop || side == dir.func_176735_f() && !type.isRight() && adjDir == dir.func_176746_e() && type.isTop() == adjTop) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
            if (side.func_176740_k() == Direction.Axis.Y && type.isTop() != adjTop && side == Direction.DOWN == !type.isTop() && (type.isRight() && adjDir == dir.func_176746_e() || !type.isRight() && adjDir == dir)) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
        }
        return false;
    }

    private boolean testAgainstInnerThreewayCorner(IBlockReader world, BlockPos pos, Direction dir, CornerType type, BlockType adjBlock, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (adjBlock == BlockType.FRAMED_INNER_THREEWAY_CORNER) {
            adjDir = adjDir.func_176746_e();
        }
        if (!type.isHorizontal() && type.isTop() == adjTop && adjDir == dir) {
            return (side == dir || side == dir.func_176735_f()) && SideSkipPredicate.compareState(world, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
        }
        if (type.isHorizontal()) {
            if (side.func_176740_k() == Direction.Axis.Y && (!type.isRight() && adjDir == dir || type.isRight() && adjDir == dir.func_176746_e())) {
                return type.isTop() == adjTop && SideSkipPredicate.compareState(world, pos, side, dir);
            }
            if (!type.isRight() && side == dir.func_176735_f() && adjDir == dir || type.isRight() && side == dir.func_176746_e() && adjDir == dir.func_176746_e()) {
                return type.isTop() == adjTop && SideSkipPredicate.compareState(world, pos, side, dir);
            }
        }
        return false;
    }

    private boolean testAgainstDoubleThreewayCorner(IBlockReader world, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (!type.isHorizontal()) {
            if (adjDir == dir && adjTop == type.isTop() && (side == dir || side == dir.func_176735_f())) {
                return SideSkipPredicate.compareState(world, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
            }
            if (adjTop != type.isTop() && (side == dir.func_176735_f() && adjDir == dir.func_176735_f() || side == dir && adjDir == dir.func_176746_e())) {
                return SideSkipPredicate.compareState(world, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
            }
        } else if (adjTop == type.isTop()) {
            if (side == dir.func_176735_f() && adjDir == dir && !type.isRight() || side == dir.func_176746_e() && adjDir == dir.func_176746_e() && type.isRight()) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
            if ((side == Direction.DOWN && !type.isTop() || side == Direction.UP && type.isTop()) && (!type.isRight() && (adjDir == dir || adjDir == dir.func_176734_d()) || type.isRight() && (adjDir == dir.func_176746_e() || adjDir == dir.func_176735_f()))) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
        } else if (side == dir.func_176735_f() && adjDir == dir.func_176735_f() && !type.isRight() || side == dir.func_176746_e() && adjDir == dir.func_176734_d() && type.isRight()) {
            return SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }
}

